/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.code.SourceStackTraceBailoutException;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.LinkedNodeStack;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.NodeStack;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.MultiGuardNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.nodes.spi.LimitedValueProxy;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

public class GraphUtil {
    public static final int MAX_FRAMESTATE_SEARCH_DEPTH = 4;

    private static void killCFGInner(FixedNode node) {
        EconomicSet markedNodes = EconomicSet.create();
        EconomicMap unmarkedMerges = EconomicMap.create();
        node.replaceAtPredecessor(null);
        GraphUtil.markFixedNodes(node, (EconomicSet<Node>)markedNodes, (EconomicMap<AbstractMergeNode, List<AbstractEndNode>>)unmarkedMerges);
        GraphUtil.fixSurvivingAffectedMerges((EconomicSet<Node>)markedNodes, (EconomicMap<AbstractMergeNode, List<AbstractEndNode>>)unmarkedMerges);
        DebugContext debug = node.getDebug();
        debug.dump(4, (Object)node.graph(), "After fixing merges (killCFG %s)", node);
        GraphUtil.markUsagesForKill((EconomicSet<Node>)markedNodes);
        for (Node marked : markedNodes) {
            for (Node input : marked.inputs()) {
                if (markedNodes.contains((Object)input)) continue;
                marked.replaceFirstInput(input, null);
                GraphUtil.tryKillUnused(input);
            }
        }
        debug.dump(5, (Object)node.graph(), "After disconnecting non-marked inputs (killCFG %s)", node);
        for (Node marked : markedNodes) {
            if (!marked.isAlive()) continue;
            marked.markDeleted();
        }
    }

    private static void markFixedNodes(FixedNode node, EconomicSet<Node> markedNodes, EconomicMap<AbstractMergeNode, List<AbstractEndNode>> unmarkedMerges) {
        NodeStack workStack = new NodeStack();
        workStack.push(node);
        while (!workStack.isEmpty()) {
            ArrayList<AbstractEndNode> endsSeen;
            AbstractEndNode end;
            AbstractMergeNode merge;
            Node fixedNode = workStack.pop();
            markedNodes.add((Object)fixedNode);
            if (fixedNode instanceof AbstractMergeNode) {
                unmarkedMerges.removeKey((Object)((AbstractMergeNode)fixedNode));
            }
            while (fixedNode instanceof FixedWithNextNode) {
                if ((fixedNode = ((FixedWithNextNode)fixedNode).next()) == null) continue;
                markedNodes.add((Object)fixedNode);
            }
            if (fixedNode instanceof ControlSplitNode) {
                for (Node successor : fixedNode.successors()) {
                    workStack.push(successor);
                }
                continue;
            }
            if (!(fixedNode instanceof AbstractEndNode) || (merge = (end = (AbstractEndNode)fixedNode).merge()) == null) continue;
            assert (!markedNodes.contains((Object)merge) || merge instanceof LoopBeginNode && end instanceof LoopEndNode) : merge;
            if (merge instanceof LoopBeginNode) {
                if (end == ((LoopBeginNode)merge).forwardEnd()) {
                    workStack.push(merge);
                    continue;
                }
                if (markedNodes.contains((Object)merge)) continue;
            }
            if ((endsSeen = (ArrayList<AbstractEndNode>)unmarkedMerges.get((Object)merge)) == null) {
                endsSeen = new ArrayList<AbstractEndNode>(merge.forwardEndCount());
                unmarkedMerges.put((Object)merge, endsSeen);
            }
            endsSeen.add(end);
            if (end instanceof LoopEndNode || endsSeen.size() != merge.forwardEndCount()) continue;
            assert (merge.forwardEnds().filter(n -> !markedNodes.contains((Object)n)).isEmpty());
            workStack.push(merge);
        }
    }

    private static void fixSurvivingAffectedMerges(EconomicSet<Node> markedNodes, EconomicMap<AbstractMergeNode, List<AbstractEndNode>> unmarkedMerges) {
        MapCursor cursor = unmarkedMerges.getEntries();
        while (cursor.advance()) {
            AbstractMergeNode merge = (AbstractMergeNode)cursor.getKey();
            for (AbstractEndNode end : (List)cursor.getValue()) {
                merge.removeEnd(end);
            }
            if (merge.phiPredecessorCount() == 1) {
                if (merge instanceof LoopBeginNode) {
                    LoopBeginNode loopBegin = (LoopBeginNode)merge;
                    assert (merge.forwardEndCount() == 1);
                    for (LoopExitNode loopExit : loopBegin.loopExits().snapshot()) {
                        if (!markedNodes.contains((Object)loopExit)) continue;
                        loopExit.replaceFirstInput(loopBegin, null);
                    }
                    merge.graph().reduceDegenerateLoopBegin(loopBegin);
                    continue;
                }
                merge.graph().reduceTrivialMerge(merge);
                continue;
            }
            assert (merge.phiPredecessorCount() > 1) : merge;
        }
    }

    private static void markUsagesForKill(EconomicSet<Node> markedNodes) {
        NodeStack workStack = new NodeStack(markedNodes.size() + 4);
        for (Node marked : markedNodes) {
            workStack.push(marked);
        }
        ArrayList<MultiGuardNode> unmarkedMultiGuards = new ArrayList<MultiGuardNode>();
        while (!workStack.isEmpty()) {
            Node marked;
            marked = workStack.pop();
            for (Node usage : marked.usages()) {
                boolean doMark = true;
                if (usage instanceof MultiGuardNode) {
                    MultiGuardNode multiGuard = (MultiGuardNode)usage;
                    for (Node guard : multiGuard.inputs()) {
                        if (markedNodes.contains((Object)guard)) continue;
                        doMark = false;
                        unmarkedMultiGuards.add(multiGuard);
                    }
                }
                if (!doMark || markedNodes.contains((Object)usage)) continue;
                workStack.push(usage);
                markedNodes.add((Object)usage);
            }
            for (MultiGuardNode multiGuard : unmarkedMultiGuards) {
                multiGuard.replaceFirstInput(marked, null);
            }
            unmarkedMultiGuards.clear();
        }
    }

    public static void killCFG(FixedNode node) {
        DebugContext debug = node.getDebug();
        try (DebugContext.Scope scope = debug.scope((Object)"KillCFG", node);){
            EconomicSet unusedNodes = null;
            EconomicSet<Node> unsafeNodes = null;
            Graph.NodeEventScope nodeEventScope = null;
            OptionValues options = node.getOptions();
            boolean verifyGraalGraphEdges = node.graph().verifyGraphEdges;
            boolean verifyKillCFGUnusedNodes = Options.VerifyKillCFGUnusedNodes.getValue(options);
            if (verifyGraalGraphEdges) {
                unsafeNodes = GraphUtil.collectUnsafeNodes(node.graph());
            }
            if (verifyKillCFGUnusedNodes) {
                final EconomicSet collectedUnusedNodes = unusedNodes = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                nodeEventScope = node.graph().trackNodeEvents(new Graph.NodeEventListener(){

                    @Override
                    public void changed(Graph.NodeEvent e, Node n) {
                        if (e == Graph.NodeEvent.ZERO_USAGES && GraphUtil.isFloatingNode(n) && !(n instanceof GuardNode)) {
                            collectedUnusedNodes.add((Object)n);
                        }
                    }
                });
            }
            debug.dump(5, (Object)node.graph(), "Before killCFG %s", node);
            GraphUtil.killCFGInner(node);
            debug.dump(5, (Object)node.graph(), "After killCFG %s", node);
            if (verifyGraalGraphEdges) {
                EconomicSet<Node> newUnsafeNodes = GraphUtil.collectUnsafeNodes(node.graph());
                newUnsafeNodes.removeAll(unsafeNodes);
                assert (newUnsafeNodes.isEmpty()) : "New unsafe nodes: " + newUnsafeNodes;
            }
            if (verifyKillCFGUnusedNodes) {
                nodeEventScope.close();
                Iterator iterator = unusedNodes.iterator();
                while (iterator.hasNext()) {
                    Node curNode = (Node)iterator.next();
                    if (!curNode.isDeleted()) continue;
                    iterator.remove();
                }
                assert (unusedNodes.isEmpty()) : "New unused nodes: " + unusedNodes;
            }
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
    }

    private static EconomicSet<Node> collectUnsafeNodes(Graph graph) {
        EconomicSet unsafeNodes = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        for (Node n : graph.getNodes()) {
            for (Position pos : n.inputPositions()) {
                Node input = pos.get(n);
                if (input != null || pos.isInputOptional()) continue;
                unsafeNodes.add((Object)n);
            }
        }
        return unsafeNodes;
    }

    public static boolean isFloatingNode(Node n) {
        return !(n instanceof FixedNode);
    }

    private static boolean checkKill(Node node, boolean mayKillGuard) {
        node.assertTrue(mayKillGuard || !(node instanceof GuardNode), "must not be a guard node %s", node);
        node.assertTrue(node.isAlive(), "must be alive", new Object[0]);
        node.assertTrue(node.hasNoUsages(), "cannot kill node %s because of usages: %s", node, node.usages());
        node.assertTrue(node.predecessor() == null, "cannot kill node %s because of predecessor: %s", node, node.predecessor());
        return true;
    }

    public static void killWithUnusedFloatingInputs(Node node) {
        GraphUtil.killWithUnusedFloatingInputs(node, false);
    }

    public static void killWithUnusedFloatingInputs(Node node, boolean mayKillGuard) {
        LinkedNodeStack stack = null;
        Node cur = node;
        while (true) {
            assert (GraphUtil.checkKill(cur, mayKillGuard));
            cur.markDeleted();
            for (Node in : cur.inputs()) {
                if (!in.isAlive()) continue;
                in.removeUsage(cur);
                if (in.hasNoUsages()) {
                    cur.maybeNotifyZeroUsages(in);
                }
                if (!GraphUtil.isFloatingNode(in)) continue;
                if (in.hasNoUsages()) {
                    if (in instanceof GuardNode) {
                        continue;
                    }
                } else {
                    if (!(in instanceof PhiNode) || !((PhiNode)in).isDegenerated()) continue;
                    in.replaceAtUsages(null);
                }
                if (stack == null) {
                    stack = new LinkedNodeStack();
                }
                stack.push(in);
            }
            if (stack == null || stack.isEmpty()) break;
            cur = stack.pop();
        }
    }

    public static void removeNewNodes(Graph graph, Graph.Mark mark) {
        assert (GraphUtil.checkNoOldToNewEdges(graph, mark));
        for (Node n : graph.getNewNodes(mark)) {
            n.markDeleted();
            for (Node in : n.inputs()) {
                in.removeUsage(n);
            }
        }
    }

    private static boolean checkNoOldToNewEdges(Graph graph, Graph.Mark mark) {
        Node old;
        Iterator iterator = graph.getNodes().iterator();
        while (iterator.hasNext() && !graph.isNew(mark, old = (Node)iterator.next())) {
            for (Node n : old.successors()) {
                assert (!graph.isNew(mark, n)) : old + " -> " + n;
            }
            for (Node n : old.inputs()) {
                assert (!graph.isNew(mark, n)) : old + " -> " + n;
            }
        }
        return true;
    }

    public static void removeFixedWithUnusedInputs(FixedWithNextNode fixed) {
        FrameState stateAfter;
        if (fixed instanceof StateSplit && (stateAfter = ((StateSplit)((Object)fixed)).stateAfter()) != null) {
            ((StateSplit)((Object)fixed)).setStateAfter(null);
            if (stateAfter.hasNoUsages()) {
                GraphUtil.killWithUnusedFloatingInputs(stateAfter);
            }
        }
        GraphUtil.unlinkFixedNode(fixed);
        GraphUtil.killWithUnusedFloatingInputs(fixed);
    }

    public static void unlinkFixedNode(FixedWithNextNode fixed) {
        assert (fixed.next() != null && fixed.predecessor() != null && fixed.isAlive()) : fixed;
        FixedNode next = fixed.next();
        fixed.setNext(null);
        fixed.replaceAtPredecessor(next);
    }

    public static void unlinkAndKillExceptionEdge(WithExceptionNode withException) {
        assert (withException.next() != null && withException.predecessor() != null && withException.isAlive()) : withException;
        AbstractBeginNode next = withException.next();
        withException.setNext(null);
        withException.replaceAtPredecessor(next);
        withException.killExceptionEdge();
    }

    public static void checkRedundantPhi(PhiNode phiNode) {
        if (phiNode.isDeleted() || phiNode.valueCount() == 1) {
            return;
        }
        ValueNode singleValue = phiNode.singleValueOrThis();
        if (singleValue != phiNode) {
            List<PhiNode> phiUsages = phiNode.usages().filter(PhiNode.class).snapshot();
            List<ProxyNode> proxyUsages = phiNode.usages().filter(ProxyNode.class).snapshot();
            phiNode.replaceAtUsagesAndDelete(singleValue);
            for (PhiNode phi : phiUsages) {
                GraphUtil.checkRedundantPhi(phi);
            }
            for (ProxyNode proxy : proxyUsages) {
                GraphUtil.checkRedundantProxy(proxy);
            }
        }
    }

    public static void checkRedundantProxy(ProxyNode vpn) {
        if (vpn.isDeleted()) {
            return;
        }
        LoopExitNode proxyPoint = vpn.proxyPoint();
        if (proxyPoint instanceof LoopExitNode) {
            LoopExitNode exit = proxyPoint;
            LoopBeginNode loopBegin = exit.loopBegin();
            ValueNode vpnValue = vpn.value();
            for (ValueNode v : loopBegin.stateAfter().values()) {
                ValueNode v2 = v;
                if (loopBegin.isPhiAtMerge(v2)) {
                    v2 = ((PhiNode)v2).valueAt(loopBegin.forwardEnd());
                }
                if (vpnValue != v2) continue;
                List<PhiNode> phiUsages = vpn.usages().filter(PhiNode.class).snapshot();
                List<ProxyNode> proxyUsages = vpn.usages().filter(ProxyNode.class).snapshot();
                vpn.replaceAtUsagesAndDelete(vpnValue);
                for (PhiNode phi : phiUsages) {
                    GraphUtil.checkRedundantPhi(phi);
                }
                for (ProxyNode proxy : proxyUsages) {
                    GraphUtil.checkRedundantProxy(proxy);
                }
                return;
            }
        }
    }

    public static void normalizeLoops(StructuredGraph graph) {
        boolean loopRemoved = false;
        for (LoopBeginNode begin : graph.getNodes(LoopBeginNode.TYPE)) {
            if (begin.loopEnds().isEmpty()) {
                assert (begin.forwardEndCount() == 1);
                graph.reduceDegenerateLoopBegin(begin);
                loopRemoved = true;
                continue;
            }
            GraphUtil.normalizeLoopBegin(begin);
        }
        if (loopRemoved) {
            for (Node node : graph.getNodes()) {
                if (!(node instanceof PhiNode)) continue;
                GraphUtil.checkRedundantPhi((PhiNode)node);
            }
        }
    }

    private static void normalizeLoopBegin(LoopBeginNode begin) {
        for (PhiNode phi : begin.phis().snapshot()) {
            GraphUtil.checkRedundantPhi(phi);
        }
        for (LoopExitNode exit : begin.loopExits()) {
            for (ProxyNode vpn : exit.proxies().snapshot()) {
                GraphUtil.checkRedundantProxy(vpn);
            }
        }
    }

    public static StackTraceElement[] approxSourceStackTraceElement(Node node) {
        NodeSourcePosition position = node.getNodeSourcePosition();
        if (position != null) {
            return GraphUtil.approxSourceStackTraceElement(position);
        }
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        for (Node n = node; n != null; n = n.predecessor()) {
            if (n instanceof MethodCallTargetNode) {
                elements.add(((MethodCallTargetNode)n).targetMethod().asStackTraceElement(-1));
                n = ((MethodCallTargetNode)n).invoke().asNode();
            }
            if (!(n instanceof StateSplit)) continue;
            FrameState state = ((StateSplit)((Object)n)).stateAfter();
            elements.addAll(Arrays.asList(GraphUtil.approxSourceStackTraceElement(state)));
            break;
        }
        return elements.toArray(new StackTraceElement[elements.size()]);
    }

    public static StackTraceElement[] approxSourceStackTraceElement(FrameState frameState) {
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        for (FrameState state = frameState; state != null; state = state.outerFrameState()) {
            Bytecode code = state.getCode();
            if (code == null) continue;
            elements.add(code.asStackTraceElement(state.bci - 1));
        }
        return elements.toArray(new StackTraceElement[0]);
    }

    public static StackTraceElement[] approxSourceStackTraceElement(BytecodePosition bytecodePosition) {
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        for (BytecodePosition position = bytecodePosition; position != null; position = position.getCaller()) {
            ResolvedJavaMethod method = position.getMethod();
            if (method == null) continue;
            elements.add(method.asStackTraceElement(position.getBCI()));
        }
        return elements.toArray(new StackTraceElement[0]);
    }

    public static RuntimeException approxSourceException(Node node, Throwable cause) {
        StackTraceElement[] elements = GraphUtil.approxSourceStackTraceElement(node);
        return GraphUtil.createBailoutException(cause == null ? "" : cause.getMessage(), cause, elements);
    }

    public static BailoutException createBailoutException(String message, Throwable cause, StackTraceElement[] elements) {
        return SourceStackTraceBailoutException.create(cause, message, elements);
    }

    public static String approxSourceLocation(Node node) {
        StackTraceElement top;
        StackTraceElement[] stackTraceElements = GraphUtil.approxSourceStackTraceElement(node);
        if (stackTraceElements != null && stackTraceElements.length > 0 && (top = stackTraceElements[0]).getFileName() != null && top.getLineNumber() >= 0) {
            return top.getFileName() + ":" + top.getLineNumber();
        }
        return null;
    }

    public static String toString(Iterable<?> objects) {
        StringBuilder str = new StringBuilder();
        str.append("[");
        for (Object o : objects) {
            str.append(o).append(", ");
        }
        if (str.length() > 1) {
            str.setLength(str.length() - 2);
        }
        str.append("]");
        return str.toString();
    }

    public static ValueNode unproxify(ValueNode value) {
        if (value instanceof ValueProxy) {
            return GraphUtil.unproxify((ValueProxy)((Object)value));
        }
        return value;
    }

    public static ValueNode unproxify(ValueProxy value) {
        if (value != null) {
            ValueNode result = value.getOriginalNode();
            while (result instanceof ValueProxy) {
                result = ((ValueProxy)((Object)result)).getOriginalNode();
            }
            return result;
        }
        return null;
    }

    public static ValueNode skipPi(ValueNode node) {
        ValueNode n = node;
        while (n instanceof PiNode) {
            PiNode piNode = (PiNode)n;
            n = piNode.getOriginalNode();
        }
        return n;
    }

    public static ValueNode skipPiWhileNonNullArray(ValueNode node) {
        PiNode piNode;
        ObjectStamp originalStamp;
        ValueNode n = node;
        while (n instanceof PiNode && (originalStamp = (ObjectStamp)(piNode = (PiNode)n).getOriginalNode().stamp(NodeView.DEFAULT)).nonNull() && originalStamp.isAlwaysArray()) {
            n = piNode.getOriginalNode();
        }
        return n;
    }

    public static ValueNode arrayLength(ValueNode value, ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        return GraphUtil.arrayLength(value, mode, constantReflection, null);
    }

    private static ValueNode arrayLength(ValueNode value, ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection, EconomicMap<ValueNode, ValueNode> visitedPhiInputs) {
        Objects.requireNonNull(mode);
        EconomicMap visitedPhiInputMap = visitedPhiInputs;
        ValueNode current = value;
        while (true) {
            if (current instanceof ArrayLengthProvider) {
                return ((ArrayLengthProvider)((Object)current)).findLength(mode, constantReflection);
            }
            if (current instanceof ValuePhiNode) {
                if (visitedPhiInputMap == null) {
                    visitedPhiInputMap = EconomicMap.create();
                }
                return GraphUtil.phiArrayLength((ValuePhiNode)current, mode, constantReflection, (EconomicMap<ValueNode, ValueNode>)visitedPhiInputMap);
            }
            if (current instanceof ValueProxyNode) {
                ValueProxyNode proxy = (ValueProxyNode)current;
                ValueNode length = GraphUtil.arrayLength(proxy.getOriginalNode(), mode, constantReflection);
                if (mode == ArrayLengthProvider.FindLengthMode.CANONICALIZE_READ && length != null && !length.isConstant()) {
                    length = new ValueProxyNode(length, proxy.proxyPoint());
                }
                return length;
            }
            if (!(current instanceof ValueProxy)) break;
            current = ((ValueProxy)((Object)current)).getOriginalNode();
        }
        return null;
    }

    private static ValueNode phiArrayLength(ValuePhiNode phi, ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection, EconomicMap<ValueNode, ValueNode> visitedPhiInputs) {
        if (phi.merge() instanceof LoopBeginNode) {
            return null;
        }
        ValueNode singleLength = null;
        for (int i = 0; i < phi.values().count(); ++i) {
            ValueNode input = (ValueNode)phi.values().get(i);
            if (input == null) {
                return null;
            }
            ValueNode length = null;
            if (visitedPhiInputs.containsKey((Object)input)) {
                length = (ValueNode)visitedPhiInputs.get((Object)input);
            } else {
                length = GraphUtil.arrayLength(input, mode, constantReflection, visitedPhiInputs);
                if (length == null) {
                    return null;
                }
                visitedPhiInputs.put((Object)input, (Object)length);
            }
            assert (length.stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Int);
            if (i == 0) {
                assert (singleLength == null);
                singleLength = length;
                continue;
            }
            if (singleLength == length) continue;
            return null;
        }
        return singleLength;
    }

    public static ValueNode originalValue(ValueNode value, boolean abortOnLoopPhi) {
        ValueNode result = GraphUtil.originalValueSimple(value, abortOnLoopPhi);
        assert (result != null);
        return result;
    }

    private static ValueNode originalValueSimple(ValueNode value, boolean abortOnLoopPhi) {
        ValueNode cur = GraphUtil.originalValueForProxy(value);
        while (cur instanceof PhiNode) {
            PhiNode phi = (PhiNode)cur;
            if (abortOnLoopPhi && phi.isLoopPhi()) {
                return value;
            }
            ValueNode phiSingleValue = null;
            int count = phi.valueCount();
            for (int i = 0; i < count; ++i) {
                ValueNode phiCurValue = GraphUtil.originalValueForProxy(phi.valueAt(i));
                if (phiCurValue == phi) continue;
                if (phiSingleValue == null) {
                    phiSingleValue = phiCurValue;
                    continue;
                }
                if (phiSingleValue == phiCurValue) continue;
                if (phiSingleValue instanceof PhiNode || phiCurValue instanceof PhiNode) {
                    return GraphUtil.originalValueForComplicatedPhi(value, phi, new NodeBitMap(value.graph()), abortOnLoopPhi);
                }
                return phi;
            }
            assert (phiSingleValue != null);
            cur = phiSingleValue;
        }
        assert (!(cur instanceof LimitedValueProxy) && !(cur instanceof PhiNode));
        return cur;
    }

    private static ValueNode originalValueForProxy(ValueNode value) {
        ValueNode cur = value;
        while (cur instanceof LimitedValueProxy) {
            cur = ((LimitedValueProxy)((Object)cur)).getOriginalNode();
        }
        return cur;
    }

    private static ValueNode originalValueForComplicatedPhi(ValueNode value, PhiNode phi, NodeBitMap visited, boolean abortOnLoopPhi) {
        if (visited.isMarked(phi)) {
            return null;
        }
        visited.mark(phi);
        ValueNode phiSingleValue = null;
        int count = phi.valueCount();
        for (int i = 0; i < count; ++i) {
            ValueNode phiCurValue = GraphUtil.originalValueForProxy(phi.valueAt(i));
            if (phiCurValue instanceof PhiNode) {
                PhiNode curPhi = (PhiNode)phiCurValue;
                if (abortOnLoopPhi && curPhi.isLoopPhi()) {
                    return value;
                }
                phiCurValue = GraphUtil.originalValueForComplicatedPhi(value, curPhi, visited, abortOnLoopPhi);
                if (phiCurValue == value) {
                    assert (abortOnLoopPhi);
                    return value;
                }
            }
            if (phiCurValue == null) continue;
            if (phiSingleValue == null) {
                phiSingleValue = phiCurValue;
                continue;
            }
            if (phiCurValue == phiSingleValue) continue;
            return phi;
        }
        return phiSingleValue;
    }

    public static boolean tryKillUnused(Node node) {
        if (node.isAlive() && GraphUtil.isFloatingNode(node) && node.hasNoUsages() && !(node instanceof GuardNode)) {
            GraphUtil.killWithUnusedFloatingInputs(node);
            return true;
        }
        return false;
    }

    public static NodeIterable<FixedNode> predecessorIterable(final FixedNode start) {
        return new NodeIterable<FixedNode>(){

            @Override
            public Iterator<FixedNode> iterator() {
                return new Iterator<FixedNode>(){
                    public FixedNode current;
                    {
                        this.current = start;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != null;
                    }

                    @Override
                    public FixedNode next() {
                        try {
                            FixedNode fixedNode = this.current;
                            return fixedNode;
                        }
                        finally {
                            this.current = (FixedNode)this.current.predecessor();
                        }
                    }
                };
            }
        };
    }

    public static SimplifierTool getDefaultSimplifier(CoreProviders providers, boolean canonicalizeReads, Assumptions assumptions, OptionValues options) {
        return new DefaultSimplifierTool(providers, canonicalizeReads, assumptions, options);
    }

    public static Constant foldIfConstantAndRemove(ValueNode node, ValueNode constant) {
        assert (node.inputs().contains(constant));
        if (constant.isConstant()) {
            node.replaceFirstInput(constant, null);
            Constant result = constant.asConstant();
            GraphUtil.tryKillUnused(constant);
            return result;
        }
        return null;
    }

    public static void virtualizeArrayCopy(VirtualizerTool tool, ValueNode source, ValueNode sourceLength, ValueNode newLength, ValueNode from, ResolvedJavaType newComponentType, JavaKind elementKind, StructuredGraph graph, BiFunction<ResolvedJavaType, Integer, VirtualArrayNode> virtualArrayProvider) {
        int i;
        ValueNode sourceAlias = tool.getAlias(source);
        ValueNode replacedSourceLength = tool.getAlias(sourceLength);
        ValueNode replacedNewLength = tool.getAlias(newLength);
        ValueNode replacedFrom = tool.getAlias(from);
        if (!(replacedNewLength.isConstant() && replacedFrom.isConstant() && replacedSourceLength.isConstant())) {
            return;
        }
        assert (newComponentType != null) : "An array copy can be virtualized only if the real type of the resulting array is known statically.";
        int fromInt = replacedFrom.asJavaConstant().asInt();
        int newLengthInt = replacedNewLength.asJavaConstant().asInt();
        int sourceLengthInt = replacedSourceLength.asJavaConstant().asInt();
        if (sourceAlias instanceof VirtualObjectNode) {
            VirtualObjectNode sourceVirtual = (VirtualObjectNode)sourceAlias;
            assert (sourceLengthInt == sourceVirtual.entryCount());
        }
        if (fromInt < 0 || newLengthInt < 0 || fromInt > sourceLengthInt) {
            return;
        }
        if (newLengthInt > tool.getMaximumEntryCount()) {
            return;
        }
        ValueNode[] newEntryState = new ValueNode[newLengthInt];
        int readLength = Math.min(newLengthInt, sourceLengthInt - fromInt);
        if (sourceAlias instanceof VirtualObjectNode) {
            VirtualObjectNode sourceVirtual = (VirtualObjectNode)sourceAlias;
            boolean alwaysAssignable = newComponentType.getJavaKind() == JavaKind.Object && newComponentType.isJavaLangObject();
            for (int i2 = 0; i2 < readLength; ++i2) {
                ValueNode entry = tool.getEntry(sourceVirtual, fromInt + i2);
                if (!alwaysAssignable) {
                    ResolvedJavaType entryType = StampTool.typeOrNull(entry, tool.getMetaAccess());
                    if (entryType == null) {
                        return;
                    }
                    if (!newComponentType.isAssignableFrom(entryType)) {
                        return;
                    }
                }
                newEntryState[i2] = entry;
            }
        } else {
            ResolvedJavaType sourceType = StampTool.typeOrNull(sourceAlias, tool.getMetaAccess());
            if (sourceType == null || !sourceType.isArray() || !newComponentType.isAssignableFrom(sourceType.getElementalType())) {
                return;
            }
            for (i = 0; i < readLength; ++i) {
                LoadIndexedNode load = new LoadIndexedNode(null, sourceAlias, ConstantNode.forInt(i + fromInt, graph), null, elementKind);
                tool.addNode(load);
                newEntryState[i] = load;
            }
        }
        if (readLength < newLengthInt) {
            ConstantNode defaultValue = ConstantNode.defaultForKind(elementKind, graph);
            for (i = readLength; i < newLengthInt; ++i) {
                newEntryState[i] = defaultValue;
            }
        }
        VirtualArrayNode newVirtualArray = virtualArrayProvider.apply(newComponentType, newLengthInt);
        tool.createVirtualObject(newVirtualArray, newEntryState, Collections.emptyList(), source.getNodeSourcePosition(), false);
        tool.replaceWithVirtual(newVirtualArray);
    }

    public static boolean checkFrameState(FixedNode start, int maxDepth) {
        if (maxDepth == 0) {
            return false;
        }
        FixedNode node = start;
        while (true) {
            StateSplit stateSplitNode;
            if (node instanceof AbstractMergeNode) {
                AbstractMergeNode mergeNode = (AbstractMergeNode)node;
                return mergeNode.stateAfter() != null;
            }
            if (node instanceof StateSplit && (stateSplitNode = (StateSplit)((Object)node)).stateAfter() != null) {
                return true;
            }
            if (node instanceof ControlSplitNode) {
                ControlSplitNode controlSplitNode = (ControlSplitNode)node;
                for (Node node2 : controlSplitNode.cfgSuccessors()) {
                    if (!GraphUtil.checkFrameState((FixedNode)node2, maxDepth - 1)) continue;
                    return true;
                }
                return false;
            }
            if (node instanceof FixedWithNextNode) {
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)node;
                node = fixedWithNextNode.next();
                continue;
            }
            if (!(node instanceof AbstractEndNode)) break;
            AbstractEndNode endNode = (AbstractEndNode)node;
            node = endNode.merge();
        }
        if (node instanceof ControlSinkNode) {
            return true;
        }
        assert (false) : "unexpected node";
        return false;
    }

    public static boolean mayRemoveSplit(IfNode ifNode) {
        return GraphUtil.checkFrameState(ifNode.trueSuccessor(), 4) && GraphUtil.checkFrameState(ifNode.falseSuccessor(), 4);
    }

    public static LoopEndNode tryToTransformToEmptyLoopDiamond(IfNode ifNode, LoopBeginNode loopBegin) {
        if (ifNode.trueSuccessor().next() instanceof AbstractEndNode && ifNode.falseSuccessor().next() instanceof AbstractEndNode) {
            AbstractEndNode trueEnd = (AbstractEndNode)ifNode.trueSuccessor().next();
            AbstractEndNode falseEnd = (AbstractEndNode)ifNode.falseSuccessor().next();
            if (trueEnd.merge() == loopBegin && falseEnd.merge() == loopBegin) {
                StructuredGraph graph = loopBegin.graph();
                for (PhiNode phi : loopBegin.phis()) {
                    if (phi instanceof ValuePhiNode || phi instanceof MemoryPhiNode) continue;
                    return null;
                }
                EndNode newTrueEnd = graph.add(new EndNode());
                EndNode newFalseEnd = graph.add(new EndNode());
                MergeNode merge = graph.add(new MergeNode());
                merge.addForwardEnd(newTrueEnd);
                merge.addForwardEnd(newFalseEnd);
                EconomicMap replacementPhis = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                for (PhiNode phi : loopBegin.phis()) {
                    PhiNode newPhi;
                    if (phi instanceof ValuePhiNode) {
                        ValuePhiNode valuePhi = (ValuePhiNode)phi;
                        newPhi = phi.graph().unique(new ValuePhiNode(valuePhi.stamp(NodeView.DEFAULT), merge, new ValueNode[]{valuePhi.valueAt(trueEnd), valuePhi.valueAt(falseEnd)}));
                        replacementPhis.put((Object)phi, (Object)newPhi);
                        continue;
                    }
                    if (phi instanceof MemoryPhiNode) {
                        MemoryPhiNode memoryPhi = (MemoryPhiNode)phi;
                        newPhi = phi.graph().unique(new MemoryPhiNode(merge, memoryPhi.getLocationIdentity(), new ValueNode[]{memoryPhi.valueAt(trueEnd), memoryPhi.valueAt(falseEnd)}));
                        replacementPhis.put((Object)phi, (Object)newPhi);
                        continue;
                    }
                    GraalError.shouldNotReachHere();
                }
                assert (loopBegin.phis().count() == replacementPhis.size());
                loopBegin.removeEnd(trueEnd);
                loopBegin.removeEnd(falseEnd);
                ifNode.trueSuccessor().setNext(newTrueEnd);
                ifNode.falseSuccessor().setNext(newFalseEnd);
                trueEnd.safeDelete();
                falseEnd.safeDelete();
                LoopEndNode newEnd = graph.add(new LoopEndNode(loopBegin));
                merge.setNext(newEnd);
                int i = 0;
                for (PhiNode phi : loopBegin.phis()) {
                    ValueNode replacementPhi = (ValueNode)replacementPhis.get((Object)phi);
                    assert (phi instanceof ValuePhiNode && replacementPhi instanceof ValuePhiNode || phi instanceof MemoryPhiNode && replacementPhi instanceof MemoryPhiNode);
                    phi.addInput(replacementPhi);
                    ++i;
                }
                assert (i == replacementPhis.size()) : "did not consume all values";
                return newEnd;
            }
        }
        return null;
    }

    public static FrameState findLastFrameState(FixedNode start) {
        assert (start != null);
        GraalError.guarantee(start.graph().getGuardsStage().areFrameStatesAtSideEffects(), "Framestates must be at side effects when looking for state split nodes");
        FixedNode lastFixedNode = null;
        FixedNode currentStart = start;
        while (true) {
            for (FixedNode fixed : GraphUtil.predecessorIterable(currentStart)) {
                if (fixed instanceof StateSplit) {
                    StateSplit stateSplit = (StateSplit)((Object)fixed);
                    GraalError.guarantee(!stateSplit.hasSideEffect() || stateSplit.stateAfter() != null, "Found state split with side-effect without framestate=%s", (Object)stateSplit);
                    if (stateSplit.stateAfter() != null) {
                        return stateSplit.stateAfter();
                    }
                }
                lastFixedNode = fixed;
            }
            if (!(lastFixedNode instanceof LoopBeginNode)) break;
            currentStart = ((LoopBeginNode)lastFixedNode).forwardEnd();
        }
        return null;
    }

    private static final class DefaultSimplifierTool
    extends CoreProvidersDelegate
    implements SimplifierTool {
        private final boolean canonicalizeReads;
        private final Assumptions assumptions;
        private final OptionValues options;

        DefaultSimplifierTool(CoreProviders providers, boolean canonicalizeReads, Assumptions assumptions, OptionValues options) {
            super(providers);
            this.canonicalizeReads = canonicalizeReads;
            this.assumptions = assumptions;
            this.options = options;
        }

        @Override
        public boolean canonicalizeReads() {
            return this.canonicalizeReads;
        }

        @Override
        public boolean allUsagesAvailable() {
            return true;
        }

        @Override
        public void deleteBranch(Node branch) {
            FixedNode fixedBranch = (FixedNode)branch;
            fixedBranch.predecessor().replaceFirstSuccessor(fixedBranch, null);
            GraphUtil.killCFG(fixedBranch);
        }

        @Override
        public void removeIfUnused(Node node) {
            GraphUtil.tryKillUnused(node);
        }

        @Override
        public void addToWorkList(Node node) {
        }

        @Override
        public void addToWorkList(Iterable<? extends Node> nodes) {
        }

        @Override
        public Assumptions getAssumptions() {
            return this.assumptions;
        }

        @Override
        public OptionValues getOptions() {
            return this.options;
        }

        @Override
        public Integer smallestCompareWidth() {
            if (this.getLowerer() != null) {
                return this.getLowerer().smallestCompareWidth();
            }
            return null;
        }

        @Override
        public boolean supportsRounding() {
            if (this.getLowerer() != null) {
                return this.getLowerer().supportsRounding();
            }
            return false;
        }
    }

    public static class Options {
        @Option(help={"Verify that there are no new unused nodes when performing killCFG"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> VerifyKillCFGUnusedNodes = new OptionKey<Boolean>(false);
    }
}

