/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class LoopSafepointInsertionPhase
extends BasePhase<MidTierContext> {
    @Override
    public boolean checkContract() {
        return false;
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        if (GraalOptions.GenLoopSafepoints.getValue(graph.getOptions()).booleanValue()) {
            for (LoopBeginNode loopBeginNode : graph.getNodes(LoopBeginNode.TYPE)) {
                for (LoopEndNode loopEndNode : loopBeginNode.loopEnds().snapshot()) {
                    if (!loopEndNode.canSafepoint()) continue;
                    DebugCloseable s = loopEndNode.withNodeSourcePosition();
                    Throwable throwable = null;
                    try {
                        SafepointNode safepointNode = graph.add(new SafepointNode(loopBeginNode));
                        graph.addBeforeFixed(loopEndNode, safepointNode);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (s == null) continue;
                        if (throwable != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        s.close();
                    }
                }
            }
        }
    }
}

