/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.TriState;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.core.common.util.Util;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.NodeWorkList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.DeoptimizingGuard;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MacroInvokableMarker;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.java.ResolvedMethodHandleCallTargetNodeMarker;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.common.inlining.info.InlineInfo;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;
import org.graalvm.compiler.phases.util.ValueMergeUtil;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public class InliningUtil
extends ValueMergeUtil {
    private static final String inliningDecisionsScopeString = "InliningDecisions";
    public static InlineeReturnAction NoReturnAction = new InlineeReturnAction();
    private static final ValueNode[] NO_ARGS = new ValueNode[0];
    private static final SpeculationReasonGroup FALLBACK_DEOPT_SPECULATION = new SpeculationReasonGroup("FallbackDeopt", ResolvedJavaMethod.class, Integer.TYPE, TriState.class, ReceiverTypeSpeculationContext.class);

    private static void printInlining(InlineInfo info, int inliningDepth, boolean success, String msg, Object ... args) {
        InliningUtil.printInlining(info.methodAt(0), info.invoke(), inliningDepth, success, msg, args);
    }

    private static void printInlining(ResolvedJavaMethod method, Invoke invoke, int inliningDepth, boolean success, String msg, Object ... args) {
        if (GraalOptions.HotSpotPrintInlining.getValue(invoke.asNode().getOptions()).booleanValue()) {
            Util.printInlining(method, invoke.bci(), inliningDepth, success, msg, args);
        }
    }

    public static void traceInlinedMethod(InlineInfo info, int inliningDepth, boolean allowLogging, String msg, Object ... args) {
        InliningUtil.traceMethod(info, inliningDepth, allowLogging, true, msg, args);
    }

    public static void traceInlinedMethod(Invoke invoke, int inliningDepth, boolean allowLogging, ResolvedJavaMethod method, String msg, Object ... args) {
        InliningUtil.traceMethod(invoke, inliningDepth, allowLogging, true, method, msg, args);
    }

    public static void traceNotInlinedMethod(InlineInfo info, int inliningDepth, String msg, Object ... args) {
        InliningUtil.traceMethod(info, inliningDepth, true, false, msg, args);
    }

    public static void traceNotInlinedMethod(Invoke invoke, int inliningDepth, ResolvedJavaMethod method, String msg, Object ... args) {
        InliningUtil.traceMethod(invoke, inliningDepth, true, false, method, msg, args);
    }

    private static void traceMethod(Invoke invoke, int inliningDepth, boolean allowLogging, boolean success, ResolvedJavaMethod method, String msg, Object ... args) {
        if (allowLogging) {
            DebugContext debug = invoke.asNode().getDebug();
            InliningUtil.printInlining(method, invoke, inliningDepth, success, msg, args);
            if (InliningUtil.shouldLogMethod(debug)) {
                String methodString = InliningUtil.methodName(method, invoke);
                InliningUtil.logMethod(debug, methodString, success, msg, args);
            }
        }
    }

    private static void traceMethod(InlineInfo info, int inliningDepth, boolean allowLogging, boolean success, String msg, Object ... args) {
        if (allowLogging) {
            InliningUtil.printInlining(info, inliningDepth, success, msg, args);
            DebugContext debug = info.graph().getDebug();
            if (InliningUtil.shouldLogMethod(debug)) {
                InliningUtil.logMethod(debug, InliningUtil.methodName(info), success, msg, args);
            }
        }
    }

    public static void logInliningDecision(DebugContext debug, String msg, Object ... args) {
        InliningUtil.logInlining(debug, msg, args);
    }

    public static void logNotInlinedMethod(Invoke invoke, String msg) {
        DebugContext debug = invoke.asNode().getDebug();
        if (InliningUtil.shouldLogMethod(debug)) {
            String methodString = invoke.toString();
            if (invoke.callTarget() == null) {
                methodString = methodString + " callTarget=null";
            } else {
                String targetName = invoke.callTarget().targetName();
                if (!methodString.endsWith(targetName)) {
                    methodString = methodString + " " + targetName;
                }
            }
            InliningUtil.logMethod(debug, methodString, false, msg, new Object[0]);
        }
    }

    private static void logMethod(DebugContext debug, String methodString, boolean success, String msg, Object ... args) {
        String inliningMsg = "inlining " + methodString + ": " + msg;
        if (!success) {
            inliningMsg = "not " + inliningMsg;
        }
        InliningUtil.logInlining(debug, inliningMsg, args);
    }

    private static void logInlining(DebugContext debug, String msg, Object ... args) {
        try (DebugContext.Scope s = debug.scope(inliningDecisionsScopeString);){
            if (debug.isLogEnabled()) {
                debug.logv(msg, args);
            }
        }
    }

    private static boolean shouldLogMethod(DebugContext debug) {
        try (DebugContext.Scope s = debug.scope(inliningDecisionsScopeString);){
            boolean bl = debug.isLogEnabled();
            return bl;
        }
    }

    private static String methodName(ResolvedJavaMethod method, Invoke invoke) {
        if (invoke != null && invoke.stateAfter() != null) {
            return InliningUtil.methodName(invoke.stateAfter(), invoke.bci()) + ": " + method.format("%H.%n(%p):%r") + " (" + method.getCodeSize() + " bytes)";
        }
        return method.format("%H.%n(%p):%r") + " (" + method.getCodeSize() + " bytes)";
    }

    private static String methodName(InlineInfo info) {
        if (info == null) {
            return "null";
        }
        if (info.invoke() != null && info.invoke().stateAfter() != null) {
            return InliningUtil.methodName(info.invoke().stateAfter(), info.invoke().bci()) + ": " + info.toString();
        }
        return info.toString();
    }

    private static String methodName(FrameState frameState, int bci) {
        ResolvedJavaMethod method;
        StringBuilder sb = new StringBuilder();
        if (frameState.outerFrameState() != null) {
            sb.append(InliningUtil.methodName(frameState.outerFrameState(), frameState.outerFrameState().bci));
            sb.append("->");
        }
        sb.append((method = frameState.getMethod()) != null ? method.format("%h.%n") : "?");
        sb.append("@").append(bci);
        return sb.toString();
    }

    public static void replaceInvokeCallTarget(Invoke invoke, StructuredGraph graph, CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod) {
        MethodCallTargetNode oldCallTarget = (MethodCallTargetNode)invoke.callTarget();
        MethodCallTargetNode newCallTarget = graph.add(new MethodCallTargetNode(invokeKind, targetMethod, oldCallTarget.arguments().toArray((A[])new ValueNode[0]), oldCallTarget.returnStamp(), oldCallTarget.getProfile()));
        invoke.asNode().replaceFirstInput(oldCallTarget, newCallTarget);
    }

    public static PiNode createAnchoredReceiver(StructuredGraph graph, GuardingNode anchor, ResolvedJavaType commonType, ValueNode receiver, boolean exact) {
        return InliningUtil.createAnchoredReceiver(graph, anchor, receiver, exact ? StampFactory.objectNonNull(TypeReference.createExactTrusted(commonType)) : StampFactory.objectNonNull(TypeReference.createTrusted(graph.getAssumptions(), commonType)));
    }

    private static PiNode createAnchoredReceiver(StructuredGraph graph, GuardingNode anchor, ValueNode receiver, Stamp stamp) {
        return graph.unique(new PiNode(receiver, stamp, (ValueNode)((Object)anchor)));
    }

    public static String checkInvokeConditions(Invoke invoke) {
        if (invoke.predecessor() == null || !invoke.asNode().isAlive()) {
            return "the invoke is dead code";
        }
        if (!(invoke.callTarget() instanceof MethodCallTargetNode)) {
            return "the invoke has already been lowered, or has been created as a low-level node";
        }
        MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
        if (callTarget.targetMethod() == null) {
            return "target method is null";
        }
        assert (invoke.stateAfter() != null) : invoke;
        if (!invoke.useForInlining()) {
            return "the invoke is marked to be not used for inlining";
        }
        ValueNode receiver = callTarget.receiver();
        if (receiver != null && receiver.isConstant() && receiver.isNullConstant()) {
            return "receiver is null";
        }
        return null;
    }

    public static UnmodifiableEconomicMap<Node, Node> inline(Invoke invoke, StructuredGraph inlineGraph, boolean receiverNullCheck, ResolvedJavaMethod inlineeMethod) {
        try {
            return InliningUtil.inline(invoke, inlineGraph, receiverNullCheck, inlineeMethod, "reason not specified", "phase not specified");
        }
        catch (GraalError ex) {
            ex.addContext("inlining into", invoke.asNode().graph().method());
            ex.addContext("inlinee", inlineGraph.method());
            throw ex;
        }
    }

    public static UnmodifiableEconomicMap<Node, Node> inline(Invoke invoke, StructuredGraph inlineGraph, boolean receiverNullCheck, ResolvedJavaMethod inlineeMethod, String reason, String phase) {
        return InliningUtil.inline(invoke, inlineGraph, receiverNullCheck, inlineeMethod, reason, phase, NoReturnAction);
    }

    public static UnmodifiableEconomicMap<Node, Node> inline(Invoke invoke, StructuredGraph inlineGraph, boolean receiverNullCheck, ResolvedJavaMethod inlineeMethod, String reason, String phase, InlineeReturnAction returnAction) {
        EconomicMap<Node, Node> duplicates;
        FixedNode invokeNode = invoke.asNode();
        StructuredGraph graph = invokeNode.graph();
        final NodeInputList<ValueNode> parameters = invoke.callTarget().arguments();
        assert (inlineGraph.getGuardsStage().ordinal() >= graph.getGuardsStage().ordinal());
        assert (invokeNode.graph().isBeforeStage(StructuredGraph.StageFlag.FLOATING_READS)) : "inline isn't handled correctly after floating reads phase";
        if (receiverNullCheck && !((MethodCallTargetNode)invoke.callTarget()).isStatic()) {
            InliningUtil.nonNullReceiver(invoke);
        }
        ArrayList<Node> nodes = new ArrayList<Node>(inlineGraph.getNodes().count());
        ArrayList<ReturnNode> returnNodes = new ArrayList<ReturnNode>(4);
        ArrayList<Invoke> partialIntrinsicExits = new ArrayList<Invoke>();
        UnwindNode unwindNode = null;
        final StartNode entryPointNode = inlineGraph.start();
        FixedNode firstCFGNode = entryPointNode.next();
        if (firstCFGNode == null) {
            throw new IllegalStateException("Inlined graph is in invalid state: " + inlineGraph);
        }
        for (Node node : inlineGraph.getNodes()) {
            if (node == entryPointNode || node == entryPointNode.stateAfter() && node.hasExactlyOneUsage() || node instanceof ParameterNode) continue;
            nodes.add(node);
            if (node instanceof ReturnNode) {
                returnNodes.add((ReturnNode)node);
                continue;
            }
            if (node instanceof Invoke) {
                Invoke invokeInInlineGraph = (Invoke)((Object)node);
                if (invokeInInlineGraph.bci() != -5) continue;
                ResolvedJavaMethod target1 = inlineeMethod;
                ResolvedJavaMethod target2 = invokeInInlineGraph.callTarget().targetMethod();
                assert (target1.equals(target2)) : String.format("invoke in inlined method expected to be partial intrinsic exit (i.e., call to %s), not a call to %s", target1.format("%H.%n(%p)"), target2.format("%H.%n(%p)"));
                partialIntrinsicExits.add(invokeInInlineGraph);
                continue;
            }
            if (!(node instanceof UnwindNode)) continue;
            assert (unwindNode == null);
            unwindNode = (UnwindNode)node;
        }
        final AbstractBeginNode prevBegin = AbstractBeginNode.prevBegin(invokeNode);
        Graph.DuplicationReplacement localReplacement = new Graph.DuplicationReplacement(){

            @Override
            public Node replacement(Node node) {
                if (node instanceof ParameterNode) {
                    return parameters.get(((ParameterNode)node).index());
                }
                if (node == entryPointNode) {
                    return prevBegin;
                }
                return node;
            }
        };
        assert (invokeNode.successors().first() != null) : invoke;
        assert (invokeNode.predecessor() != null);
        Graph.Mark mark = graph.getMark();
        try (InliningLog.UpdateScope scope = graph.getInliningLog().openDefaultUpdateScope();){
            duplicates = graph.addDuplicates(nodes, (Graph)inlineGraph, inlineGraph.getNodeCount(), localReplacement);
            if (scope != null || graph.getDebug().hasCompilationListener()) {
                graph.getInliningLog().addDecision(invoke, true, phase, duplicates, inlineGraph.getInliningLog(), reason, new Object[0]);
            }
        }
        FrameState stateAfter = invoke.stateAfter();
        assert (stateAfter == null || stateAfter.isAlive());
        FrameState stateAtExceptionEdge = null;
        if (invoke instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode invokeWithException = (InvokeWithExceptionNode)invoke;
            if (unwindNode != null) {
                ExceptionObjectNode obj = (ExceptionObjectNode)invokeWithException.exceptionEdge();
                stateAtExceptionEdge = obj.stateAfter();
            }
        }
        InliningUtil.updateSourcePositions(invoke, inlineGraph, duplicates, !Objects.equals(inlineGraph.method(), inlineeMethod), mark);
        if (stateAfter != null) {
            InliningUtil.processFrameStates(invoke, inlineGraph, duplicates, stateAtExceptionEdge, returnNodes.size() > 1);
            int callerLockDepth = stateAfter.nestedLockDepth();
            if (callerLockDepth != 0) {
                for (MonitorIdNode original : inlineGraph.getNodes(MonitorIdNode.TYPE)) {
                    MonitorIdNode monitor = (MonitorIdNode)duplicates.get((Object)original);
                    InliningUtil.processMonitorId(invoke.stateAfter(), monitor);
                }
            }
        } else assert (InliningUtil.checkContainsOnlyInvalidOrAfterFrameState(duplicates));
        firstCFGNode = (FixedNode)duplicates.get((Object)firstCFGNode);
        for (int i = 0; i < returnNodes.size(); ++i) {
            returnNodes.set(i, (ReturnNode)duplicates.get(returnNodes.get(i)));
        }
        for (Invoke exit : partialIntrinsicExits) {
            Invoke dup = (Invoke)duplicates.get((Object)exit.asNode());
            dup.setBci(invoke.bci());
        }
        if (unwindNode != null) {
            unwindNode = (UnwindNode)duplicates.get((Object)unwindNode);
        }
        if (firstCFGNode instanceof MacroInvokableMarker && firstCFGNode instanceof StateSplit && invoke.callTarget() instanceof ResolvedMethodHandleCallTargetNodeMarker && invoke.callTarget() instanceof MethodCallTargetNode) {
            MacroInvokableMarker macroInvokable = (MacroInvokableMarker)((Object)firstCFGNode);
            ResolvedMethodHandleCallTargetNodeMarker methodHandle = (ResolvedMethodHandleCallTargetNodeMarker)invoke.callTarget();
            if (methodHandle.targetMethod().equals(macroInvokable.getTargetMethod()) && InliningUtil.getDepth(invoke.stateAfter()) == InliningUtil.getDepth(((StateSplit)((Object)macroInvokable)).stateAfter())) {
                macroInvokable.addMethodHandleInfo(methodHandle);
            }
        }
        InliningUtil.finishInlining(invoke, graph, firstCFGNode, returnNodes, unwindNode, inlineGraph, returnAction);
        GraphUtil.killCFG(invokeNode);
        return duplicates;
    }

    static int getDepth(FrameState state) {
        int depth = 0;
        for (FrameState current = state; current != null; current = current.outerFrameState()) {
            ++depth;
        }
        return depth;
    }

    public static EconomicSet<Node> inlineForCanonicalization(Invoke invoke, StructuredGraph inlineGraph, boolean receiverNullCheck, ResolvedJavaMethod inlineeMethod, String reason, String phase) {
        return InliningUtil.inlineForCanonicalization(invoke, inlineGraph, receiverNullCheck, inlineeMethod, null, reason, phase);
    }

    public static EconomicSet<Node> inlineForCanonicalization(Invoke invoke, StructuredGraph inlineGraph, boolean receiverNullCheck, ResolvedJavaMethod inlineeMethod, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicatesConsumer, String reason, String phase) {
        return InliningUtil.inlineForCanonicalization(invoke, inlineGraph, receiverNullCheck, inlineeMethod, duplicatesConsumer, reason, phase, NoReturnAction);
    }

    public static EconomicSet<Node> inlineForCanonicalization(Invoke invoke, StructuredGraph inlineGraph, boolean receiverNullCheck, ResolvedJavaMethod inlineeMethod, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicatesConsumer, String reason, String phase, InlineeReturnAction action) {
        assert (inlineGraph.isSubstitution() || invoke.asNode().graph().getSpeculationLog() == inlineGraph.getSpeculationLog());
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        try (Graph.NodeEventScope nes = invoke.asNode().graph().trackNodeEvents(listener);){
            UnmodifiableEconomicMap<Node, Node> duplicates = InliningUtil.inline(invoke, inlineGraph, receiverNullCheck, inlineeMethod, reason, phase, action);
            if (duplicatesConsumer != null) {
                duplicatesConsumer.accept(duplicates);
            }
        }
        return listener.getNodes();
    }

    private static ValueNode finishInlining(Invoke invoke, StructuredGraph graph, FixedNode firstNode, List<ReturnNode> returnNodes, UnwindNode unwindNode, StructuredGraph inlineGraph, InlineeReturnAction inlineeReturnAction) {
        ValueNode returnValue;
        Object obj;
        List<ReturnNode> processedReturns = inlineeReturnAction.processInlineeReturns(returnNodes);
        FixedNode invokeNode = invoke.asNode();
        FrameState stateAfter = invoke.stateAfter();
        invokeNode.replaceAtPredecessor(firstNode);
        if (invoke instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode invokeWithException = (InvokeWithExceptionNode)invoke;
            if (unwindNode != null && unwindNode.isAlive()) {
                assert (unwindNode.predecessor() != null);
                assert (invokeWithException.exceptionEdge().successors().count() == 1);
                obj = (ExceptionObjectNode)invokeWithException.exceptionEdge();
                assert (((Node)obj).usages().filter(arg_0 -> InliningUtil.lambda$finishInlining$0((ExceptionObjectNode)obj, arg_0)).count() == 0) : "Must not have guards attached to an exception object node";
                AbstractBeginNode replacementAnchor = AbstractBeginNode.prevBegin(unwindNode);
                assert (replacementAnchor != null);
                ((Node)obj).replaceAtUsages((Node)replacementAnchor, InputType.Anchor, InputType.Guard);
                ((Node)obj).replaceAtUsages((Node)unwindNode.exception(), InputType.Value);
                FixedNode n = ((FixedWithNextNode)obj).next();
                ((FixedWithNextNode)obj).setNext(null);
                unwindNode.replaceAndDelete(n);
                ((Node)obj).replaceAtPredecessor(null);
                ((Node)obj).safeDelete();
            } else {
                invokeWithException.killExceptionEdge();
            }
            invokeWithException.killKillingBegin();
        } else if (unwindNode != null && unwindNode.isAlive()) {
            DebugCloseable position = unwindNode.withNodeSourcePosition();
            obj = null;
            try {
                DeoptimizeNode deoptimizeNode = InliningUtil.addDeoptimizeNode(graph, DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.NotCompiledExceptionHandler);
                unwindNode.replaceAndDelete(deoptimizeNode);
            }
            catch (Throwable deoptimizeNode) {
                obj = deoptimizeNode;
                throw deoptimizeNode;
            }
            finally {
                if (position != null) {
                    if (obj != null) {
                        try {
                            position.close();
                        }
                        catch (Throwable deoptimizeNode) {
                            ((Throwable)obj).addSuppressed(deoptimizeNode);
                        }
                    } else {
                        position.close();
                    }
                }
            }
        }
        if (!processedReturns.isEmpty()) {
            FixedNode n = invoke.next();
            invoke.setNext(null);
            if (processedReturns.size() == 1) {
                ReturnNode returnNode = processedReturns.get(0);
                returnValue = returnNode.result();
                invokeNode.replaceAtUsages(returnValue);
                returnNode.replaceAndDelete(n);
            } else {
                MergeNode merge = graph.add(new MergeNode());
                merge.setStateAfter(stateAfter);
                returnValue = InliningUtil.mergeReturns(merge, processedReturns);
                invokeNode.replaceAtUsages(returnValue);
                if (merge.isPhiAtMerge(returnValue)) {
                    InliningUtil.fixFrameStates(graph, merge, (PhiNode)returnValue);
                }
                merge.setNext(n);
            }
        } else {
            returnValue = null;
            invokeNode.replaceAtUsages(null);
            GraphUtil.killCFG(invoke.next());
        }
        graph.updateMethods(inlineGraph);
        if (GraalOptions.GeneratePIC.getValue(graph.getOptions()).booleanValue()) {
            graph.updateFields(inlineGraph);
        }
        if (inlineGraph.hasUnsafeAccess()) {
            graph.markUnsafeAccess();
        }
        assert (inlineGraph.getSpeculationLog() == null || inlineGraph.getSpeculationLog() == graph.getSpeculationLog()) : "Only the root graph should have a speculation log";
        return returnValue;
    }

    private static void fixFrameStates(StructuredGraph graph, MergeNode originalMerge, PhiNode returnPhi) {
        NodeMap<Node> seen = new NodeMap<Node>(graph);
        ArrayDeque<Node> workList = new ArrayDeque<Node>();
        ArrayDeque<ValueNode> valueList = new ArrayDeque<ValueNode>();
        workList.push(originalMerge);
        valueList.push(returnPhi);
        while (!workList.isEmpty()) {
            StateSplit stateSplit;
            FrameState state;
            Node current = (Node)workList.pop();
            ValueNode currentValue = (ValueNode)valueList.pop();
            if (seen.containsKey(current)) continue;
            seen.put(current, current);
            if (current instanceof StateSplit && current != originalMerge && (state = (stateSplit = (StateSplit)((Object)current)).stateAfter()) != null && state.values().contains(returnPhi)) {
                int index = 0;
                FrameState duplicate = state.duplicate();
                for (ValueNode value : state.values()) {
                    if (value == returnPhi) {
                        duplicate.values().set(index, (Object)currentValue);
                    }
                    ++index;
                }
                stateSplit.setStateAfter(duplicate);
                GraphUtil.tryKillUnused(state);
            }
            if (current instanceof AbstractMergeNode) {
                AbstractMergeNode currentMerge = (AbstractMergeNode)current;
                for (EndNode pred : currentMerge.cfgPredecessors()) {
                    ValueNode newValue = currentValue;
                    if (currentMerge.isPhiAtMerge(currentValue)) {
                        PhiNode currentPhi = (PhiNode)currentValue;
                        newValue = currentPhi.valueAt(pred);
                    }
                    workList.push(pred);
                    valueList.push(newValue);
                }
                continue;
            }
            if (current.predecessor() == null) continue;
            workList.push(current.predecessor());
            valueList.push(currentValue);
        }
    }

    private static void updateSourcePositions(Invoke invoke, StructuredGraph inlineGraph, UnmodifiableEconomicMap<Node, Node> duplicates, boolean isSub, Graph.Mark mark) {
        FixedNode invokeNode = invoke.asNode();
        StructuredGraph invokeGraph = invokeNode.graph();
        if (invokeGraph.trackNodeSourcePosition() && invoke.stateAfter() != null) {
            boolean isSubstitution;
            boolean bl = isSubstitution = isSub || inlineGraph.isSubstitution();
            assert (!invokeGraph.trackNodeSourcePosition() || inlineGraph.trackNodeSourcePosition() || isSubstitution) : String.format("trackNodeSourcePosition mismatch %s %s != %s %s", invokeGraph, invokeGraph.trackNodeSourcePosition(), inlineGraph, inlineGraph.trackNodeSourcePosition());
            NodeSourcePosition invokePos = invoke.asNode().getNodeSourcePosition();
            InliningUtil.updateSourcePosition(invokeGraph, duplicates, mark, invokePos, isSubstitution);
        }
    }

    public static void updateSourcePosition(StructuredGraph invokeGraph, UnmodifiableEconomicMap<Node, Node> duplicates, Graph.Mark mark, NodeSourcePosition invokePos, boolean isSubstitution) {
        EconomicSet newNodes = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        newNodes.addAll(invokeGraph.getNewNodes(mark));
        EconomicMap posMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        UnmodifiableMapCursor cursor = duplicates.getEntries();
        ResolvedJavaMethod inlineeRoot = null;
        while (cursor.advance()) {
            Node value = (Node)cursor.getValue();
            if (!newNodes.contains((Object)value)) continue;
            if (isSubstitution && invokePos == null) {
                value.clearNodeSourcePosition();
                continue;
            }
            NodeSourcePosition oldPos = ((Node)cursor.getKey()).getNodeSourcePosition();
            if (oldPos != null) {
                NodeSourcePosition updatedPos = (NodeSourcePosition)posMap.get((Object)oldPos);
                if (updatedPos == null) {
                    if (inlineeRoot == null ? !$assertionsDisabled && (inlineeRoot = oldPos.getRootMethod()) == null : !$assertionsDisabled && !oldPos.verifyRootMethod(inlineeRoot)) {
                        throw new AssertionError();
                    }
                    updatedPos = oldPos.addCaller(oldPos.getSourceLanguage(), invokePos, isSubstitution);
                    posMap.put((Object)oldPos, (Object)updatedPos);
                }
                value.setNodeSourcePosition(updatedPos);
                if (!(value instanceof DeoptimizingGuard)) continue;
                ((DeoptimizingGuard)((Object)value)).addCallerToNoDeoptSuccessorPosition(updatedPos.getCaller());
                continue;
            }
            if (!isSubstitution) continue;
            value.setNodeSourcePosition(invokePos);
        }
        assert (invokeGraph.verifySourcePositions(false));
    }

    public static void processMonitorId(FrameState stateAfter, MonitorIdNode monitorIdNode) {
        if (stateAfter != null) {
            int callerLockDepth = stateAfter.nestedLockDepth();
            monitorIdNode.setLockDepth(monitorIdNode.getLockDepth() + callerLockDepth);
        }
    }

    protected static void processFrameStates(Invoke invoke, StructuredGraph inlineGraph, EconomicMap<Node, Node> duplicates, FrameState stateAtExceptionEdge, boolean alwaysDuplicateStateAfter) {
        FrameState stateAtReturn = invoke.stateAfter();
        FrameState outerFrameState = null;
        JavaKind invokeReturnKind = invoke.asNode().getStackKind();
        EconomicMap replacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (FrameState original : inlineGraph.getNodes(FrameState.TYPE)) {
            FrameState frameState = (FrameState)duplicates.get((Object)original);
            if (frameState == null || !frameState.isAlive()) continue;
            if (outerFrameState == null) {
                outerFrameState = stateAtReturn.duplicateModifiedDuringCall(invoke.bci(), invokeReturnKind);
            }
            InliningUtil.processFrameState(frameState, invoke, (EconomicMap<Node, Node>)replacements, inlineGraph.method(), stateAtExceptionEdge, outerFrameState, alwaysDuplicateStateAfter, invoke.callTarget().targetMethod(), invoke.callTarget().arguments());
        }
        duplicates.replaceAll((key, value) -> replacements.containsKey(value) ? (Node)replacements.get(value) : value);
    }

    public static FrameState processFrameState(FrameState frameState, Invoke invoke, EconomicMap<Node, Node> replacements, ResolvedJavaMethod inlinedMethod, FrameState stateAtExceptionEdge, FrameState outerFrameState, boolean alwaysDuplicateStateAfter, ResolvedJavaMethod invokeTargetMethod, List<ValueNode> invokeArgsList) {
        assert (outerFrameState == null || !outerFrameState.isDeleted()) : outerFrameState;
        FrameState stateAtReturn = invoke.stateAfter();
        JavaKind invokeReturnKind = invoke.asNode().getStackKind();
        if (frameState.bci == -3) {
            return InliningUtil.handleAfterBciFrameState(frameState, invoke, alwaysDuplicateStateAfter);
        }
        if (stateAtExceptionEdge != null && InliningUtil.isStateAfterException(frameState)) {
            FrameState stateAfterException = stateAtExceptionEdge;
            if (frameState.stackSize() > 0 && stateAtExceptionEdge.stackAt(0) != frameState.stackAt(0)) {
                stateAfterException = stateAtExceptionEdge.duplicateModified(JavaKind.Object, JavaKind.Object, frameState.stackAt(0));
            }
            frameState.replaceAndDelete(stateAfterException);
            return stateAfterException;
        }
        if (frameState.bci == -1 && frameState.graph().getGuardsStage() == StructuredGraph.GuardsStage.FLOATING_GUARDS || frameState.bci == -4) {
            InliningUtil.handleMissingAfterExceptionFrameState(frameState, invoke, replacements, alwaysDuplicateStateAfter);
            return frameState;
        }
        if (frameState.bci == -2) {
            assert (frameState.outerFrameState() == null);
            ValueNode[] invokeArgs = invokeArgsList.isEmpty() ? NO_ARGS : invokeArgsList.toArray(new ValueNode[invokeArgsList.size()]);
            FrameState stateBeforeCall = stateAtReturn.duplicateModifiedBeforeCall(invoke.bci(), invokeReturnKind, invokeTargetMethod.getSignature().toParameterKinds(!invokeTargetMethod.isStatic()), invokeArgs);
            frameState.replaceAndDelete(stateBeforeCall);
            return stateBeforeCall;
        }
        if (frameState.outerFrameState() == null) {
            assert (InliningUtil.checkInlineeFrameState(invoke, inlinedMethod, frameState));
            frameState.setOuterFrameState(outerFrameState);
        }
        return frameState;
    }

    private static FrameState handleAfterBciFrameState(FrameState frameState, Invoke invoke, boolean alwaysDuplicateStateAfter) {
        boolean voidReturnMismatch;
        FrameState stateAtReturn = invoke.stateAfter();
        JavaKind invokeReturnKind = invoke.asNode().getStackKind();
        FrameState stateAfterReturn = stateAtReturn;
        if (frameState.getCode() == null) {
            for (Node usage : frameState.usages()) {
                if (!(usage instanceof ForeignCall)) continue;
                ForeignCall foreign = (ForeignCall)((Object)usage);
                foreign.setBci(invoke.bci());
            }
        }
        boolean bl = voidReturnMismatch = frameState.stackSize() > 0 && stateAfterReturn.stackSize() == 0;
        if (voidReturnMismatch) {
            stateAfterReturn = stateAfterReturn.duplicateWithVirtualState();
        } else {
            assert (!frameState.rethrowException()) : frameState;
            stateAfterReturn = frameState.stackSize() > 0 && (alwaysDuplicateStateAfter || stateAfterReturn.stackAt(0) != frameState.stackAt(0)) ? stateAtReturn.duplicateModified(invokeReturnKind, invokeReturnKind, frameState.stackAt(0)) : stateAtReturn.duplicate();
        }
        assert (stateAfterReturn.bci != -5);
        for (MonitorExitNode n : frameState.usages().filter(MonitorExitNode.class)) {
            n.clearEscapedValue();
        }
        frameState.replaceAndDelete(stateAfterReturn);
        return stateAfterReturn;
    }

    static boolean checkInlineeFrameState(Invoke invoke, ResolvedJavaMethod inlinedMethod, FrameState frameState) {
        ResolvedJavaMethod method;
        assert (frameState.bci != -4) : frameState;
        assert (frameState.bci != -2) : frameState;
        assert (frameState.bci != -5) : frameState;
        if (frameState.bci != -6 && !(method = frameState.getMethod()).equals(inlinedMethod)) {
            if (method.equals(invoke.callTarget().targetMethod())) {
                assert (Services.IS_IN_NATIVE_IMAGE || inlinedMethod.getAnnotation(MethodSubstitution.class) != null) : "expected an intrinsic when inlinee frame state matches method of call target but does not match the method of the inlinee graph: " + frameState;
            } else if (!method.getName().equals(inlinedMethod.getName())) {
                throw new AssertionError((Object)String.format("inlinedMethod=%s frameState.method=%s frameState=%s invoke.method=%s", inlinedMethod, method, frameState, invoke.callTarget().targetMethod()));
            }
        }
        return true;
    }

    private static boolean isStateAfterException(FrameState frameState) {
        return frameState.bci == -4 || frameState.bci == -1 && !frameState.getMethod().isSynchronized();
    }

    public static FrameState handleMissingAfterExceptionFrameState(FrameState nonReplaceableFrameState, Invoke invoke, EconomicMap<Node, Node> replacements, boolean alwaysDuplicateStateAfter) {
        StructuredGraph graph = nonReplaceableFrameState.graph();
        NodeWorkList workList = graph.createNodeWorkList();
        workList.add(nonReplaceableFrameState);
        for (Node node : workList) {
            FrameState fs = (FrameState)node;
            for (Node usage : fs.usages().snapshot()) {
                if (!usage.isAlive()) continue;
                if (usage instanceof FrameState) {
                    workList.add(usage);
                    continue;
                }
                StateSplit stateSplit = (StateSplit)((Object)usage);
                FixedNode fixedStateSplit = stateSplit.asNode();
                if (fixedStateSplit instanceof AbstractMergeNode) {
                    AbstractMergeNode merge = (AbstractMergeNode)fixedStateSplit;
                    while (merge.isAlive()) {
                        AbstractEndNode end = (AbstractEndNode)merge.forwardEnds().first();
                        DebugCloseable position = end.withNodeSourcePosition();
                        Throwable throwable = null;
                        try {
                            DeoptimizeNode deoptimizeNode = InliningUtil.addDeoptimizeNode(graph, DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.NotCompiledExceptionHandler);
                            end.replaceAtPredecessor(deoptimizeNode);
                            GraphUtil.killCFG(end);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (position == null) continue;
                            if (throwable != null) {
                                try {
                                    position.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            position.close();
                        }
                    }
                    continue;
                }
                if (fixedStateSplit instanceof ExceptionObjectNode) {
                    WithExceptionNode oldException = (WithExceptionNode)fixedStateSplit.predecessor();
                    FixedNode newNode = oldException.replaceWithNonThrowing();
                    if (replacements != null && oldException != newNode) {
                        replacements.put((Object)oldException, (Object)newNode);
                    }
                    if (!(newNode instanceof StateSplit)) continue;
                    InliningUtil.handleAfterBciFrameState(((StateSplit)((Object)newNode)).stateAfter(), invoke, alwaysDuplicateStateAfter);
                    continue;
                }
                DebugCloseable position = fixedStateSplit.withNodeSourcePosition();
                Throwable throwable = null;
                try {
                    FixedNode deoptimizeNode = InliningUtil.addDeoptimizeNode(graph, DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.NotCompiledExceptionHandler);
                    if (fixedStateSplit instanceof AbstractBeginNode) {
                        deoptimizeNode = BeginNode.begin(deoptimizeNode);
                    }
                    fixedStateSplit.replaceAtPredecessor(deoptimizeNode);
                    GraphUtil.killCFG(fixedStateSplit);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (position == null) continue;
                    if (throwable != null) {
                        try {
                            position.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    position.close();
                }
            }
        }
        return nonReplaceableFrameState;
    }

    private static DeoptimizeNode addDeoptimizeNode(StructuredGraph graph, DeoptimizationAction action, DeoptimizationReason reason) {
        GraalError.guarantee(graph.getGuardsStage() == StructuredGraph.GuardsStage.FLOATING_GUARDS, "Cannot introduce speculative deoptimization when Graal is used with fixed guards");
        return graph.add(new DeoptimizeNode(action, reason));
    }

    private static boolean checkContainsOnlyInvalidOrAfterFrameState(UnmodifiableEconomicMap<Node, Node> duplicates) {
        int okBci = -6;
        for (Node node : duplicates.getValues()) {
            if (!(node instanceof FrameState)) continue;
            FrameState frameState = (FrameState)node;
            if (frameState.bci == -6) continue;
            if (frameState.bci == -3 || frameState.bci == -2) {
                if (okBci == -6) {
                    okBci = frameState.bci;
                    continue;
                }
                assert (okBci == frameState.bci) : node.toString(Verbosity.Debugger);
                continue;
            }
            assert (false) : node.toString(Verbosity.Debugger);
        }
        return true;
    }

    public static ValueNode nonNullReceiver(Invoke invoke) {
        try (DebugCloseable position = invoke.asNode().withNodeSourcePosition();){
            MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
            assert (!callTarget.isStatic()) : callTarget.targetMethod();
            StructuredGraph graph = callTarget.graph();
            ValueNode oldReceiver = (ValueNode)callTarget.arguments().get(0);
            ValueNode newReceiver = oldReceiver;
            if (newReceiver.getStackKind() == JavaKind.Object) {
                Stamp paramStamp;
                Stamp stamp;
                if (invoke.getInvokeKind() == CallTargetNode.InvokeKind.Special && !(stamp = (paramStamp = newReceiver.stamp(NodeView.DEFAULT)).join(StampFactory.object(TypeReference.create(graph.getAssumptions(), callTarget.targetMethod().getDeclaringClass())))).equals(paramStamp)) {
                    newReceiver = graph.unique(new PiNode(newReceiver, stamp));
                }
                if (!StampTool.isPointerNonNull(newReceiver)) {
                    LogicNode condition = graph.unique(IsNullNode.create(newReceiver));
                    FixedGuardNode fixedGuard = graph.add(new FixedGuardNode(condition, DeoptimizationReason.NullCheckException, DeoptimizationAction.InvalidateReprofile, true));
                    PiNode nonNullReceiver = graph.unique(new PiNode(newReceiver, StampFactory.objectNonNull(), fixedGuard));
                    graph.addBeforeFixed(invoke.asNode(), fixedGuard);
                    newReceiver = nonNullReceiver;
                }
            }
            if (newReceiver != oldReceiver) {
                callTarget.replaceFirstInput(oldReceiver, newReceiver);
            }
            ValueNode valueNode = newReceiver;
            return valueNode;
        }
    }

    public static SpeculationLog.SpeculationReason createSpeculation(Invoke invoke, JavaTypeProfile typeProfile) {
        assert (typeProfile.getNotRecordedProbability() == 0.0);
        FrameState frameState = invoke.stateAfter();
        assert (frameState != null);
        return FALLBACK_DEOPT_SPECULATION.createSpeculationReason(frameState.getMethod(), invoke.bci(), frameState.getCode().getProfilingInfo().getExceptionSeen(invoke.bci()), new ReceiverTypeSpeculationContext(typeProfile));
    }

    public static int getNodeCount(StructuredGraph graph) {
        return graph.getNodeCount();
    }

    private static /* synthetic */ boolean lambda$finishInlining$0(ExceptionObjectNode obj, Node x) {
        return x instanceof GuardedNode && ((GuardedNode)((Object)x)).getGuard() == obj;
    }

    private static class ReceiverTypeSpeculationContext
    implements SpeculationReasonGroup.SpeculationContextObject {
        private final JavaTypeProfile typeProfile;

        ReceiverTypeSpeculationContext(JavaTypeProfile typeProfile) {
            this.typeProfile = typeProfile;
        }

        @Override
        public void accept(SpeculationReasonGroup.SpeculationContextObject.Visitor v) {
            for (JavaTypeProfile.ProfiledType profiledType : this.typeProfile.getTypes()) {
                v.visitObject(profiledType.getType());
            }
        }
    }

    public static class InlineeReturnAction {
        public List<ReturnNode> processInlineeReturns(List<ReturnNode> returns) {
            return returns;
        }
    }
}

