/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.util;

import java.util.EnumSet;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;

public class LoopUtility {
    public static boolean canUseWithoutProxy(ControlFlowGraph cfg, Node def, Node use) {
        if (def.graph() instanceof StructuredGraph && ((StructuredGraph)def.graph()).isAfterStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL)) {
            return true;
        }
        if (!LoopUtility.isFixedNode(def) || !LoopUtility.isFixedNode(use)) {
            return false;
        }
        Block useBlock = cfg.blockFor(use);
        Block defBlock = cfg.blockFor(def);
        Loop<Block> defLoop = defBlock.getLoop();
        Loop<Block> useLoop = useBlock.getLoop();
        if (defLoop != null) {
            if (useLoop != null) {
                return useLoop.isAncestorOrSelf(defLoop);
            }
            return false;
        }
        return true;
    }

    private static boolean isFixedNode(Node n) {
        return n instanceof FixedNode;
    }

    public static boolean canTakeAbs(long l, int bits) {
        try {
            LoopUtility.abs(l, bits);
            return true;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public static long abs(long l, int bits) throws ArithmeticException {
        if (bits == 32) {
            if (l == Integer.MIN_VALUE) {
                throw new ArithmeticException("Abs on Integer.MIN_VALUE would cause an overflow because abs(Integer.MIN_VALUE) = Integer.MAX_VALUE + 1 which does not fit in int (32 bits)");
            }
            int i = (int)l;
            return Math.abs(i);
        }
        if (bits == 64) {
            if (l == Long.MIN_VALUE) {
                throw new ArithmeticException("Abs on Long.MIN_VALUE would cause an overflow because abs(Long.MIN_VALUE) = Long.MAX_VALUE + 1 which does not fit in long (64 bits)");
            }
            return Math.abs(l);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes int/long but is " + bits);
    }

    public static void removeObsoleteProxies(StructuredGraph graph, CoreProviders context, CanonicalizerPhase canonicalizer) {
        LoopsData loopsData = context.getLoopsDataProvider().getLoopsData(graph);
        for (LoopEx loop : loopsData.loops()) {
            LoopUtility.removeObsoleteProxiesForLoop(loop, context, canonicalizer);
        }
    }

    public static void removeObsoleteProxiesForLoop(LoopEx loop, CoreProviders context, CanonicalizerPhase canonicalizer) {
        StructuredGraph graph = loop.loopBegin().graph();
        EconomicSetNodeEventListener inputChanges = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.INPUT_CHANGED));
        try (Graph.NodeEventScope s = graph.trackNodeEvents(inputChanges);){
            for (LoopExitNode lex : loop.loopBegin().loopExits()) {
                for (ProxyNode proxy : lex.proxies().snapshot()) {
                    if (!loop.isOutsideLoop(proxy.value())) continue;
                    proxy.replaceAtUsagesAndDelete(proxy.getOriginalNode());
                }
            }
        }
        canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)inputChanges.getNodes());
    }
}

