/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.printer;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.RegisterSaveLayout;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.LogStream;
import org.graalvm.compiler.lir.util.IndexedValueMap;

public class CompilationPrinter
implements Closeable {
    public static final String COLUMN_END = " <|@";
    public static final String HOVER_START = "<@";
    public static final String HOVER_SEP = "|@";
    public static final String HOVER_END = ">@";
    protected final LogStream out;

    public CompilationPrinter(OutputStream os) {
        this.out = new LogStream(os);
    }

    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.out().close();
    }

    protected void begin(String string) {
        this.out.println("begin_" + string);
        this.out.adjustIndentation(2);
    }

    protected void end(String string) {
        this.out.adjustIndentation(-2);
        this.out.println("end_" + string);
    }

    public void printCompilation(JavaMethod javaMethod) {
        this.printCompilation(javaMethod.format("%H::%n"), javaMethod.format("%f %r %H.%n(%p)"));
    }

    public void printCompilation(CompilationIdentifier compilationId) {
        this.printCompilation(compilationId.toString(CompilationIdentifier.Verbosity.DETAILED), compilationId.toString(CompilationIdentifier.Verbosity.DETAILED));
    }

    private void printCompilation(String name, String method) {
        this.begin("compilation");
        this.out.print("name \" ").print(name).println('\"');
        this.out.print("method \"").print(method).println('\"');
        this.out.print("date ").println(System.currentTimeMillis());
        this.end("compilation");
    }

    protected String debugInfoToString(BytecodePosition codePos, ReferenceMap refMap, IndexedValueMap liveBasePointers, RegisterSaveLayout calleeSaveInfo) {
        StringBuilder sb = new StringBuilder();
        if (refMap != null) {
            sb.append("reference-map: ");
            sb.append(refMap.toString());
            sb.append("\n");
        }
        if (liveBasePointers != null) {
            sb.append("live-base-pointers: ");
            sb.append(liveBasePointers);
            sb.append("\n");
        }
        if (calleeSaveInfo != null) {
            sb.append("callee-save-info:");
            for (Map.Entry e : calleeSaveInfo.registersToSlots(true).entrySet()) {
                sb.append(" " + e.getKey() + " -> s" + e.getValue());
            }
            sb.append("\n");
        }
        if (codePos != null) {
            BytecodePosition curCodePos = codePos;
            ArrayList<VirtualObject> virtualObjects = new ArrayList<VirtualObject>();
            do {
                int i;
                sb.append(MetaUtil.toLocation((ResolvedJavaMethod)curCodePos.getMethod(), (int)curCodePos.getBCI()));
                sb.append('\n');
                if (!(curCodePos instanceof BytecodeFrame)) continue;
                BytecodeFrame frame = (BytecodeFrame)curCodePos;
                if (frame.numStack > 0) {
                    sb.append("stack: ");
                    for (i = 0; i < frame.numStack; ++i) {
                        sb.append(this.valueToString(frame.getStackValue(i), virtualObjects)).append(' ');
                    }
                    sb.append("\n");
                }
                sb.append("locals: ");
                for (i = 0; i < frame.numLocals; ++i) {
                    sb.append(this.valueToString(frame.getLocalValue(i), virtualObjects)).append(' ');
                }
                sb.append("\n");
                if (frame.numLocks <= 0) continue;
                sb.append("locks: ");
                for (i = 0; i < frame.numLocks; ++i) {
                    sb.append(this.valueToString(frame.getLockValue(i), virtualObjects)).append(' ');
                }
                sb.append("\n");
            } while ((curCodePos = curCodePos.getCaller()) != null);
            for (int i = 0; i < virtualObjects.size(); ++i) {
                VirtualObject obj = (VirtualObject)virtualObjects.get(i);
                sb.append(obj).append(" ").append(obj.getType().getName()).append(" ");
                for (int j = 0; j < obj.getValues().length; ++j) {
                    sb.append(this.valueToString(obj.getValues()[j], virtualObjects)).append(' ');
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    protected String valueToString(JavaValue value, List<VirtualObject> virtualObjects) {
        if (value == null) {
            return "-";
        }
        if (value instanceof VirtualObject && !virtualObjects.contains(value)) {
            virtualObjects.add((VirtualObject)value);
        }
        return value.toString();
    }

    public void printMachineCode(String code, String label) {
        if (code == null || code.length() == 0) {
            return;
        }
        if (label != null) {
            this.begin("cfg");
            this.out.print("name \"").print(label).println('\"');
            this.end("cfg");
        }
        this.begin("nmethod");
        this.out.print(code);
        this.out.println(COLUMN_END);
        this.end("nmethod");
    }

    public void printBytecodes(String code) {
        if (code == null || code.length() == 0) {
            return;
        }
        this.begin("bytecodes");
        this.out.print(code);
        this.out.println(COLUMN_END);
        this.end("bytecodes");
    }
}

