/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.nodes.PrefetchAllocateNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.replacements.DimensionsNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.ExplodeLoopNode;
import org.graalvm.compiler.replacements.nodes.ZeroMemoryNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class AllocationSnippets
implements Snippets {
    private static final int MAX_UNROLLED_OBJECT_ZEROING_STORES = 8;

    protected Object allocateInstanceImpl(Word hub, Word prototypeMarkWord, boolean forceSlowPath, UnsignedWord size, boolean fillContents, boolean emitMemoryBarrier, boolean constantSize, AllocationProfilingData profilingData) {
        Object result;
        Word tlabInfo = this.getTLABInfo();
        Word top = this.readTlabTop(tlabInfo);
        Word end = this.readTlabEnd(tlabInfo);
        Word newTop = top.add(size);
        if (!forceSlowPath && this.useTLAB() && BranchProbabilityNode.probability(0.99, this.shouldAllocateInTLAB(size, false)) && BranchProbabilityNode.probability(0.99, newTop.belowOrEqual(end))) {
            this.writeTlabTop(tlabInfo, newTop);
            this.emitPrefetchAllocate(newTop, false);
            result = this.formatObject(hub, prototypeMarkWord, size, top, fillContents, emitMemoryBarrier, constantSize, profilingData.snippetCounters);
        } else {
            profilingData.snippetCounters.stub.inc();
            result = this.callNewInstanceStub(hub, size);
        }
        this.profileAllocation(profilingData, size);
        return this.verifyOop(result);
    }

    protected Object allocateArrayImpl(Word hub, Word prototypeMarkWord, int length, int arrayBaseOffset, int log2ElementSize, boolean fillContents, int fillStartOffset, boolean emitMemoryBarrier, boolean maybeUnroll, boolean supportsBulkZeroing, boolean supportsOptimizedFilling, AllocationProfilingData profilingData) {
        Object result;
        Word thread = this.getTLABInfo();
        Word top = this.readTlabTop(thread);
        Word end = this.readTlabEnd(thread);
        ReplacementsUtil.dynamicAssert(end.subtract(top).belowOrEqual(Integer.MAX_VALUE), "TLAB is too large");
        UnsignedWord allocationSize = this.arrayAllocationSize(length, arrayBaseOffset, log2ElementSize);
        Word newTop = top.add(allocationSize);
        if (this.useTLAB() && BranchProbabilityNode.probability(0.99, this.shouldAllocateInTLAB(allocationSize, true)) && BranchProbabilityNode.probability(0.99, newTop.belowOrEqual(end))) {
            this.writeTlabTop(thread, newTop);
            this.emitPrefetchAllocate(newTop, true);
            result = this.formatArray(hub, prototypeMarkWord, allocationSize, length, top, fillContents, fillStartOffset, emitMemoryBarrier, maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, profilingData.snippetCounters);
        } else {
            profilingData.snippetCounters.stub.inc();
            result = this.callNewArrayStub(hub, length, fillStartOffset);
        }
        this.profileAllocation(profilingData, allocationSize);
        return this.verifyOop(result);
    }

    protected Object newMultiArrayImpl(Word hub, int rank, int[] dimensions) {
        Word dims = DimensionsNode.allocaDimsArray(rank);
        ExplodeLoopNode.explodeLoop();
        for (int i = 0; i < rank; ++i) {
            dims.writeInt(i * 4, dimensions[i], LocationIdentity.init());
        }
        return this.callNewMultiArrayStub(hub, rank, dims);
    }

    private UnsignedWord arrayAllocationSize(int length, int arrayBaseOffset, int log2ElementSize) {
        int alignment = this.objectAlignment();
        return WordFactory.unsigned((long)AllocationSnippets.arrayAllocationSize(length, arrayBaseOffset, log2ElementSize, alignment));
    }

    public static long arrayAllocationSize(long length, int arrayBaseOffset, int log2ElementSize, int alignment) {
        long size = ((length & 0xFFFFFFFFL) << log2ElementSize) + (long)arrayBaseOffset + (long)(alignment - 1);
        long mask = ~(alignment - 1);
        long result = size & mask;
        return result;
    }

    private void zeroMemory(Word memory, int startOffset, UnsignedWord endOffset, boolean isEndOffsetConstant, boolean manualUnroll, boolean supportsBulkZeroing, boolean supportsOptimizedFilling, AllocationSnippetCounters snippetCounters) {
        this.fillMemory(0L, memory, startOffset, endOffset, isEndOffsetConstant, manualUnroll, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
    }

    private void fillMemory(long value, Word memory, int startOffset, UnsignedWord endOffset, boolean isEndOffsetConstant, boolean manualUnroll, boolean supportsBulkZeroing, boolean supportsOptimizedFilling, AllocationSnippetCounters snippetCounters) {
        ReplacementsUtil.dynamicAssert(endOffset.and(7).equal(0), "unaligned object size");
        UnsignedWord offset = WordFactory.unsigned((int)startOffset);
        if (offset.and(7).notEqual(0)) {
            memory.writeInt((WordBase)offset, (int)value, LocationIdentity.init());
            offset = offset.add(4);
        }
        ReplacementsUtil.dynamicAssert(offset.and(7).equal(0), "unaligned offset");
        UnsignedWord remainingSize = endOffset.subtract(offset);
        if (manualUnroll && remainingSize.unsignedDivide(8).belowOrEqual(8)) {
            ReplacementsUtil.staticAssert(!isEndOffsetConstant, "size shouldn't be constant at instantiation time");
            this.fillMemoryAlignedUnrollable(value, memory, offset, endOffset, supportsOptimizedFilling, snippetCounters);
        } else {
            this.fillMemoryAligned(value, memory, offset, endOffset, isEndOffsetConstant, remainingSize, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
        }
    }

    protected void fillMemoryAlignedUnrollable(long value, Word memory, UnsignedWord fromOffset, UnsignedWord endOffset, boolean supportsOptimizedFilling, AllocationSnippetCounters snippetCounters) {
        snippetCounters.unrolledInit.inc();
        ExplodeLoopNode.explodeLoop();
        UnsignedWord offset = fromOffset;
        int i = 0;
        while (i < 8 && !offset.equal(endOffset)) {
            memory.initializeLong((WordBase)offset, value, LocationIdentity.init());
            ++i;
            offset = offset.add(8);
        }
    }

    protected void fillMemoryAligned(long value, Word memory, UnsignedWord fromOffset, UnsignedWord endOffset, boolean isEndOffsetConstant, UnsignedWord remainingSize, boolean supportsBulkZeroing, boolean supportsOptimizedFilling, AllocationSnippetCounters snippetCounters) {
        if (supportsBulkZeroing && value == 0L && BranchProbabilityNode.probability(0.010000000000000009, remainingSize.aboveOrEqual(this.getMinimalBulkZeroingSize()))) {
            snippetCounters.bulkInit.inc();
            ZeroMemoryNode.zero(memory.add(fromOffset), remainingSize.rawValue(), true, LocationIdentity.init());
        } else {
            if (isEndOffsetConstant && remainingSize.unsignedDivide(8).belowOrEqual(8)) {
                snippetCounters.unrolledInit.inc();
                ExplodeLoopNode.explodeLoop();
            } else {
                snippetCounters.loopInit.inc();
            }
            UnsignedWord offset = fromOffset;
            while (offset.belowThan(endOffset)) {
                memory.initializeLong((WordBase)offset, value, LocationIdentity.init());
                offset = offset.add(8);
            }
        }
    }

    private void fillWithGarbage(Word memory, int startOffset, UnsignedWord endOffset, boolean isEndOffsetConstant, boolean manualUnroll, boolean supportsOptimizedFilling, AllocationSnippetCounters snippetCounters) {
        this.fillMemory(-72340172838076674L, memory, startOffset, endOffset, isEndOffsetConstant, manualUnroll, false, supportsOptimizedFilling, snippetCounters);
    }

    protected Object formatObject(Word hub, Word prototypeMarkWord, UnsignedWord size, Word memory, boolean fillContents, boolean emitMemoryBarrier, boolean constantSize, AllocationSnippetCounters snippetCounters) {
        this.initializeObjectHeader(memory, hub, prototypeMarkWord, false);
        int headerSize = this.instanceHeaderSize();
        if (fillContents) {
            this.zeroMemory(memory, headerSize, size, constantSize, false, false, false, snippetCounters);
        } else if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
            this.fillWithGarbage(memory, headerSize, size, constantSize, false, false, snippetCounters);
        }
        if (emitMemoryBarrier) {
            MembarNode.memoryBarrier(8, LocationIdentity.init());
        }
        return memory.toObjectNonNull();
    }

    protected Object formatArray(Word hub, Word prototypeMarkWord, UnsignedWord allocationSize, int length, Word memory, boolean fillContents, int fillStartOffset, boolean emitMemoryBarrier, boolean maybeUnroll, boolean supportsBulkZeroing, boolean supportsOptimizedFilling, AllocationSnippetCounters snippetCounters) {
        memory.writeInt(this.arrayLengthOffset(), length, LocationIdentity.init());
        this.initializeObjectHeader(memory, hub, prototypeMarkWord, true);
        if (fillContents) {
            this.zeroMemory(memory, fillStartOffset, allocationSize, false, maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
        } else if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
            this.fillWithGarbage(memory, fillStartOffset, allocationSize, false, maybeUnroll, supportsOptimizedFilling, snippetCounters);
        }
        if (emitMemoryBarrier) {
            MembarNode.memoryBarrier(8, LocationIdentity.init());
        }
        return memory.toObjectNonNull();
    }

    public void emitPrefetchAllocate(Word address, boolean isArray) {
        if (this.getPrefetchStyle() > 0) {
            int lines = this.getPrefetchLines(isArray);
            int stepSize = this.getPrefetchStepSize();
            int distance = this.getPrefetchDistance();
            ExplodeLoopNode.explodeLoop();
            for (int i = 0; i < lines; ++i) {
                PrefetchAllocateNode.prefetch(OffsetAddressNode.address(address, distance));
                distance += stepSize;
            }
        }
    }

    protected abstract int getPrefetchStyle();

    protected abstract int getPrefetchLines(boolean var1);

    protected abstract int getPrefetchStepSize();

    protected abstract int getPrefetchDistance();

    public abstract boolean useTLAB();

    protected abstract boolean shouldAllocateInTLAB(UnsignedWord var1, boolean var2);

    public abstract Word getTLABInfo();

    public abstract Word readTlabTop(Word var1);

    public abstract Word readTlabEnd(Word var1);

    public abstract void writeTlabTop(Word var1, Word var2);

    protected abstract int instanceHeaderSize();

    public abstract void initializeObjectHeader(Word var1, Word var2, Word var3, boolean var4);

    protected Object callNewInstanceStub(Word hub, UnsignedWord size) {
        return this.callNewInstanceStub(hub);
    }

    protected abstract Object callNewInstanceStub(Word var1);

    protected abstract Object callNewArrayStub(Word var1, int var2, int var3);

    protected abstract Object callNewMultiArrayStub(Word var1, int var2, Word var3);

    protected abstract int getMinimalBulkZeroingSize();

    protected abstract void profileAllocation(AllocationProfilingData var1, UnsignedWord var2);

    protected abstract Object verifyOop(Object var1);

    public abstract int arrayLengthOffset();

    protected abstract int objectAlignment();

    protected static class AllocationSnippetCounters {
        final SnippetCounter unrolledInit;
        final SnippetCounter loopInit;
        final SnippetCounter bulkInit;
        final SnippetCounter stub;

        public AllocationSnippetCounters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group allocations = factory.createSnippetCounterGroup("Allocations");
            this.unrolledInit = new SnippetCounter(allocations, "tlabSeqInit", "TLAB alloc with unrolled zeroing");
            this.loopInit = new SnippetCounter(allocations, "tlabLoopInit", "TLAB alloc with zeroing in a loop");
            this.bulkInit = new SnippetCounter(allocations, "tlabBulkInit", "TLAB alloc with bulk zeroing");
            this.stub = new SnippetCounter(allocations, "stub", "alloc and zeroing via stub");
        }
    }

    public static class AllocationProfilingData {
        final AllocationSnippetCounters snippetCounters;

        public AllocationProfilingData(AllocationSnippetCounters snippetCounters) {
            this.snippetCounters = snippetCounters;
        }
    }
}

