/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.nio.ByteOrder;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN)
public class ArrayIndexOfDispatchNode
extends FixedWithNextNode
implements Canonicalizable,
Lowerable,
MemoryAccess,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<ArrayIndexOfDispatchNode> TYPE = NodeClass.create(ArrayIndexOfDispatchNode.class);
    protected final ForeignCallSignature stubCallDescriptor;
    protected final JavaKind arrayKind;
    protected final JavaKind valueKind;
    protected final boolean findTwoConsecutive;
    @Node.Input
    protected ValueNode arrayPointer;
    @Node.Input
    protected ValueNode arrayLength;
    @Node.Input
    protected ValueNode fromIndex;
    @Node.Input
    protected NodeInputList<ValueNode> searchValues;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lastLocationAccess;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    public ArrayIndexOfDispatchNode(@Node.ConstantNodeParameter ForeignCallSignature stubCallDescriptor, @Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, @Node.ConstantNodeParameter boolean findTwoConsecutive, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, stubCallDescriptor, arrayKind, valueKind, findTwoConsecutive, arrayPointer, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfDispatchNode(NodeClass<? extends ArrayIndexOfDispatchNode> type, @Node.ConstantNodeParameter ForeignCallSignature stubCallDescriptor, @Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, @Node.ConstantNodeParameter boolean findTwoConsecutive, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        super((NodeClass<? extends FixedWithNextNode>)type, StampFactory.forKind(JavaKind.Int));
        this.stubCallDescriptor = stubCallDescriptor;
        this.arrayKind = arrayKind;
        this.valueKind = valueKind;
        this.findTwoConsecutive = findTwoConsecutive;
        this.arrayPointer = arrayPointer;
        this.arrayLength = arrayLength;
        this.fromIndex = fromIndex;
        this.searchValues = new NodeInputList((Node)this, (Node[])searchValues);
    }

    public boolean isFindTwoConsecutive() {
        return this.findTwoConsecutive;
    }

    public ValueNode getArrayPointer() {
        return this.arrayPointer;
    }

    public ValueNode getArrayLength() {
        return this.arrayLength;
    }

    public ValueNode getFromIndex() {
        return this.fromIndex;
    }

    public NodeInputList<ValueNode> getSearchValues() {
        return this.searchValues;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public ForeignCallSignature getStubCallDescriptor() {
        return this.stubCallDescriptor;
    }

    public int getNumberOfValues() {
        return this.searchValues.size();
    }

    public JavaKind getArrayKind() {
        return this.arrayKind;
    }

    public JavaKind getValueKind() {
        return this.valueKind;
    }

    public JavaKind getComparisonKind() {
        return this.findTwoConsecutive ? (this.valueKind == JavaKind.Byte ? JavaKind.Char : JavaKind.Int) : this.valueKind;
    }

    public ValueNode[] getStubCallArgs() {
        ValueNode[] ret = new ValueNode[this.searchValues.size() + 3];
        ret[0] = this.arrayPointer;
        ret[1] = this.arrayLength;
        ret[2] = this.fromIndex;
        for (int i = 0; i < this.searchValues.size(); ++i) {
            ret[3 + i] = (ValueNode)this.searchValues.get(i);
        }
        return ret;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(this.arrayKind);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (!this.findTwoConsecutive && this.arrayPointer.isConstant() && ((ConstantNode)this.arrayPointer).getStableDimension() > 0 && this.fromIndex.isConstant()) {
            ConstantReflectionProvider provider = tool.getConstantReflection();
            JavaConstant arrayConstant = this.arrayPointer.asJavaConstant();
            int length = provider.readArrayLength(arrayConstant);
            int fromIndexConstant = this.fromIndex.asJavaConstant().asInt();
            if (this.searchValues.size() == 1 && ((ValueNode)this.searchValues.get(0)).isConstant()) {
                int ch = ((ValueNode)this.searchValues.get(0)).asJavaConstant().asInt();
                assert (ch < 65536);
                if (this.arrayKind == JavaKind.Byte) {
                    if (this.valueKind == JavaKind.Byte && length < GraalOptions.StringIndexOfLimit.getValue(tool.getOptions())) {
                        for (int i = fromIndexConstant; i < length; ++i) {
                            if ((provider.readArrayElement(arrayConstant, i).asInt() & 0xFF) != ch) continue;
                            return ConstantNode.forInt(i);
                        }
                        return ConstantNode.forInt(-1);
                    }
                    if (length < GraalOptions.StringIndexOfLimit.getValue(tool.getOptions()) * 2) {
                        assert (this.valueKind == JavaKind.Char);
                        length >>= 1;
                        for (int i = fromIndexConstant; i < length; ++i) {
                            int b0 = provider.readArrayElement(arrayConstant, i * 2).asInt() & 0xFF;
                            int b1 = provider.readArrayElement(arrayConstant, i * 2 + 1).asInt() & 0xFF;
                            char c = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? (char)(b0 << 8 | b1) : (char)(b0 | b1 << 8);
                            if (c != ch) continue;
                            return ConstantNode.forInt(i);
                        }
                        return ConstantNode.forInt(-1);
                    }
                } else if (this.arrayKind == JavaKind.Char && length < GraalOptions.StringIndexOfLimit.getValue(tool.getOptions())) {
                    assert (this.valueKind == JavaKind.Char);
                    for (int i = fromIndexConstant; i < length; ++i) {
                        if ((provider.readArrayElement(arrayConstant, i).asInt() & 0xFFFF) != ch) continue;
                        return ConstantNode.forInt(i);
                    }
                    return ConstantNode.forInt(-1);
                }
            }
        }
        return this;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Node.NodeIntrinsic
    private static native int arrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, byte var7);

    @Node.NodeIntrinsic
    private static native int arrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, char var7);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, byte var7, byte var8);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, byte var7, byte var8, byte var9);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, byte var7, byte var8, byte var9, byte var10);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, char var7, char var8);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, char var7, char var8, char var9);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, char var7, char var8, char var9, char var10);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallSignature var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, int var7);

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, byte v1) {
        return ArrayIndexOfDispatchNode.arrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, char v1) {
        return ArrayIndexOfDispatchNode.arrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, byte v1, byte v2) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, byte v1, byte v2, byte v3) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, byte v1, byte v2, byte v3, byte v4) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, char v1, char v2) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, char v1, char v2, char v3) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, char v1, char v2, char v3, char v4) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, char[] array, int arrayLength, int fromIndex, char v1) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, false, array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, char[] array, int arrayLength, int fromIndex, char v1, char v2) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, char[] array, int arrayLength, int fromIndex, char v1, char v2, char v3) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallSignature descriptor, char[] array, int arrayLength, int fromIndex, char v1, char v2, char v3, char v4) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf2ConsecutiveBytes(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, int values) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, true, array, arrayLength, fromIndex, values);
    }

    public static int indexOf2ConsecutiveChars(@Node.ConstantNodeParameter ForeignCallSignature descriptor, byte[] array, int arrayLength, int fromIndex, int values) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, true, array, arrayLength, fromIndex, values);
    }

    public static int indexOf2ConsecutiveChars(@Node.ConstantNodeParameter ForeignCallSignature descriptor, char[] array, int arrayLength, int fromIndex, int values) {
        return ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, true, array, arrayLength, fromIndex, values);
    }
}

