/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.IdentityHashCodeNode;
import org.graalvm.word.LocationIdentity;

public abstract class IdentityHashCodeSnippets
implements Snippets {
    @Snippet
    private int identityHashCodeSnippet(Object thisObj) {
        if (BranchProbabilityNode.probability(0.09999999999999998, thisObj == null)) {
            return 0;
        }
        return this.computeIdentityHashCode(thisObj);
    }

    protected abstract int computeIdentityHashCode(Object var1);

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo identityHashCodeSnippet;

        public Templates(IdentityHashCodeSnippets receiver, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, TargetDescription target, LocationIdentity locationIdentity) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
            this.identityHashCodeSnippet = this.snippet(IdentityHashCodeSnippets.class, "identityHashCodeSnippet", null, receiver, locationIdentity);
        }

        public void lower(IdentityHashCodeNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.identityHashCodeSnippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("thisObj", node.object());
            SnippetTemplate template = this.template(node, args);
            template.instantiate(this.providers.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

