/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;

public final class InlineDuringParsingPlugin
implements InlineInvokePlugin {
    private static final int NodeBudget = InlineDuringParsingPlugin.getInteger("InlineDuringParsingPlugin.NodeBudget", 2000);
    private static final int MaxDepthAfterBudgetExceeded = InlineDuringParsingPlugin.getInteger("InlineDuringParsingPlugin.MaxDepthAfterBudgetExceeded", 3);

    private static int getInteger(String name, int def) {
        String value = (String)Services.getSavedProperties().get(name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return def;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (!BytecodeParserOptions.InlineDuringParsing.getValue(b.getOptions()).booleanValue()) {
            return null;
        }
        if (method.hasBytecodes() && method.getDeclaringClass().isLinked() && method.canBeInlined()) {
            if (method.shouldBeInlined() && InlineDuringParsingPlugin.checkInliningDepth(b)) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo(method);
            }
            if (!method.isSynchronized() && InlineDuringParsingPlugin.checkSize(method, args, b.getGraph()) && InlineDuringParsingPlugin.checkInliningDepth(b)) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo(method);
            }
        }
        return null;
    }

    private static boolean checkInliningDepth(GraphBuilderContext b) {
        int nodeCount = b.getGraph().getNodeCount();
        int maxDepth = BytecodeParserOptions.InlineDuringParsingMaxDepth.getValue(b.getOptions());
        if (nodeCount > NodeBudget && MaxDepthAfterBudgetExceeded < maxDepth) {
            maxDepth = MaxDepthAfterBudgetExceeded;
        }
        return b.getDepth() < maxDepth;
    }

    private static boolean checkSize(ResolvedJavaMethod method, ValueNode[] args, StructuredGraph graph) {
        int bonus = 1;
        for (ValueNode v : args) {
            if (!v.isConstant()) continue;
            ++bonus;
        }
        return method.getCode().length <= GraalOptions.TrivialInliningSize.getValue(graph.getOptions()) * bonus;
    }
}

