/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.ArrayList;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.type.StampTool;

public class InvocationPluginHelper
implements DebugCloseable {
    protected final GraphBuilderContext b;
    protected final JavaKind wordKind;
    private final JavaKind returnKind;
    private final ArrayList<ReturnData> returns = new ArrayList();
    private boolean emittedReturn;

    public ValueNode arraylength(ValueNode receiverValue) {
        return this.b.add(new ArrayLengthNode(receiverValue));
    }

    @Override
    public void close() {
        if (this.returns.size() != 0 && !this.emittedReturn) {
            throw new InternalError("must call emitReturn before plugin returns");
        }
    }

    public InvocationPluginHelper(GraphBuilderContext b, ResolvedJavaMethod targetMethod) {
        this.b = b;
        this.wordKind = b.getReplacements().getWordKind();
        this.returnKind = targetMethod.getSignature().getReturnKind();
    }

    public ValueNode shl(ValueNode node, int shiftAmount) {
        if (shiftAmount == 0) {
            return node;
        }
        return this.b.add(new LeftShiftNode(node, ConstantNode.forInt(shiftAmount)));
    }

    public ValueNode shr(ValueNode node, int shiftAmount) {
        if (shiftAmount == 0) {
            return node;
        }
        return this.b.add(new RightShiftNode(node, ConstantNode.forInt(shiftAmount)));
    }

    public ValueNode ushr(ValueNode node, int shiftAmount) {
        if (shiftAmount == 0) {
            return node;
        }
        return this.b.add(new UnsignedRightShiftNode(node, ConstantNode.forInt(shiftAmount)));
    }

    public ValueNode xor(ValueNode x, ValueNode y) {
        return this.b.add(new XorNode(x, y));
    }

    public ValueNode add(ValueNode x, ValueNode y) {
        return this.b.add(new AddNode(x, y));
    }

    public ValueNode sub(ValueNode x, ValueNode y) {
        return this.b.add(new SubNode(x, y));
    }

    public ValueNode length(ValueNode x) {
        return this.b.add(new ArrayLengthNode(x));
    }

    public ValueNode arrayElementPointerScaled(ValueNode array, JavaKind kind, ValueNode index) {
        return this.arrayElementPointer(array, kind, index, true);
    }

    public ValueNode arrayElementPointer(ValueNode array, JavaKind kind, ValueNode index) {
        return this.arrayElementPointer(array, kind, index, false);
    }

    private ValueNode arrayElementPointer(ValueNode array, JavaKind kind, ValueNode index, boolean scaled) {
        JavaKind actualKind = scaled ? JavaKind.Byte : kind;
        ResolvedJavaType type = StampTool.typeOrNull(array);
        assert (type == null || type.isArray() && type.getComponentType().getJavaKind() == actualKind || type.isJavaLangObject()) : array.stamp(NodeView.DEFAULT);
        int arrayBaseOffset = this.b.getMetaAccess().getArrayBaseOffset(kind);
        ValueNode offset = ConstantNode.forIntegerKind(this.wordKind, arrayBaseOffset);
        if (index != null) {
            ValueNode scaledIndex = this.shl(this.asWord(index), CodeUtil.log2((int)this.b.getMetaAccess().getArrayIndexScale(kind)));
            offset = this.add(offset, scaledIndex);
        }
        GraalError.guarantee(offset.getStackKind() == this.wordKind, "should have been promoted to word: %s", (Object)index);
        return this.b.add(new ComputeObjectAddressNode(array, offset));
    }

    public ValueNode asWord(ValueNode index) {
        assert (index.getStackKind().isPrimitive());
        if (index.getStackKind() != this.wordKind) {
            return SignExtendNode.create(index, this.wordKind.getBitCount(), NodeView.DEFAULT);
        }
        return index;
    }

    private LogicNode createCompare(ValueNode origX, ValueNode origY, Condition.CanonicalizedCondition canonicalizedCondition) {
        ValueNode x = origX;
        ValueNode y = origY;
        if (canonicalizedCondition.mustMirror()) {
            x = origY;
            y = origX;
        }
        return this.createCompare(canonicalizedCondition.getCanonicalCondition(), x, y);
    }

    public LogicNode createCompare(CanonicalCondition cond, ValueNode x, ValueNode y) {
        assert (!x.getStackKind().isNumericFloat());
        switch (cond) {
            case EQ: {
                if (x.getStackKind() == JavaKind.Object) {
                    return ObjectEqualsNode.create(this.b.getConstantReflection(), this.b.getMetaAccess(), y.getOptions(), x, y, NodeView.DEFAULT);
                }
                return IntegerEqualsNode.create(this.b.getConstantReflection(), this.b.getMetaAccess(), y.getOptions(), null, x, y, NodeView.DEFAULT);
            }
            case LT: {
                GraalError.guarantee(x.getStackKind() != JavaKind.Object, "object not allowed");
                return IntegerLessThanNode.create(this.b.getConstantReflection(), this.b.getMetaAccess(), y.getOptions(), null, x, y, NodeView.DEFAULT);
            }
            case BT: {
                GraalError.guarantee(x.getStackKind() != JavaKind.Object, "object not allowed");
                return IntegerBelowNode.create(this.b.getConstantReflection(), this.b.getMetaAccess(), y.getOptions(), null, x, y, NodeView.DEFAULT);
            }
        }
        throw GraalError.shouldNotReachHere("Unexpected condition: " + (Object)((Object)cond));
    }

    public ValueNode loadField(ValueNode value, ResolvedJavaField field) {
        return this.b.add(LoadFieldNode.create(this.b.getConstantFieldProvider(), this.b.getConstantReflection(), this.b.getMetaAccess(), this.b.getOptions(), this.b.getAssumptions(), value, field, false, false));
    }

    public void guard(ValueNode origX, Condition condition, ValueNode origY, DeoptimizationAction action, DeoptimizationReason deoptReason) {
        Condition.CanonicalizedCondition canonicalizedCondition = condition.canonicalize();
        LogicNode compare = this.createCompare(origX, origY, canonicalizedCondition);
        this.b.add(new FixedGuardNode(compare, deoptReason, action, !canonicalizedCondition.mustNegate()));
    }

    public GuardingNode intrinsicRangeCheck(ValueNode x, Condition condition, ValueNode y) {
        Condition.CanonicalizedCondition canonicalizedCondition = condition.canonicalize();
        LogicNode compare = this.createCompare(x, y, canonicalizedCondition);
        return this.b.intrinsicRangeCheck(compare, canonicalizedCondition.mustNegate());
    }

    public void intrinsicArrayRangeCheck(ValueNode array, ValueNode index, ValueNode offset) {
        this.intrinsicRangeCheck(index, Condition.LT, ConstantNode.forInt(0));
        ValueNode length = this.length(this.b.nullCheckedValue(array));
        this.intrinsicRangeCheck(this.add(index, offset), Condition.AT, length);
    }

    public void intrinsicArrayRangeCheckScaled(ValueNode array, ValueNode index, ValueNode offset) {
        this.intrinsicRangeCheck(index, Condition.LT, ConstantNode.forInt(0));
        ValueNode length = this.length(this.b.nullCheckedValue(array));
        ValueNode shiftedLength = this.shr(length, 1);
        this.intrinsicRangeCheck(this.add(index, offset), Condition.AT, shiftedLength);
    }

    public AbstractBeginNode emitReturnIf(LogicNode condition, ValueNode returnValue, double returnProbability) {
        return this.emitReturnIf(condition, false, returnValue, returnProbability);
    }

    public AbstractBeginNode emitReturnIf(ValueNode x, Condition condition, ValueNode y, ValueNode returnValue, double returnProbability) {
        Condition.CanonicalizedCondition canonicalizedCondition = condition.canonicalize();
        LogicNode compare = this.createCompare(x, y, canonicalizedCondition);
        return this.emitReturnIf(compare, canonicalizedCondition.mustNegate(), returnValue, returnProbability);
    }

    public AbstractBeginNode emitReturnIfNot(LogicNode condition, ValueNode returnValue, double returnProbability) {
        return this.emitReturnIf(condition, true, returnValue, returnProbability);
    }

    public AbstractBeginNode emitReturnIf(LogicNode condition, boolean negated, ValueNode returnValue, double returnProbability) {
        BeginNode trueSuccessor = this.b.getGraph().add(new BeginNode());
        EndNode end = this.b.getGraph().add(new EndNode());
        trueSuccessor.setNext(end);
        this.addReturnValue(end, this.returnKind, returnValue);
        ProfileData.BranchProbabilityData probability = ProfileData.BranchProbabilityData.injected(returnProbability, true);
        IfNode node = new IfNode(condition, negated ? null : trueSuccessor, negated ? trueSuccessor : null, probability);
        IfNode ifNode = this.b.append(node);
        BeginNode otherSuccessor = this.b.append(new BeginNode());
        if (negated) {
            ifNode.setTrueSuccessor(otherSuccessor);
        } else {
            ifNode.setFalseSuccessor(otherSuccessor);
        }
        return otherSuccessor;
    }

    public void emitFinalReturn(JavaKind kind, ValueNode origReturnValue) {
        ValueNode returnValue = origReturnValue;
        assert (!this.emittedReturn) : "must only have one final return";
        if (returnValue.isUnregistered()) {
            returnValue = this.b.append(returnValue);
        }
        EndNode end = this.b.append(new EndNode());
        this.addReturnValue(end, kind, returnValue);
        MergeNode returnMerge = this.b.append(new MergeNode());
        ValuePhiNode returnPhi = null;
        if (this.returnKind != JavaKind.Void) {
            returnPhi = this.b.add(new ValuePhiNode(StampFactory.forKind(this.returnKind), returnMerge));
        }
        returnMerge.setStateAfter(this.b.getIntrinsicReturnState(kind, returnPhi));
        for (ReturnData r : this.returns) {
            returnMerge.addForwardEnd(r.end);
            if (returnPhi != null) {
                returnPhi.addInput(r.returnValue);
                continue;
            }
            assert (r.returnValue == null);
        }
        this.b.addPush(this.returnKind, returnPhi);
        this.emittedReturn = true;
    }

    private void addReturnValue(EndNode end, JavaKind kind, ValueNode returnValueInput) {
        assert (this.b.canMergeIntrinsicReturns());
        ValueNode returnValue = returnValueInput;
        if (returnValue.isUnregistered()) {
            assert (!(returnValue instanceof FixedNode));
            returnValue = this.b.add(returnValue);
        }
        assert (!returnValue.isUnregistered()) : returnValue;
        assert (kind == this.returnKind);
        this.returns.add(new ReturnData(end, returnValue));
    }

    static class ReturnData {
        final EndNode end;
        final ValueNode returnValue;

        ReturnData(EndNode end, ValueNode returnValue) {
            this.end = end;
            this.returnValue = returnValue;
        }
    }
}

