/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.JDK9StringSubstitutions;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

@ClassSubstitution(className={"java.lang.StringLatin1"}, optional=true)
public class StringLatin1Substitutions {
    public static final MetaAccessProvider INJECTED = null;

    private static Word pointer(byte[] target) {
        return Word.objectToTrackedPointer(target).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED));
    }

    private static Word byteOffsetPointer(byte[] source, int offset) {
        return StringLatin1Substitutions.pointer(source).add(WordFactory.signed((int)offset).multiply((SignedWord)WordFactory.unsigned((long)ReplacementsUtil.byteArrayIndexScale(INJECTED))));
    }

    @MethodSubstitution
    public static int indexOf(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringLatin1.indexOf invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringLatin1.indexOf invalid args: targetCount <= 0");
        if (GraalDirectives.injectBranchProbability(0.25, sourceCount - fromIndex < targetCount)) {
            return -1;
        }
        if (GraalDirectives.injectBranchProbability(0.25, targetCount == 1)) {
            return ArrayIndexOf.indexOf1Byte(source, sourceCount, fromIndex, JDK9StringSubstitutions.getByte(target, 0));
        }
        int offset = fromIndex;
        int haystackLength = sourceCount - (targetCount - 2);
        if (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            byte b1 = JDK9StringSubstitutions.getByte(target, 0);
            byte b2 = JDK9StringSubstitutions.getByte(target, 1);
            do {
                Word targetPointer;
                int indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, (indexOfResult = ArrayIndexOf.indexOfTwoConsecutiveBytes(source, haystackLength, offset, b1, b2)) < 0)) {
                    return -1;
                }
                offset = indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                    return offset;
                }
                Word cmpSourcePointer = StringLatin1Substitutions.byteOffsetPointer(source, offset);
                if (!GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer = StringLatin1Substitutions.pointer(target), targetCount, JavaKind.Byte))) continue;
                return offset;
            } while (GraalDirectives.injectBranchProbability(0.75, ++offset < haystackLength));
        }
        return -1;
    }
}

