/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.JDK9StringSubstitutions;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

@ClassSubstitution(className={"java.lang.StringUTF16"}, optional=true)
public class StringUTF16Substitutions {
    protected static final MetaAccessProvider INJECTED = null;

    private static int length(byte[] value) {
        return value.length >> 1;
    }

    private static Word pointer(byte[] target) {
        return Word.objectToTrackedPointer(target).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED));
    }

    private static Word charOffsetPointer(byte[] value, int offset) {
        return StringUTF16Substitutions.pointer(value).add(WordFactory.signed((int)offset).multiply((SignedWord)WordFactory.unsigned((long)ReplacementsUtil.charArrayIndexScale(INJECTED))));
    }

    private static native char getChar(byte[] var0, int var1);

    @MethodSubstitution
    public static int indexOfCharUnsafe(byte[] value, int ch, int fromIndex, int max) {
        return ArrayIndexOf.indexOf1CharCompact(value, max, fromIndex, (char)ch);
    }

    @MethodSubstitution
    public static int indexOfUnsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringUTF16.indexOfUnsafe invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringUTF16.indexOfUnsafe invalid args: targetCount <= 0");
        ReplacementsUtil.dynamicAssert(targetCount <= StringUTF16Substitutions.length(target), "StringUTF16.indexOfUnsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.dynamicAssert(sourceCount >= targetCount, "StringUTF16.indexOfUnsafe invalid args: sourceCount < targetCount");
        if (targetCount == 1) {
            return ArrayIndexOf.indexOf1CharCompact(source, sourceCount, fromIndex, StringUTF16Substitutions.getChar(target, 0));
        }
        int haystackLength = sourceCount - (targetCount - 2);
        int offset = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            Word targetPointer;
            int indexOfResult = ArrayIndexOf.indexOfTwoConsecutiveChars(source, haystackLength, offset, StringUTF16Substitutions.getChar(target, 0), StringUTF16Substitutions.getChar(target, 1));
            if (GraalDirectives.injectBranchProbability(0.25, indexOfResult < 0)) {
                return -1;
            }
            offset = indexOfResult;
            if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                return offset;
            }
            Word cmpSourcePointer = StringUTF16Substitutions.charOffsetPointer(source, offset);
            if (GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer = StringUTF16Substitutions.pointer(target), targetCount, JavaKind.Char))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    @MethodSubstitution
    public static int indexOfLatin1Unsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringUTF16.indexOfLatin1Unsafe invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount <= 0");
        ReplacementsUtil.dynamicAssert(targetCount <= target.length, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.dynamicAssert(sourceCount >= targetCount, "StringUTF16.indexOfLatin1Unsafe invalid args: sourceCount < targetCount");
        if (targetCount == 1) {
            return ArrayIndexOf.indexOf1CharCompact(source, sourceCount, fromIndex, (char)Byte.toUnsignedInt(JDK9StringSubstitutions.getByte(target, 0)));
        }
        int offset = fromIndex;
        int haystackLength = sourceCount - (targetCount - 2);
        if (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            char c1 = (char)Byte.toUnsignedInt(JDK9StringSubstitutions.getByte(target, 0));
            char c2 = (char)Byte.toUnsignedInt(JDK9StringSubstitutions.getByte(target, 1));
            do {
                Word targetPointer;
                int indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, (indexOfResult = ArrayIndexOf.indexOfTwoConsecutiveChars(source, haystackLength, offset, c1, c2)) < 0)) {
                    return -1;
                }
                offset = indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                    return offset;
                }
                Word cmpSourcePointer = StringUTF16Substitutions.charOffsetPointer(source, offset);
                if (!GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer = StringUTF16Substitutions.pointer(target), targetCount, JavaKind.Char, JavaKind.Byte))) continue;
                return offset;
            } while (GraalDirectives.injectBranchProbability(0.75, ++offset < haystackLength));
        }
        return -1;
    }
}

