/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.aarch64;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.aarch64.AArch64ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.type.StampTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class AArch64CountTrailingZerosNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<AArch64CountTrailingZerosNode> TYPE = NodeClass.create(AArch64CountTrailingZerosNode.class);

    public AArch64CountTrailingZerosNode(ValueNode value) {
        super(TYPE, AArch64CountTrailingZerosNode.computeStamp(value.stamp(NodeView.DEFAULT), value), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        return AArch64CountTrailingZerosNode.computeStamp(newStamp, this.getValue());
    }

    static Stamp computeStamp(Stamp newStamp, ValueNode value) {
        assert (newStamp.isCompatible(value.stamp(NodeView.DEFAULT)));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        return StampTool.stampForTrailingZeros(valueStamp);
    }

    public static ValueNode tryFold(ValueNode value) {
        if (value.isConstant()) {
            JavaConstant c = value.asJavaConstant();
            if (value.getStackKind() == JavaKind.Int) {
                return ConstantNode.forInt(Integer.numberOfTrailingZeros(c.asInt()));
            }
            return ConstantNode.forInt(Long.numberOfTrailingZeros(c.asLong()));
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = AArch64CountTrailingZerosNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, ((AArch64ArithmeticLIRGeneratorTool)gen).emitCountTrailingZeros(builder.operand(this.getValue())));
    }
}

