/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.aarch64;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.SignedDivNode;
import org.graalvm.compiler.nodes.calc.SignedRemNode;
import org.graalvm.compiler.nodes.calc.UnsignedDivNode;
import org.graalvm.compiler.nodes.calc.UnsignedRemNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class AArch64IntegerArithmeticSnippets
extends SnippetTemplate.AbstractTemplates
implements Snippets {
    private final SnippetTemplate.SnippetInfo idiv = this.snippet(AArch64IntegerArithmeticSnippets.class, "idivSnippet", new LocationIdentity[0]);
    private final SnippetTemplate.SnippetInfo ldiv = this.snippet(AArch64IntegerArithmeticSnippets.class, "ldivSnippet", new LocationIdentity[0]);
    private final SnippetTemplate.SnippetInfo irem = this.snippet(AArch64IntegerArithmeticSnippets.class, "iremSnippet", new LocationIdentity[0]);
    private final SnippetTemplate.SnippetInfo lrem = this.snippet(AArch64IntegerArithmeticSnippets.class, "lremSnippet", new LocationIdentity[0]);
    private final SnippetTemplate.SnippetInfo uidiv = this.snippet(AArch64IntegerArithmeticSnippets.class, "uidivSnippet", new LocationIdentity[0]);
    private final SnippetTemplate.SnippetInfo uldiv = this.snippet(AArch64IntegerArithmeticSnippets.class, "uldivSnippet", new LocationIdentity[0]);
    private final SnippetTemplate.SnippetInfo uirem = this.snippet(AArch64IntegerArithmeticSnippets.class, "uiremSnippet", new LocationIdentity[0]);
    private final SnippetTemplate.SnippetInfo ulrem = this.snippet(AArch64IntegerArithmeticSnippets.class, "ulremSnippet", new LocationIdentity[0]);

    public AArch64IntegerArithmeticSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
        super(options, factories, providers, snippetReflection, target);
    }

    public void lower(IntegerDivRemNode node, LoweringTool tool) {
        SnippetTemplate.SnippetInfo snippet;
        JavaKind kind = node.stamp(NodeView.DEFAULT).getStackKind();
        assert (kind == JavaKind.Int || kind == JavaKind.Long);
        if (node instanceof SafeNode) {
            return;
        }
        if (node instanceof SignedDivNode) {
            snippet = kind == JavaKind.Int ? this.idiv : this.ldiv;
        } else if (node instanceof SignedRemNode) {
            snippet = kind == JavaKind.Int ? this.irem : this.lrem;
        } else if (node instanceof UnsignedDivNode) {
            snippet = kind == JavaKind.Int ? this.uidiv : this.uldiv;
        } else if (node instanceof UnsignedRemNode) {
            snippet = kind == JavaKind.Int ? this.uirem : this.ulrem;
        } else {
            throw GraalError.shouldNotReachHere();
        }
        StructuredGraph graph = node.graph();
        SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
        args.add("x", node.getX());
        args.add("y", node.getY());
        IntegerStamp yStamp = (IntegerStamp)node.getY().stamp(NodeView.DEFAULT);
        boolean needsZeroCheck = node.canDeoptimize() && node.getZeroCheck() == null && yStamp.contains(0L);
        args.addConst("needsZeroCheck", needsZeroCheck);
        this.template(node, args).instantiate(this.providers.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
    }

    @Snippet
    public static int idivSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeDiv(x, y);
    }

    @Snippet
    public static long ldivSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeDiv(x, y);
    }

    @Snippet
    public static int iremSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeRem(x, y);
    }

    @Snippet
    public static long lremSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeRem(x, y);
    }

    @Snippet
    public static int uidivSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeUDiv(x, y);
    }

    @Snippet
    public static long uldivSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeUDiv(x, y);
    }

    @Snippet
    public static int uiremSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeURem(x, y);
    }

    @Snippet
    public static long ulremSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            AArch64IntegerArithmeticSnippets.checkForZero(y);
        }
        return AArch64IntegerArithmeticSnippets.safeURem(x, y);
    }

    private static void checkForZero(int y) {
        if (BranchProbabilityNode.probability(0.0, y == 0)) {
            DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.ArithmeticException);
        }
    }

    private static void checkForZero(long y) {
        if (BranchProbabilityNode.probability(0.0, y == 0L)) {
            DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.ArithmeticException);
        }
    }

    @Node.NodeIntrinsic(value=SafeSignedDivNode.class)
    private static native int safeDiv(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeSignedDivNode.class)
    private static native long safeDiv(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeSignedRemNode.class)
    private static native int safeRem(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeSignedRemNode.class)
    private static native long safeRem(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeUnsignedDivNode.class)
    private static native int safeUDiv(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeUnsignedDivNode.class)
    private static native long safeUDiv(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeUnsignedRemNode.class)
    private static native int safeURem(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeUnsignedRemNode.class)
    private static native long safeURem(long var0, long var2);

    @NodeInfo
    static class SafeUnsignedRemNode
    extends UnsignedRemNode
    implements SafeNode {
        public static final NodeClass<SafeUnsignedRemNode> TYPE = NodeClass.create(SafeUnsignedRemNode.class);

        protected SafeUnsignedRemNode(ValueNode x, ValueNode y) {
            super(TYPE, x, y, null);
        }

        @Override
        public void generate(NodeLIRBuilderTool gen) {
            gen.setResult(this, gen.getLIRGeneratorTool().getArithmetic().emitURem(gen.operand(this.getX()), gen.operand(this.getY()), null));
        }
    }

    @NodeInfo
    static class SafeUnsignedDivNode
    extends UnsignedDivNode
    implements SafeNode {
        public static final NodeClass<SafeUnsignedDivNode> TYPE = NodeClass.create(SafeUnsignedDivNode.class);

        protected SafeUnsignedDivNode(ValueNode x, ValueNode y) {
            super(TYPE, x, y, null);
        }

        @Override
        public void generate(NodeLIRBuilderTool gen) {
            gen.setResult(this, gen.getLIRGeneratorTool().getArithmetic().emitUDiv(gen.operand(this.getX()), gen.operand(this.getY()), null));
        }
    }

    @NodeInfo
    static class SafeSignedRemNode
    extends SignedRemNode
    implements SafeNode {
        public static final NodeClass<SafeSignedRemNode> TYPE = NodeClass.create(SafeSignedRemNode.class);

        protected SafeSignedRemNode(ValueNode x, ValueNode y) {
            super(TYPE, x, y, null);
        }

        @Override
        protected SignedRemNode createWithInputs(ValueNode forX, ValueNode forY, GuardingNode forZeroCheck) {
            assert (forZeroCheck == null);
            return new SafeSignedRemNode(forX, forY);
        }

        @Override
        public void generate(NodeLIRBuilderTool gen) {
            gen.setResult(this, gen.getLIRGeneratorTool().getArithmetic().emitRem(gen.operand(this.getX()), gen.operand(this.getY()), null));
        }
    }

    @NodeInfo
    static class SafeSignedDivNode
    extends SignedDivNode
    implements SafeNode {
        public static final NodeClass<SafeSignedDivNode> TYPE = NodeClass.create(SafeSignedDivNode.class);

        protected SafeSignedDivNode(ValueNode x, ValueNode y) {
            super(TYPE, x, y, null);
        }

        @Override
        protected SignedDivNode createWithInputs(ValueNode forX, ValueNode forY, GuardingNode forZeroCheck, FrameState forStateBefore) {
            assert (forZeroCheck == null);
            return new SafeSignedDivNode(forX, forY);
        }

        @Override
        public void generate(NodeLIRBuilderTool gen) {
            gen.setResult(this, gen.getLIRGeneratorTool().getArithmetic().emitDiv(gen.operand(this.getX()), gen.operand(this.getY()), null));
        }
    }

    private static interface SafeNode {
    }
}

