/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOfWithMaskNode;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayRegionEqualsWithMaskNode;
import org.graalvm.compiler.replacements.nodes.TypePunnedArrayReadIntrinsic;
import org.graalvm.word.LocationIdentity;

public class AMD64TruffleArrayUtilsWithMaskSnippets
implements Snippets {
    @Snippet
    public static int indexOfByte1WithMask(byte[] array, int arrayLength, int fromIndex, byte v0, byte mask) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0 && arrayLength >= 0, "illegal arguments");
        byte[] arrayP = GraalDirectives.guardingNonNull(array);
        int i = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, i < arrayLength)) {
            byte b = (byte)(arrayP[i] | mask);
            if (GraalDirectives.injectBranchProbability(0.25, b == v0)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Snippet
    public static int indexOfChar1WithMask(char[] array, int arrayLength, int fromIndex, char v0, char mask) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0 && arrayLength >= 0, "illegal arguments");
        char[] arrayP = GraalDirectives.guardingNonNull(array);
        int i = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, i < arrayLength)) {
            char c = (char)(arrayP[i] | mask);
            if (GraalDirectives.injectBranchProbability(0.25, c == v0)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Snippet
    public static int indexOfCharCompact1WithMask(byte[] array, int arrayLength, int fromIndex, char v0, char mask) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0 && arrayLength >= 0, "illegal arguments");
        byte[] arrayP = GraalDirectives.guardingNonNull(array);
        int i = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, i < arrayLength)) {
            char element = (char)AMD64TruffleArrayUtilsWithMaskSnippets.typePunnedRead(JavaKind.Byte, JavaKind.Char, JavaKind.Char, arrayP, i, arrayLength);
            char c = (char)(element | mask);
            if (GraalDirectives.injectBranchProbability(0.25, c == v0)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Snippet
    public static int indexOf2ConsecutiveByteWithMask(byte[] array, int arrayLength, int fromIndex, int v0, int mask) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0 && arrayLength >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.indexOf2Consecutive(JavaKind.Byte, JavaKind.Byte, JavaKind.Char, GraalDirectives.guardingNonNull(array), arrayLength, fromIndex, v0, mask);
    }

    @Snippet
    public static int indexOf2ConsecutiveCharWithMask(char[] array, int arrayLength, int fromIndex, int v0, int mask) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0 && arrayLength >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.indexOf2Consecutive(JavaKind.Char, JavaKind.Char, JavaKind.Int, GraalDirectives.guardingNonNull(array), arrayLength, fromIndex, v0, mask);
    }

    @Snippet
    public static int indexOf2ConsecutiveCharCompactWithMask(byte[] array, int arrayLength, int fromIndex, int v0, int mask) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0 && arrayLength >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.indexOf2Consecutive(JavaKind.Byte, JavaKind.Char, JavaKind.Int, GraalDirectives.guardingNonNull(array), arrayLength, fromIndex, v0, mask);
    }

    private static int indexOf2Consecutive(JavaKind arrayKind, JavaKind valueKind, JavaKind cmpKind, Object array, int arrayLength, int fromIndex, int v0, int mask) {
        int i = fromIndex + 1;
        while (GraalDirectives.injectBranchProbability(0.75, i < arrayLength)) {
            long element = AMD64TruffleArrayUtilsWithMaskSnippets.typePunnedRead(arrayKind, valueKind, cmpKind, array, i - 1, arrayLength);
            if (GraalDirectives.injectBranchProbability(0.25, (element | (long)mask) == (long)v0)) {
                return i - 1;
            }
            ++i;
        }
        return -1;
    }

    @Snippet
    public static boolean arrayRegionEqualsWithMaskByte(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length, byte[] mask) {
        ReplacementsUtil.dynamicAssert(fromIndex1 >= 0 && fromIndex2 >= 0 && length >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsWithMask(JavaKind.Byte, JavaKind.Byte, GraalDirectives.guardingNonNull(a1), fromIndex1, GraalDirectives.guardingNonNull(a2), fromIndex2, length, GraalDirectives.guardingNonNull(mask));
    }

    @Snippet
    public static boolean arrayRegionEqualsWithMaskChar(char[] a1, int fromIndex1, char[] a2, int fromIndex2, int length, char[] mask) {
        ReplacementsUtil.dynamicAssert(fromIndex1 >= 0 && fromIndex2 >= 0 && length >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsWithMask(JavaKind.Char, JavaKind.Char, GraalDirectives.guardingNonNull(a1), fromIndex1, GraalDirectives.guardingNonNull(a2), fromIndex2, length, GraalDirectives.guardingNonNull(mask));
    }

    private static boolean arrayRegionEqualsWithMask(JavaKind arrayKind, JavaKind valueKind, Object a1, int fromIndex1, Object a2, int fromIndex2, int length, Object mask) {
        int stride = JavaKind.Long.getBitCount() / valueKind.getBitCount();
        if (GraalDirectives.injectBranchProbability(0.75, length >= stride)) {
            return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsTypePunnedLoop(arrayKind, valueKind, a1, fromIndex1, a2, fromIndex2, length, mask, stride);
        }
        int byteLength = length << Integer.numberOfTrailingZeros(valueKind.getByteCount());
        if (byteLength == 0) {
            return true;
        }
        if (byteLength < 2) {
            return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsTypePunned(arrayKind, valueKind, JavaKind.Byte, a1, fromIndex1, a2, fromIndex2, length, mask);
        }
        if (byteLength < 4) {
            return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsTypePunned(arrayKind, valueKind, JavaKind.Char, a1, fromIndex1, a2, fromIndex2, length, mask);
        }
        ReplacementsUtil.dynamicAssert(byteLength < 8, "regionEquals does not cover the given length");
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsTypePunned(arrayKind, valueKind, JavaKind.Int, a1, fromIndex1, a2, fromIndex2, length, mask);
    }

    private static boolean arrayRegionEqualsTypePunnedLoop(JavaKind arrayKind, JavaKind valueKind, Object a1, int fromIndex1, Object a2, int fromIndex2, int length, Object mask, int stride) {
        int max = length - stride;
        int i = 0;
        while (GraalDirectives.injectBranchProbability(0.75, i < max)) {
            if (GraalDirectives.injectBranchProbability(0.25, !AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsTypePunnedCmp(arrayKind, valueKind, JavaKind.Long, a1, fromIndex1, a2, fromIndex2, length, mask, i, fromIndex1 + i, fromIndex2 + i))) {
                return false;
            }
            i += stride;
        }
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsTypePunnedCmp(arrayKind, valueKind, JavaKind.Long, a1, fromIndex1, a2, fromIndex2, length, mask, max, fromIndex1 + max, fromIndex2 + max);
    }

    private static boolean arrayRegionEqualsTypePunned(JavaKind arrayKind, JavaKind valueKind, JavaKind cmpKind, Object a1, int fromIndex1, Object a2, int fromIndex2, int length, Object mask) {
        int tailOffset = length - cmpKind.getByteCount() / valueKind.getByteCount();
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsTypePunnedCmp(arrayKind, valueKind, cmpKind, a1, fromIndex1, a2, fromIndex2, length, mask, 0, fromIndex1, fromIndex2) && AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsTypePunnedCmp(arrayKind, valueKind, cmpKind, a1, fromIndex1, a2, fromIndex2, length, mask, tailOffset, fromIndex1 + tailOffset, fromIndex2 + tailOffset);
    }

    private static boolean arrayRegionEqualsTypePunnedCmp(JavaKind arrayKind, JavaKind valueKind, JavaKind cmpKind, Object a1, int fromIndex1, Object a2, int fromIndex2, int length, Object mask, int iMsk, int iA1, int iA2) {
        long vA2;
        long vMsk = AMD64TruffleArrayUtilsWithMaskSnippets.typePunnedRead(arrayKind, valueKind, cmpKind, mask, iMsk, length);
        long vA1 = AMD64TruffleArrayUtilsWithMaskSnippets.typePunnedRead(arrayKind, valueKind, cmpKind, a1, iA1, fromIndex1 + length);
        return (vA1 | vMsk) == (vA2 = AMD64TruffleArrayUtilsWithMaskSnippets.typePunnedRead(arrayKind, valueKind, cmpKind, a2, iA2, fromIndex2 + length));
    }

    @Snippet
    public static boolean arrayRegionEqualsWithMaskCBB(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length, byte[] mask) {
        ReplacementsUtil.dynamicAssert(fromIndex1 >= 0 && fromIndex2 >= 0 && length >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsDifferentKinds(JavaKind.Char, JavaKind.Byte, JavaKind.Byte, GraalDirectives.guardingNonNull(a1), fromIndex1, GraalDirectives.guardingNonNull(a2), fromIndex2, length, GraalDirectives.guardingNonNull(mask));
    }

    @Snippet
    public static boolean arrayRegionEqualsWithMaskBCB(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length, byte[] mask) {
        ReplacementsUtil.dynamicAssert(fromIndex1 >= 0 && fromIndex2 >= 0 && length >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsDifferentKinds(JavaKind.Byte, JavaKind.Char, JavaKind.Byte, GraalDirectives.guardingNonNull(a1), fromIndex1, GraalDirectives.guardingNonNull(a2), fromIndex2, length, GraalDirectives.guardingNonNull(mask));
    }

    @Snippet
    public static boolean arrayRegionEqualsWithMaskCCB(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length, byte[] mask) {
        ReplacementsUtil.dynamicAssert(fromIndex1 >= 0 && fromIndex2 >= 0 && length >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsDifferentKinds(JavaKind.Char, JavaKind.Char, JavaKind.Byte, GraalDirectives.guardingNonNull(a1), fromIndex1, GraalDirectives.guardingNonNull(a2), fromIndex2, length, GraalDirectives.guardingNonNull(mask));
    }

    @Snippet
    public static boolean arrayRegionEqualsWithMaskBCC(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length, byte[] mask) {
        ReplacementsUtil.dynamicAssert(fromIndex1 >= 0 && fromIndex2 >= 0 && length >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsDifferentKinds(JavaKind.Byte, JavaKind.Char, JavaKind.Char, GraalDirectives.guardingNonNull(a1), fromIndex1, GraalDirectives.guardingNonNull(a2), fromIndex2, length, GraalDirectives.guardingNonNull(mask));
    }

    @Snippet
    public static boolean arrayRegionEqualsWithMaskCCC(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length, byte[] mask) {
        ReplacementsUtil.dynamicAssert(fromIndex1 >= 0 && fromIndex2 >= 0 && length >= 0, "illegal arguments");
        return AMD64TruffleArrayUtilsWithMaskSnippets.arrayRegionEqualsWithMask(JavaKind.Byte, JavaKind.Char, GraalDirectives.guardingNonNull(a1), fromIndex1, GraalDirectives.guardingNonNull(a2), fromIndex2, length, GraalDirectives.guardingNonNull(mask));
    }

    private static boolean arrayRegionEqualsDifferentKinds(JavaKind valueKind1, JavaKind valueKind2, JavaKind valueKindMask, byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length, byte[] mask) {
        int i = 0;
        while (GraalDirectives.injectBranchProbability(0.75, i < length)) {
            char c1 = AMD64TruffleArrayUtilsWithMaskSnippets.readChar(valueKind1, a1, fromIndex1 + i);
            if (GraalDirectives.injectBranchProbability(0.25, (c1 | AMD64TruffleArrayUtilsWithMaskSnippets.readChar(valueKindMask, mask, i)) != AMD64TruffleArrayUtilsWithMaskSnippets.readChar(valueKind2, a2, fromIndex2 + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static char readChar(JavaKind valueKind, byte[] array, int i) {
        if (valueKind == JavaKind.Byte) {
            return (char)array[i];
        }
        ReplacementsUtil.dynamicAssert(valueKind == JavaKind.Char, "unexpected valueKind");
        return (char)AMD64TruffleArrayUtilsWithMaskSnippets.typePunnedRead(JavaKind.Byte, JavaKind.Byte, valueKind, array, i << 1, array.length);
    }

    private static long typePunnedRead(JavaKind arrayKind, JavaKind valueKind, JavaKind cmpKind, Object array, long index, int arrayLength) {
        ReplacementsUtil.dynamicAssert(index >= 0L && index + (long)(cmpKind.getByteCount() / valueKind.getByteCount()) <= (long)arrayLength, "type punned read is out of bounds!");
        return cmpKind == JavaKind.Long ? TypePunnedArrayReadIntrinsic.ReadLong.read(arrayKind, valueKind, array, index) : (long)TypePunnedArrayReadIntrinsic.read(arrayKind, valueKind, cmpKind, array, index);
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo[] indexOfWithMaskSnippets = new SnippetTemplate.SnippetInfo[6];
        private final SnippetTemplate.SnippetInfo[] regionEqualsSnippets;
        private static final LoweringTool.StandardLoweringStage LOWERING_STAGE = LoweringTool.StandardLoweringStage.HIGH_TIER;

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers runtime, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            super(options, factories, runtime, snippetReflection, target);
            this.indexOfWithMaskSnippets[0] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "indexOfByte1WithMask", new LocationIdentity[0]);
            this.indexOfWithMaskSnippets[1] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "indexOf2ConsecutiveByteWithMask", new LocationIdentity[0]);
            this.indexOfWithMaskSnippets[2] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "indexOfCharCompact1WithMask", new LocationIdentity[0]);
            this.indexOfWithMaskSnippets[3] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "indexOf2ConsecutiveCharCompactWithMask", new LocationIdentity[0]);
            this.indexOfWithMaskSnippets[4] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "indexOfChar1WithMask", new LocationIdentity[0]);
            this.indexOfWithMaskSnippets[5] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "indexOf2ConsecutiveCharWithMask", new LocationIdentity[0]);
            this.regionEqualsSnippets = new SnippetTemplate.SnippetInfo[8];
            this.regionEqualsSnippets[0] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "arrayRegionEqualsWithMaskByte", new LocationIdentity[0]);
            this.regionEqualsSnippets[1] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "arrayRegionEqualsWithMaskChar", new LocationIdentity[0]);
            this.regionEqualsSnippets[2] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "arrayRegionEqualsWithMaskBCB", new LocationIdentity[0]);
            this.regionEqualsSnippets[3] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "arrayRegionEqualsWithMaskCCB", new LocationIdentity[0]);
            this.regionEqualsSnippets[4] = this.regionEqualsSnippets[0];
            this.regionEqualsSnippets[5] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "arrayRegionEqualsWithMaskCBB", new LocationIdentity[0]);
            this.regionEqualsSnippets[6] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "arrayRegionEqualsWithMaskBCC", new LocationIdentity[0]);
            this.regionEqualsSnippets[7] = this.snippet(AMD64TruffleArrayUtilsWithMaskSnippets.class, "arrayRegionEqualsWithMaskCCC", new LocationIdentity[0]);
        }

        public void lower(AMD64ArrayIndexOfWithMaskNode write) {
            SnippetTemplate.SnippetInfo snippet = this.indexOfWithMaskSnippets[(write.getArrayKind().equals((Object)JavaKind.Byte) ? (write.getValueKind().equals((Object)JavaKind.Byte) ? 0 : 2) : 4) + (write.isFindTwoConsecutive() ? 1 : 0)];
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, write.graph().getGuardsStage(), LOWERING_STAGE);
            args.add("array", write.getArrayPointer());
            args.add("arrayLength", write.getArrayLength());
            args.add("fromIndex", write.getFromIndex());
            args.add("v0", write.getSearchValue());
            args.add("mask", write.getMask());
            this.instantiate(args, write);
        }

        public void lower(AMD64ArrayRegionEqualsWithMaskNode write) {
            SnippetTemplate.SnippetInfo snippet = this.regionEqualsSnippets[write.sameKinds() ? Templates.kind2IndexB(write.getArrayKind(), 1) : 2 + Templates.kind2IndexB(write.getKindMask(), 4) + Templates.kind2IndexC(write.getKind2(), 2) + Templates.kind2IndexB(write.getKind1(), 1)];
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, write.graph().getGuardsStage(), LOWERING_STAGE);
            args.add("a1", write.getArray1());
            args.add("fromIndex1", write.getFromIndex1());
            args.add("a2", write.getArray2());
            args.add("fromIndex2", write.getFromIndex2());
            args.add("length", write.getLength());
            args.add("mask", write.getArrayMask());
            this.instantiate(args, write);
        }

        private void instantiate(SnippetTemplate.Arguments args, FixedWithNextNode arrayOperation) {
            StructuredGraph graph = arrayOperation.graph();
            SnippetTemplate template = this.template(arrayOperation, args);
            FrameState beforeState = GraphUtil.findLastFrameState(arrayOperation);
            UnmodifiableEconomicMap<Node, Node> replacements = template.instantiate(this.providers.getMetaAccess(), arrayOperation, SnippetTemplate.DEFAULT_REPLACER, args, false);
            for (Node originalNode : replacements.getKeys()) {
                if (!(originalNode instanceof AbstractMergeNode) && !(originalNode instanceof LoopExitNode)) continue;
                StateSplit s = (StateSplit)replacements.get((Object)originalNode);
                assert (s.asNode().graph() == graph);
                if (s.stateAfter() != null) continue;
                s.setStateAfter(beforeState.duplicateWithVirtualState());
            }
            GraphUtil.killCFG(arrayOperation);
        }

        private static int kind2IndexB(JavaKind kind, int i) {
            return kind.equals((Object)JavaKind.Byte) ? 0 : i;
        }

        private static int kind2IndexC(JavaKind kind, int i) {
            return kind.equals((Object)JavaKind.Char) ? 0 : i;
        }
    }
}

