/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.arraycopy;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GetObjectAddressNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory, InputType.Value}, cycles=NodeCycles.CYCLES_UNKNOWN, sizeRationale="depends on length", size=NodeSize.SIZE_UNKNOWN, cyclesRationale="depends on length")
public final class CheckcastArrayCopyCallNode
extends AbstractMemoryCheckpoint
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<CheckcastArrayCopyCallNode> TYPE = NodeClass.create(CheckcastArrayCopyCallNode.class);
    private final ArrayCopyForeignCalls foreignCalls;
    private final JavaKind wordKind;
    @Node.Input
    ValueNode src;
    @Node.Input
    ValueNode srcPos;
    @Node.Input
    ValueNode dest;
    @Node.Input
    ValueNode destPos;
    @Node.Input
    ValueNode length;
    @Node.Input
    ValueNode destElemKlass;
    @Node.Input
    ValueNode superCheckOffset;
    protected final boolean uninit;

    protected CheckcastArrayCopyCallNode(@Node.InjectedNodeParameter ArrayCopyForeignCalls foreignCalls, @Node.InjectedNodeParameter WordTypes wordTypes, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, ValueNode superCheckOffset, ValueNode destElemKlass, boolean uninit) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.foreignCalls = foreignCalls;
        this.wordKind = wordTypes.getWordKind();
        this.src = src;
        this.srcPos = srcPos;
        this.dest = dest;
        this.destPos = destPos;
        this.length = length;
        this.superCheckOffset = superCheckOffset;
        this.destElemKlass = destElemKlass;
        this.uninit = uninit;
    }

    public ValueNode getSource() {
        return this.src;
    }

    public ValueNode getSourcePosition() {
        return this.srcPos;
    }

    public ValueNode getDestination() {
        return this.dest;
    }

    public ValueNode getDestinationPosition() {
        return this.destPos;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public boolean isUninit() {
        return this.uninit;
    }

    private ValueNode computeBase(LoweringTool tool, ValueNode base, ValueNode pos) {
        FixedWithNextNode basePtr = this.graph().add(new GetObjectAddressNode(base));
        this.graph().addBeforeFixed(this, basePtr);
        int shift = CodeUtil.log2((int)tool.getMetaAccess().getArrayIndexScale(JavaKind.Object));
        ValueNode extendedPos = IntegerConvertNode.convert(pos, StampFactory.forKind(this.wordKind), this.graph(), NodeView.DEFAULT);
        ValueNode scaledIndex = this.graph().unique(new LeftShiftNode(extendedPos, ConstantNode.forInt(shift, this.graph())));
        ValueNode offset = this.graph().unique(new AddNode(scaledIndex, ConstantNode.forIntegerBits(PrimitiveStamp.getBits(scaledIndex.stamp(NodeView.DEFAULT)), tool.getMetaAccess().getArrayBaseOffset(JavaKind.Object), this.graph())));
        return this.graph().unique(new OffsetAddressNode(basePtr, offset));
    }

    @Override
    public void lower(LoweringTool tool) {
        if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            ForeignCallDescriptor desc = this.foreignCalls.lookupCheckcastArraycopyDescriptor(this.isUninit());
            StructuredGraph graph = this.graph();
            ValueNode srcAddr = this.computeBase(tool, this.getSource(), this.getSourcePosition());
            ValueNode destAddr = this.computeBase(tool, this.getDestination(), this.getDestinationPosition());
            ValueNode len = this.getLength();
            if (len.stamp(NodeView.DEFAULT).getStackKind() != this.wordKind) {
                len = IntegerConvertNode.convert(len, StampFactory.forKind(this.wordKind), this.graph(), NodeView.DEFAULT);
            }
            ForeignCallNode call = graph.add(new ForeignCallNode(desc, srcAddr, destAddr, len, this.superCheckOffset, this.destElemKlass));
            call.setStateAfter(this.stateAfter());
            graph.replaceFixedWithFixed(this, call);
        }
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Node.NodeIntrinsic
    public static native int checkcastArraycopy(Object var0, int var1, Object var2, int var3, int var4, Word var5, Object var6, @Node.ConstantNodeParameter boolean var7);
}

