/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.nio.ByteOrder;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.word.WordCastNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public class ArrayRegionEqualsNode
extends FixedWithNextNode
implements Canonicalizable,
LIRLowerable,
MemoryAccess {
    public static final NodeClass<ArrayRegionEqualsNode> TYPE = NodeClass.create(ArrayRegionEqualsNode.class);
    protected final JavaKind kind1;
    protected final JavaKind kind2;
    @Node.Input
    protected ValueNode array1;
    @Node.Input
    protected ValueNode array2;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput(value=InputType.Memory)
    protected MemoryKill lastLocationAccess;

    public ArrayRegionEqualsNode(ValueNode array1, ValueNode array2, ValueNode length, @Node.ConstantNodeParameter JavaKind kind1, @Node.ConstantNodeParameter JavaKind kind2) {
        this(TYPE, array1, array2, length, kind1, kind2);
    }

    protected ArrayRegionEqualsNode(NodeClass<? extends ArrayRegionEqualsNode> c, ValueNode array1, ValueNode array2, ValueNode length, @Node.ConstantNodeParameter JavaKind kind1, @Node.ConstantNodeParameter JavaKind kind2) {
        super((NodeClass<? extends FixedWithNextNode>)c, StampFactory.forKind(JavaKind.Boolean));
        this.kind1 = kind1;
        this.kind2 = kind2;
        this.array1 = array1;
        this.array2 = array2;
        this.length = length;
        assert (kind1.isPrimitive() && kind2.isPrimitive()) : "expected primitive kinds, got: " + kind1 + ", " + kind2;
        assert (kind1 == kind2 || kind1 == JavaKind.Char && kind2 == JavaKind.Byte) : "expected equal kinds or char+byte, got: " + kind1 + ", " + kind2;
    }

    public static boolean regionEquals(Pointer array1, Pointer array2, int length, @Node.ConstantNodeParameter JavaKind kind) {
        return ArrayRegionEqualsNode.regionEquals(array1, array2, length, kind, kind);
    }

    @Node.NodeIntrinsic
    public static native boolean regionEquals(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter JavaKind var3, @Node.ConstantNodeParameter JavaKind var4);

    public ValueNode getArray1() {
        return this.array1;
    }

    public ValueNode getArray2() {
        return this.array2;
    }

    public JavaKind getKind1() {
        return this.kind1;
    }

    public JavaKind getKind2() {
        return this.kind2;
    }

    public ValueNode getLength() {
        return this.length;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length));
            gen.setResult(this, (Value)result);
            return;
        }
        this.generateArrayRegionEquals(gen);
    }

    protected int getArrayBaseOffset(MetaAccessProvider metaAccess, ValueNode array, JavaKind elementKind) {
        return metaAccess.getArrayBaseOffset(elementKind);
    }

    protected void generateArrayRegionEquals(NodeLIRBuilderTool gen) {
        MetaAccessProvider metaAccess = gen.getLIRGeneratorTool().getMetaAccess();
        int array1BaseOffset = this.getArrayBaseOffset(metaAccess, this.array1, this.kind1);
        int array2BaseOffset = this.getArrayBaseOffset(metaAccess, this.array2, this.kind2);
        Variable result = this.kind1 == this.kind2 ? gen.getLIRGeneratorTool().emitArrayEquals(this.kind1, array1BaseOffset, array2BaseOffset, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length), true) : gen.getLIRGeneratorTool().emitArrayEquals(this.kind1, this.kind2, array1BaseOffset, array2BaseOffset, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length), true);
        gen.setResult(this, (Value)result);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.kind1 != this.kind2 ? LocationIdentity.ANY_LOCATION : NamedLocationIdentity.getArrayLocation(this.kind1);
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (this.length.isJavaConstant() && this.array1 instanceof AddNode && this.array2 instanceof AddNode) {
            int len = this.length.asJavaConstant().asInt();
            ValueNode arrayBase1 = ((AddNode)this.array1).getX();
            ValueNode arrayBase2 = ((AddNode)this.array2).getX();
            if (arrayBase1 instanceof WordCastNode && arrayBase2 instanceof WordCastNode) {
                arrayBase1 = ((WordCastNode)arrayBase1).getInput();
                arrayBase2 = ((WordCastNode)arrayBase2).getInput();
                ValueNode arrayOffset1 = ((AddNode)this.array1).getY();
                ValueNode arrayOffset2 = ((AddNode)this.array2).getY();
                if (this.canFoldReads(tool, arrayBase1, arrayOffset1, this.kind1, len) && this.canFoldReads(tool, arrayBase2, arrayOffset2, this.kind2, len)) {
                    Integer startIndex1 = this.startIndex(tool, arrayBase1, arrayOffset1.asJavaConstant(), this.kind1);
                    Integer startIndex2 = this.startIndex(tool, arrayBase2, arrayOffset2.asJavaConstant(), this.kind2);
                    if (this.kind1 == this.kind2) {
                        return ConstantNode.forBoolean(ArrayEqualsNode.arrayEquals(tool.getConstantReflection(), arrayBase1.asJavaConstant(), startIndex1, arrayBase2.asJavaConstant(), startIndex2, len));
                    }
                    assert (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Byte);
                    return ConstantNode.forBoolean(ArrayRegionEqualsNode.mixedArrayRegionEquals(tool.getConstantReflection(), arrayBase1.asJavaConstant(), startIndex1, arrayBase2.asJavaConstant(), startIndex2, len));
                }
            }
        }
        return this;
    }

    private boolean canFoldReads(CanonicalizerTool tool, ValueNode array, ValueNode offset, JavaKind elementKind, int len) {
        if (array.isJavaConstant() && ((ConstantNode)array).getStableDimension() >= 1 && offset.isJavaConstant()) {
            ConstantReflectionProvider c = tool.getConstantReflection();
            Integer arrayLength = c.readArrayLength(array.asJavaConstant());
            Integer index = this.startIndex(tool, array, offset.asJavaConstant(), elementKind);
            return arrayLength != null && index != null && index >= 0 && index + len <= arrayLength;
        }
        return false;
    }

    private Integer startIndex(CanonicalizerTool tool, ValueNode array, JavaConstant offset, JavaKind elementKind) {
        long elementOffset = offset.asLong() - (long)this.getArrayBaseOffset(tool.getMetaAccess(), array, elementKind);
        if (elementOffset % (long)elementKind.getByteCount() != 0L) {
            return null;
        }
        return (int)(elementOffset / (long)elementKind.getByteCount());
    }

    protected static boolean mixedArrayRegionEquals(ConstantReflectionProvider constantReflection, JavaConstant a, int startIndexA, JavaConstant b, int startIndexB, int len) {
        for (int i = 0; i < len; ++i) {
            int byteValue;
            int b0 = constantReflection.readArrayElement(a, startIndexA + i * 2).asInt() & 0xFF;
            int b1 = constantReflection.readArrayElement(a, startIndexA + i * 2 + 1).asInt() & 0xFF;
            char charValue = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? (char)(b0 << 8 | b1) : (char)(b0 | b1 << 8);
            if (charValue == (byteValue = constantReflection.readArrayElement(b, startIndexB + i).asInt() & 0xFF)) continue;
            return false;
        }
        return true;
    }
}

