/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopy;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_64)
public class BasicArrayCopyNode
extends AbstractMemoryCheckpoint
implements ArrayCopy {
    public static final NodeClass<BasicArrayCopyNode> TYPE = NodeClass.create(BasicArrayCopyNode.class);
    @Node.Input
    NodeInputList<ValueNode> args;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;
    @Node.OptionalInput(value=InputType.Memory)
    protected MemoryKill lastLocationAccess;
    protected JavaKind elementKind;
    protected int bci;

    public BasicArrayCopyNode(NodeClass<? extends AbstractMemoryCheckpoint> type, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind, int bci) {
        super(type, StampFactory.forKind(JavaKind.Void));
        this.bci = bci;
        this.args = new NodeInputList((Node)this, (Node[])new ValueNode[]{src, srcPos, dest, destPos, length});
        this.elementKind = elementKind != JavaKind.Illegal ? elementKind : null;
    }

    public BasicArrayCopyNode(NodeClass<? extends AbstractMemoryCheckpoint> type, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind) {
        this(type, src, srcPos, dest, destPos, length, elementKind, -6);
    }

    @Override
    public NodeInputList<ValueNode> args() {
        return this.args;
    }

    @Override
    public int getBci() {
        return this.bci;
    }

    @Override
    public JavaKind getElementKind() {
        return this.elementKind;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        if (this.elementKind != null) {
            return NamedLocationIdentity.getArrayLocation(this.elementKind);
        }
        return LocationIdentity.any();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.getLocationIdentity();
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface(this.lastLocationAccess, lla);
        this.lastLocationAccess = lla;
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }
}

