/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo
public abstract class IdentityHashCodeNode
extends AbstractStateSplit
implements Canonicalizable,
Lowerable,
SingleMemoryKill,
DeoptBciSupplier {
    public static final NodeClass<IdentityHashCodeNode> TYPE = NodeClass.create(IdentityHashCodeNode.class);
    @Node.Input
    ValueNode object;
    private int bci;

    protected IdentityHashCodeNode(NodeClass<? extends IdentityHashCodeNode> c, ValueNode object, int bci) {
        super((NodeClass<? extends AbstractStateSplit>)c, (Stamp)StampFactory.forInteger(32));
        this.object = object;
        this.bci = bci;
    }

    public ValueNode object() {
        return this.object;
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setBci(int bci) {
        this.bci = bci;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.object.isConstant()) {
            assert (this.object.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp);
            JavaConstant c = (JavaConstant)this.object.asConstant();
            if (GraalOptions.ImmutableCode.getValue(tool.getOptions()).booleanValue()) {
                return this;
            }
            int identityHashCode = c.isNull() ? 0 : this.getIdentityHashCode(c);
            return ConstantNode.forInt(identityHashCode);
        }
        return this;
    }

    protected abstract int getIdentityHashCode(JavaConstant var1);
}

