/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.Collection;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.ResolvedMethodHandleCallTargetNodeMarker;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;
import org.graalvm.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate")
public abstract class MacroNode
extends FixedWithNextNode
implements MacroInvokable {
    public static final NodeClass<MacroNode> TYPE = NodeClass.create(MacroNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    protected final int bci;
    protected final ResolvedJavaMethod callerMethod;
    protected final ResolvedJavaMethod targetMethod;
    protected final CallTargetNode.InvokeKind invokeKind;
    protected final StampPair returnStamp;
    protected ResolvedJavaMethod originalTargetMethod;
    protected StampPair originalReturnStamp;
    @Node.Input
    NodeInputList<ValueNode> originalArguments;

    protected MacroNode(NodeClass<? extends MacroNode> c, MacroParams p) {
        super((NodeClass<? extends FixedWithNextNode>)c, p.returnStamp != null ? p.returnStamp.getTrustedStamp() : null);
        this.arguments = new NodeInputList((Node)this, (Node[])p.arguments);
        this.bci = p.bci;
        this.callerMethod = p.callerMethod;
        this.targetMethod = p.targetMethod;
        this.returnStamp = p.returnStamp;
        this.invokeKind = p.invokeKind;
        assert (!BytecodeFrame.isPlaceholderBci((int)p.bci));
        assert (MacroInvokable.assertArgumentCount(this));
        this.originalArguments = new NodeInputList(this);
    }

    @Override
    public ResolvedJavaMethod getContextMethod() {
        return this.callerMethod;
    }

    @Override
    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    public ValueNode[] toArgumentArray() {
        return this.arguments.toArray((A[])new ValueNode[0]);
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public ResolvedJavaMethod getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public CallTargetNode.InvokeKind getInvokeKind() {
        return this.invokeKind;
    }

    @Override
    public StampPair getReturnStamp() {
        return this.returnStamp;
    }

    @Override
    public NodeInputList<ValueNode> getOriginalArguments() {
        return this.originalArguments;
    }

    @Override
    public ResolvedJavaMethod getOriginalTargetMethod() {
        return this.originalTargetMethod;
    }

    @Override
    public StampPair getOriginalReturnStamp() {
        return this.originalReturnStamp;
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public FixedNode asFixedNode() {
        return this;
    }

    @Override
    public Invoke replaceWithInvoke() {
        try (DebugCloseable context = this.withNodeSourcePosition();){
            InvokeNode invoke = this.createInvoke();
            this.graph().replaceFixedWithFixed(this, invoke);
            InvokeNode invokeNode = invoke;
            return invokeNode;
        }
    }

    public LocationIdentity getLocationIdentity() {
        return LocationIdentity.any();
    }

    protected InvokeNode createInvoke() {
        MethodCallTargetNode callTarget = this.createCallTarget();
        InvokeNode invoke = this.graph().add(new InvokeNode((CallTargetNode)callTarget, this.bci, this.getLocationIdentity()));
        return invoke;
    }

    @Override
    public void addMethodHandleInfo(ResolvedMethodHandleCallTargetNodeMarker methodHandleMarker) {
        ResolvedMethodHandleCallTargetNode methodHandle = (ResolvedMethodHandleCallTargetNode)methodHandleMarker;
        assert (this.originalArguments.size() == 0 && this.originalReturnStamp == null & this.originalTargetMethod == null) : this;
        this.originalReturnStamp = methodHandle.originalReturnStamp;
        this.originalTargetMethod = methodHandle.originalTargetMethod;
        this.originalArguments.addAll((Collection<ValueNode>)methodHandle.originalArguments);
    }

    public static class MacroParams {
        public final CallTargetNode.InvokeKind invokeKind;
        public final ResolvedJavaMethod callerMethod;
        public final ResolvedJavaMethod targetMethod;
        public final int bci;
        public final StampPair returnStamp;
        public final ValueNode[] arguments;

        public MacroParams(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod callerMethod, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
            this.invokeKind = invokeKind;
            this.callerMethod = callerMethod;
            this.targetMethod = targetMethod;
            this.bci = bci;
            this.returnStamp = returnStamp;
            this.arguments = arguments;
        }

        public static MacroParams of(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
            return new MacroParams(b.getInvokeKind(), b.getMethod(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), arguments);
        }

        public static MacroParams of(GraphBuilderContext b, CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
            return new MacroParams(invokeKind, b.getMethod(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), arguments);
        }

        public static MacroParams of(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod callerMethod, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
            return new MacroParams(invokeKind, callerMethod, targetMethod, bci, returnStamp, arguments);
        }
    }
}

