/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.Collection;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.ResolvedMethodHandleCallTargetNodeMarker;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate")
public abstract class MacroStateSplitWithExceptionNode
extends WithExceptionNode
implements MacroInvokable,
StateSplit,
SingleMemoryKill {
    public static final NodeClass<MacroStateSplitWithExceptionNode> TYPE = NodeClass.create(MacroStateSplitWithExceptionNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    protected final int bci;
    protected final ResolvedJavaMethod callerMethod;
    protected final ResolvedJavaMethod targetMethod;
    protected final CallTargetNode.InvokeKind invokeKind;
    protected final StampPair returnStamp;
    protected ResolvedJavaMethod originalTargetMethod;
    protected StampPair originalReturnStamp;
    @Node.Input
    NodeInputList<ValueNode> originalArguments;

    protected MacroStateSplitWithExceptionNode(NodeClass<? extends MacroStateSplitWithExceptionNode> c, MacroNode.MacroParams p) {
        super((NodeClass<? extends WithExceptionNode>)c, p.returnStamp != null ? p.returnStamp.getTrustedStamp() : null);
        this.arguments = new NodeInputList((Node)this, (Node[])p.arguments);
        this.bci = p.bci;
        this.callerMethod = p.callerMethod;
        this.targetMethod = p.targetMethod;
        this.returnStamp = p.returnStamp;
        this.invokeKind = p.invokeKind;
        assert (!BytecodeFrame.isPlaceholderBci((int)p.bci));
        assert (MacroInvokable.assertArgumentCount(this));
        this.originalArguments = new NodeInputList(this);
    }

    @Override
    public ResolvedJavaMethod getContextMethod() {
        return this.callerMethod;
    }

    @Override
    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public ResolvedJavaMethod getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public CallTargetNode.InvokeKind getInvokeKind() {
        return this.invokeKind;
    }

    @Override
    public StampPair getReturnStamp() {
        return this.returnStamp;
    }

    @Override
    public NodeInputList<ValueNode> getOriginalArguments() {
        return this.originalArguments;
    }

    @Override
    public ResolvedJavaMethod getOriginalTargetMethod() {
        return this.originalTargetMethod;
    }

    @Override
    public StampPair getOriginalReturnStamp() {
        return this.originalReturnStamp;
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public FixedNode asFixedNode() {
        return this;
    }

    @Override
    public Invoke replaceWithInvoke() {
        try (DebugCloseable context = this.withNodeSourcePosition();){
            InvokeWithExceptionNode invoke = this.createInvoke();
            this.graph().replaceWithExceptionSplit(this, invoke);
            InvokeWithExceptionNode invokeWithExceptionNode = invoke;
            return invokeWithExceptionNode;
        }
    }

    public LocationIdentity getLocationIdentity() {
        return LocationIdentity.any();
    }

    protected InvokeWithExceptionNode createInvoke() {
        return this.createInvoke(this);
    }

    public InvokeWithExceptionNode createInvoke(Node oldResult) {
        MethodCallTargetNode callTarget = this.createCallTarget();
        InvokeWithExceptionNode invoke = this.graph().add(new InvokeWithExceptionNode(callTarget, null, this.bci));
        if (this.stateAfter() != null) {
            invoke.setStateAfter(this.stateAfter().duplicate());
            if (this.getStackKind() != JavaKind.Void) {
                invoke.stateAfter().replaceFirstInput(oldResult, invoke);
            }
        }
        return invoke;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public void addMethodHandleInfo(ResolvedMethodHandleCallTargetNodeMarker methodHandleMarker) {
        ResolvedMethodHandleCallTargetNode methodHandle = (ResolvedMethodHandleCallTargetNode)methodHandleMarker;
        assert (this.originalArguments.size() == 0 && this.originalReturnStamp == null & this.originalTargetMethod == null) : this;
        this.originalReturnStamp = methodHandle.originalReturnStamp;
        this.originalTargetMethod = methodHandle.originalTargetMethod;
        this.originalArguments.addAll((Collection<ValueNode>)methodHandle.originalArguments);
    }
}

