/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.ResolvedMethodHandleCallTargetNodeMarker;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo
public final class ResolvedMethodHandleCallTargetNode
extends ResolvedMethodHandleCallTargetNodeMarker
implements Lowerable {
    public static final NodeClass<ResolvedMethodHandleCallTargetNode> TYPE = NodeClass.create(ResolvedMethodHandleCallTargetNode.class);
    protected final ResolvedJavaMethod originalTargetMethod;
    protected final StampPair originalReturnStamp;
    @Node.Input
    NodeInputList<ValueNode> originalArguments;

    public static MethodCallTargetNode create(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] arguments, StampPair returnStamp, ResolvedJavaMethod originalTargetMethod, ValueNode[] originalArguments, StampPair originalReturnStamp) {
        return new ResolvedMethodHandleCallTargetNode(invokeKind, targetMethod, arguments, returnStamp, originalTargetMethod, originalArguments, originalReturnStamp);
    }

    protected ResolvedMethodHandleCallTargetNode(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] arguments, StampPair returnStamp, ResolvedJavaMethod originalTargetMethod, ValueNode[] originalArguments, StampPair originalReturnStamp) {
        super((NodeClass<? extends ResolvedMethodHandleCallTargetNodeMarker>)TYPE, invokeKind, targetMethod, arguments, returnStamp, (JavaTypeProfile)null);
        this.originalTargetMethod = originalTargetMethod;
        this.originalReturnStamp = originalReturnStamp;
        this.originalArguments = new NodeInputList((Node)this, (Node[])originalArguments);
    }

    @Override
    public void lower(LoweringTool tool) {
        CallTargetNode.InvokeKind replacementInvokeKind = this.originalTargetMethod.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Special;
        MethodCallTargetNode replacement = this.graph().add(new MethodCallTargetNode(replacementInvokeKind, this.originalTargetMethod, this.originalArguments.toArray((A[])new ValueNode[this.originalArguments.size()]), this.originalReturnStamp, null));
        this.replaceAndDelete(replacement);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        throw GraalError.shouldNotReachHere("should have replaced itself");
    }
}

