/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerAddExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerAddExactSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactOverflowNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerAddExactOverflowNode
extends IntegerExactOverflowNode
implements Simplifiable,
Canonicalizable.BinaryCommutative<ValueNode>,
IterableNodeType {
    public static final NodeClass<IntegerAddExactOverflowNode> TYPE = NodeClass.create(IntegerAddExactOverflowNode.class);

    public IntegerAddExactOverflowNode(ValueNode x, ValueNode y) {
        super(TYPE, x, y);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        long c;
        if (forX.isConstant() && !forY.isConstant()) {
            return (ValueNode)new IntegerAddExactOverflowNode(forY, forX).canonical(tool);
        }
        if (forX.isConstant() && forY.isConstant()) {
            return IntegerAddExactOverflowNode.canonicalXYconstant(forX, forY);
        }
        if (forY.isConstant() && (c = forY.asJavaConstant().asLong()) == 0L) {
            return LogicConstantNode.forBoolean(false);
        }
        if (!IntegerStamp.addCanOverflow((IntegerStamp)forX.stamp(NodeView.DEFAULT), (IntegerStamp)forY.stamp(NodeView.DEFAULT))) {
            return LogicConstantNode.forBoolean(false);
        }
        return this;
    }

    private static LogicConstantNode canonicalXYconstant(ValueNode forX, ValueNode forY) {
        JavaConstant xConst = forX.asJavaConstant();
        JavaConstant yConst = forY.asJavaConstant();
        assert (xConst.getJavaKind() == yConst.getJavaKind());
        try {
            if (xConst.getJavaKind() == JavaKind.Int) {
                Math.addExact(xConst.asInt(), yConst.asInt());
            } else {
                assert (xConst.getJavaKind() == JavaKind.Long);
                Math.addExact(xConst.asLong(), yConst.asLong());
            }
        }
        catch (ArithmeticException ex) {
            return LogicConstantNode.forBoolean(true);
        }
        return LogicConstantNode.forBoolean(false);
    }

    @Override
    protected IntegerExactArithmeticSplitNode createSplit(Stamp splitStamp, AbstractBeginNode next, AbstractBeginNode overflow) {
        return new IntegerAddExactSplitNode(splitStamp, this.x, this.y, next, overflow);
    }

    @Override
    protected Class<? extends BinaryNode> getCoupledType() {
        return IntegerAddExactNode.class;
    }
}

