/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import java.util.List;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public abstract class IntegerExactOverflowNode
extends LogicNode
implements Canonicalizable.Binary<ValueNode>,
Simplifiable {
    public static final NodeClass<IntegerExactOverflowNode> TYPE = NodeClass.create(IntegerExactOverflowNode.class);
    @Node.Input
    protected ValueNode x;
    @Node.Input
    protected ValueNode y;

    public IntegerExactOverflowNode(NodeClass<? extends IntegerExactOverflowNode> c, ValueNode x, ValueNode y) {
        super((NodeClass<? extends LogicNode>)c);
        assert (x != null && y != null);
        this.x = x;
        this.y = y;
    }

    @Override
    public ValueNode getX() {
        return this.x;
    }

    @Override
    public ValueNode getY() {
        return this.y;
    }

    public LogicNode maybeCommuteInputs() {
        assert (this instanceof Canonicalizable.BinaryCommutative);
        if (!this.y.isConstant() && (this.x.isConstant() || this.x.getId() > this.y.getId())) {
            LogicNode duplicate;
            ValueNode tmp = this.x;
            this.x = this.y;
            this.y = tmp;
            if (this.graph() != null && (duplicate = (LogicNode)this.graph().findDuplicate(this)) != null) {
                return duplicate;
            }
        }
        return this;
    }

    protected abstract IntegerExactArithmeticSplitNode createSplit(Stamp var1, AbstractBeginNode var2, AbstractBeginNode var3);

    protected abstract Class<? extends BinaryNode> getCoupledType();

    @Override
    public void simplify(SimplifierTool tool) {
        for (IfNode ifNode : this.usages().filter(IfNode.class).snapshot()) {
            AbstractBeginNode next = ifNode.falseSuccessor();
            AbstractBeginNode overflow = ifNode.trueSuccessor();
            ifNode.clearSuccessors();
            List<BinaryNode> coupledNodes = next.usages().filter(this.getCoupledType()).filter(n -> {
                BinaryNode exact = (BinaryNode)n;
                return exact.getX() == this.getX() && exact.getY() == this.getY();
            }).snapshot();
            Stamp splitStamp = this.x.stamp(NodeView.DEFAULT).unrestricted();
            if (!coupledNodes.isEmpty()) {
                splitStamp = ((BinaryNode)coupledNodes.iterator().next()).stamp(NodeView.DEFAULT);
            }
            IntegerExactArithmeticSplitNode split = this.graph().add(this.createSplit(splitStamp, next, overflow));
            ifNode.replaceAndDelete(split);
            coupledNodes.forEach(n -> n.replaceAndDelete(split));
        }
    }
}

