/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.serviceprovider;

import jdk.vm.ci.services.Services;

public final class JavaVersionUtil {
    public static final int JAVA_SPEC = JavaVersionUtil.getJavaSpecificationVersion();

    private static int getJavaSpecificationVersion() {
        String value = (String)Services.getSavedProperties().get("java.specification.version");
        if (value.startsWith("1.")) {
            value = value.substring(2);
        }
        return Integer.parseInt(value);
    }

    public static boolean isOracleJDK8() {
        String vmName = (String)Services.getSavedProperties().get("java.vm.name");
        String version = (String)Services.getSavedProperties().get("java.specification.version");
        return !vmName.contains("OpenJDK") && version.startsWith("1.8");
    }

    private JavaVersionUtil() {
    }
}

