/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleInliningData;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;

public final class PEAgnosticInlineInvokePlugin
implements InlineInvokePlugin {
    private final EconomicMap<Invoke, TruffleCallNode> invokeToTruffleCallNode = EconomicMap.create();
    private final List<Invoke> indirectInvokes = new ArrayList<Invoke>();
    private final TruffleInliningData truffleInliningData;
    private final PartialEvaluator partialEvaluator;
    private JavaConstant lastDirectCallNode;
    private boolean indirectCall;

    public PEAgnosticInlineInvokePlugin(TruffleInliningData truffleInliningData, PartialEvaluator partialEvaluator) {
        this.truffleInliningData = truffleInliningData;
        this.partialEvaluator = partialEvaluator;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
        InlineInvokePlugin.InlineInfo inlineInfo = PartialEvaluator.asInlineInfo(original);
        if (original.equals(this.partialEvaluator.callDirectMethod)) {
            ValueNode arg0 = arguments[1];
            if (!arg0.isConstant()) {
                GraalError.shouldNotReachHere("The direct call node does not resolve to a constant!");
            }
            this.lastDirectCallNode = (JavaConstant)arg0.asConstant();
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        if (original.equals(this.partialEvaluator.callIndirectMethod)) {
            this.indirectCall = true;
        }
        return inlineInfo;
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod original, Invoke invoke) {
        if (original.equals(this.partialEvaluator.callDirectMethod)) {
            if (this.lastDirectCallNode == null) {
                if (this.indirectCall) {
                    this.indirectCall = false;
                    this.indirectInvokes.add(invoke);
                }
                return;
            }
            TruffleCallNode truffleCallNode = this.truffleInliningData.findCallNode(this.lastDirectCallNode);
            this.invokeToTruffleCallNode.put((Object)invoke, (Object)truffleCallNode);
            this.lastDirectCallNode = null;
        }
    }

    public EconomicMap<Invoke, TruffleCallNode> getInvokeToTruffleCallNode() {
        return this.invokeToTruffleCallNode;
    }

    public List<Invoke> getIndirectInvokes() {
        return this.indirectInvokes;
    }
}

