/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public class TruffleConstantFieldProvider
implements ConstantFieldProvider {
    private final ConstantFieldProvider graalConstantFieldProvider;
    private final MetaAccessProvider metaAccess;
    private final ConcurrentHashMap<ResolvedJavaField, TruffleCompilerRuntime.ConstantFieldInfo> cachedConstantFieldInfo;

    public TruffleConstantFieldProvider(ConstantFieldProvider graalConstantFieldProvider, MetaAccessProvider metaAccess) {
        this.graalConstantFieldProvider = graalConstantFieldProvider;
        this.metaAccess = metaAccess;
        this.cachedConstantFieldInfo = new ConcurrentHashMap();
    }

    @Override
    public <T> T readConstantField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        T ret;
        boolean isStaticField = field.isStatic();
        if (!isStaticField && tool.getReceiver().isNull()) {
            return null;
        }
        boolean isArrayField = field.getType().isArray();
        if (!isArrayField && (ret = this.readConstantFieldFast(field, tool)) != null) {
            return ret;
        }
        boolean hasObjectKind = field.getType().getJavaKind() == JavaKind.Object;
        TruffleCompilerRuntime.ConstantFieldInfo info = this.getConstantFieldInfo(field);
        if (info != null) {
            if (info.isChildren()) {
                int stableDimensions = isArrayField ? 1 : 0;
                return tool.foldStableArray(this.verifyFieldValue(field, tool.readValue(), info), stableDimensions, true);
            }
            if (!isStaticField && hasObjectKind && info.isChild()) {
                return tool.foldConstant(this.verifyFieldValue(field, tool.readValue(), info));
            }
            if (isArrayField) {
                int dimensions = info.getDimensions();
                assert (dimensions >= 0);
                return tool.foldStableArray(tool.readValue(), dimensions, true);
            }
            return tool.foldConstant(tool.readValue());
        }
        if (isArrayField) {
            return this.readConstantFieldFast(field, tool);
        }
        return null;
    }

    private TruffleCompilerRuntime.ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        return this.cachedConstantFieldInfo.computeIfAbsent(field, f -> TruffleCompilerRuntime.getRuntime().getConstantFieldInfo((ResolvedJavaField)f));
    }

    private <T> T readConstantFieldFast(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        T ret = this.graalConstantFieldProvider.readConstantField(field, tool);
        if (ret == null && field.isFinal()) {
            ret = tool.foldConstant(tool.readValue());
        }
        return ret;
    }

    private JavaConstant verifyFieldValue(ResolvedJavaField field, JavaConstant constant, TruffleCompilerRuntime.ConstantFieldInfo info) {
        assert (!info.isChild() || constant.isNull() || TruffleCompilerRuntime.getRuntime().resolveType(this.metaAccess, "com.oracle.truffle.api.nodes.Node").isAssignableFrom(this.metaAccess.lookupJavaType(constant))) : String.format("@Child field value must be a Node: %s, but was: %s", field, constant);
        assert (!info.isChildren() || constant.isNull() || this.metaAccess.lookupJavaType(constant).isArray()) : String.format("@Children field value must be an array: %s, but was: %s", field, constant);
        return constant;
    }
}

