/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.amd64.substitutions;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.JDK9StringSubstitutions;
import org.graalvm.compiler.replacements.StringSubstitutions;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOfWithMaskNode;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayRegionEqualsWithMaskNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.truffle.compiler.substitutions.ArrayUtilsSubstitutions;

@ClassSubstitution(className={"com.oracle.truffle.api.ArrayUtils"}, optional=true)
public class AMD64ArrayUtilsSubstitutions
extends ArrayUtilsSubstitutions {
    @MethodSubstitution
    public static int runIndexOfWithOrMask(byte[] haystack, int fromIndex, int maxIndex, byte needle, byte mask) {
        if (mask == 0) {
            return ArrayIndexOf.indexOf1Byte(haystack, maxIndex, fromIndex, needle);
        }
        return AMD64ArrayIndexOfWithMaskNode.indexOfWithMask(haystack, maxIndex, fromIndex, needle, mask);
    }

    @MethodSubstitution
    public static int runIndexOfWithOrMask(char[] haystack, int fromIndex, int maxIndex, char needle, char mask) {
        if (mask == '\u0000') {
            return ArrayIndexOf.indexOf1Char(haystack, maxIndex, fromIndex, needle);
        }
        return AMD64ArrayIndexOfWithMaskNode.indexOfWithMask(haystack, maxIndex, fromIndex, needle, mask);
    }

    @MethodSubstitution
    public static int runIndexOfWithOrMask(String haystack, int fromIndex, int maxIndex, char needle, char mask) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            byte[] value = JDK9StringSubstitutions.getValue(haystack);
            if (mask == '\u0000') {
                if (JDK9StringSubstitutions.isCompactString(haystack)) {
                    return needle <= '\u00ff' ? ArrayIndexOf.indexOf1Byte(value, maxIndex, fromIndex, (byte)needle) : -1;
                }
                return ArrayIndexOf.indexOf1CharCompact(value, maxIndex, fromIndex, needle);
            }
            if (JDK9StringSubstitutions.isCompactString(haystack)) {
                return (needle ^ mask) <= 255 ? AMD64ArrayIndexOfWithMaskNode.indexOfWithMask(value, maxIndex, fromIndex, (byte)needle, (byte)mask) : -1;
            }
            return AMD64ArrayIndexOfWithMaskNode.indexOfWithMask(value, maxIndex, fromIndex, needle, mask);
        }
        if (mask == '\u0000') {
            return ArrayIndexOf.indexOf1Char(StringSubstitutions.getValue(haystack), maxIndex, fromIndex, needle);
        }
        return AMD64ArrayIndexOfWithMaskNode.indexOfWithMask(StringSubstitutions.getValue(haystack), maxIndex, fromIndex, needle, mask);
    }

    @MethodSubstitution
    public static int runIndexOf2ConsecutiveWithOrMask(byte[] haystack, int fromIndex, int maxIndex, byte c1, byte c2, byte mask1, byte mask2) {
        int mask = Byte.toUnsignedInt(mask2) << 8 | Byte.toUnsignedInt(mask1);
        if (mask == 0) {
            return ArrayIndexOf.indexOfTwoConsecutiveBytes(haystack, maxIndex, fromIndex, c1, c2);
        }
        return AMD64ArrayIndexOfWithMaskNode.indexOf2ConsecutiveBytesWithMask(haystack, maxIndex, fromIndex, Byte.toUnsignedInt(c2) << 8 | Byte.toUnsignedInt(c1), mask);
    }

    @MethodSubstitution
    public static int runIndexOf2ConsecutiveWithOrMask(char[] haystack, int fromIndex, int maxIndex, char c1, char c2, char mask1, char mask2) {
        int mask = mask2 << 16 | mask1;
        if (mask == 0) {
            return ArrayIndexOf.indexOfTwoConsecutiveChars(haystack, maxIndex, fromIndex, c1, c2);
        }
        return AMD64ArrayIndexOfWithMaskNode.indexOf2ConsecutiveCharsWithMask(haystack, maxIndex, fromIndex, c2 << 16 | c1, mask);
    }

    @MethodSubstitution
    public static int runIndexOf2ConsecutiveWithOrMask(String haystack, int fromIndex, int maxIndex, char c1, char c2, char mask1, char mask2) {
        int mask = mask2 << 16 | mask1;
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            byte[] value = JDK9StringSubstitutions.getValue(haystack);
            if (mask == 0) {
                if (JDK9StringSubstitutions.isCompactString(haystack)) {
                    return c1 <= '\u00ff' && c2 <= '\u00ff' ? ArrayIndexOf.indexOfTwoConsecutiveBytes(value, maxIndex, fromIndex, (byte)c1, (byte)c2) : -1;
                }
                return ArrayIndexOf.indexOfTwoConsecutiveChars(value, maxIndex, fromIndex, c1, c2);
            }
            if (JDK9StringSubstitutions.isCompactString(haystack)) {
                if ((c1 ^ mask1) <= 255 && (c2 ^ mask2) <= 255) {
                    return AMD64ArrayIndexOfWithMaskNode.indexOf2ConsecutiveBytesWithMask(value, maxIndex, fromIndex, (c2 & 0xFF) << 8 | c1 & 0xFF, (mask2 & 0xFF) << 8 | mask1 & 0xFF);
                }
                return -1;
            }
            return AMD64ArrayIndexOfWithMaskNode.indexOf2ConsecutiveCharsWithMask(value, maxIndex, fromIndex, c2 << 16 | c1, mask);
        }
        if (mask == 0) {
            return ArrayIndexOf.indexOfTwoConsecutiveChars(StringSubstitutions.getValue(haystack), maxIndex, fromIndex, c1, c2);
        }
        return AMD64ArrayIndexOfWithMaskNode.indexOf2ConsecutiveCharsWithMask(StringSubstitutions.getValue(haystack), maxIndex, fromIndex, c2 << 16 | c1, mask);
    }

    @MethodSubstitution
    public static boolean runRegionEqualsWithOrMask(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, byte[] mask) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(a1, fromIndex1, a2, fromIndex2, mask);
    }

    @MethodSubstitution
    public static boolean runRegionEqualsWithOrMask(char[] a1, int fromIndex1, char[] a2, int fromIndex2, char[] mask) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(a1, fromIndex1, a2, fromIndex2, mask);
    }

    @MethodSubstitution
    public static boolean runRegionEqualsWithOrMask(String a1, int fromIndex1, String a2, int fromIndex2, String mask) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            byte[] valueA1 = JDK9StringSubstitutions.getValue(a1);
            byte[] valueA2 = JDK9StringSubstitutions.getValue(a2);
            byte[] valueMask = JDK9StringSubstitutions.getValue(mask);
            boolean compact1 = JDK9StringSubstitutions.isCompactString(a1);
            boolean compact2 = JDK9StringSubstitutions.isCompactString(a2);
            boolean compactMask = JDK9StringSubstitutions.isCompactString(mask);
            if (compact2) {
                if (compactMask) {
                    if (compact1) {
                        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(valueA1, fromIndex1, valueA2, fromIndex2, valueMask, mask.length(), JavaKind.Byte, JavaKind.Byte, JavaKind.Byte);
                    }
                    return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(valueA1, fromIndex1, valueA2, fromIndex2, valueMask, mask.length(), JavaKind.Char, JavaKind.Byte, JavaKind.Byte);
                }
                return false;
            }
            if (compactMask) {
                if (compact1) {
                    return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(valueA1, fromIndex1, valueA2, fromIndex2, valueMask, mask.length(), JavaKind.Byte, JavaKind.Char, JavaKind.Byte);
                }
                return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(valueA1, fromIndex1, valueA2, fromIndex2, valueMask, mask.length(), JavaKind.Char, JavaKind.Char, JavaKind.Byte);
            }
            if (compact1) {
                return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(valueA1, fromIndex1, valueA2, fromIndex2, valueMask, mask.length(), JavaKind.Byte, JavaKind.Char, JavaKind.Char);
            }
            return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(valueA1, fromIndex1, valueA2, fromIndex2, valueMask, mask.length(), JavaKind.Char, JavaKind.Char, JavaKind.Char);
        }
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StringSubstitutions.getValue(a1), fromIndex1, StringSubstitutions.getValue(a2), fromIndex2, StringSubstitutions.getValue(mask));
    }
}

