/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class NewFrameNode
extends FixedWithNextNode
implements IterableNodeType,
VirtualizableAllocation,
Canonicalizable {
    public static final NodeClass<NewFrameNode> TYPE = NodeClass.create(NewFrameNode.class);
    @Node.Input
    ValueNode descriptor;
    @Node.Input
    ValueNode arguments;
    @Node.Input
    VirtualObjectNode virtualFrame;
    @Node.Input
    VirtualObjectNode virtualFrameObjectArray;
    @Node.OptionalInput
    VirtualObjectNode virtualFramePrimitiveArray;
    @Node.OptionalInput
    VirtualObjectNode virtualFrameTagArray;
    @Node.Input
    NodeInputList<ValueNode> smallIntConstants;
    @Node.Input
    private ValueNode frameDefaultValue;
    private final boolean intrinsifyAccessors;
    private final JavaKind[] frameSlotKinds;
    private final int frameSize;
    private final SpeculationLog.SpeculationReason intrinsifyAccessorsSpeculation;
    private static final SpeculationReasonGroup INTRINSIFY_FRAME_ACCESSORS_SPECULATIONS = new SpeculationReasonGroup("IntrinsifyFrameAccessor", new Class[0]);

    private static JavaKind asJavaKind(JavaConstant frameSlotTag) {
        int tagValue = frameSlotTag.asInt();
        JavaKind rawKind = TruffleCompilerRuntime.getRuntime().getJavaKindForFrameSlotKind(tagValue);
        switch (rawKind) {
            case Boolean: 
            case Byte: 
            case Int: {
                return JavaKind.Int;
            }
            case Double: 
            case Float: {
                return rawKind;
            }
            case Long: 
            case Object: 
            case Illegal: {
                return JavaKind.Long;
            }
        }
        throw new IllegalStateException("Unexpected frame slot kind tag: " + tagValue);
    }

    public NewFrameNode(GraphBuilderContext b, ValueNode frameDescriptorNode, ValueNode arguments, KnownTruffleTypes types) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(types.classFrameClass)));
        this.descriptor = frameDescriptorNode;
        this.arguments = arguments;
        StructuredGraph graph = b.getGraph();
        MetaAccessProvider metaAccess = b.getMetaAccess();
        ConstantReflectionProvider constantReflection = b.getConstantReflection();
        JavaConstant frameDescriptor = frameDescriptorNode.asJavaConstant();
        JavaConstant version = constantReflection.readFieldValue(types.fieldFrameDescriptorVersion, frameDescriptor);
        graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(version));
        this.intrinsifyAccessorsSpeculation = INTRINSIFY_FRAME_ACCESSORS_SPECULATIONS.createSpeculationReason(new Object[0]);
        boolean intrinsify = false;
        if (!constantReflection.readFieldValue(types.fieldFrameDescriptorMaterializeCalled, frameDescriptor).asBoolean()) {
            SpeculationLog speculationLog = graph.getSpeculationLog();
            intrinsify = speculationLog != null && speculationLog.maySpeculate(this.intrinsifyAccessorsSpeculation);
        }
        this.intrinsifyAccessors = intrinsify;
        JavaConstant defaultValue = constantReflection.readFieldValue(types.fieldFrameDescriptorDefaultValue, frameDescriptor);
        this.frameDefaultValue = ConstantNode.forConstant(defaultValue, metaAccess, graph);
        JavaConstant slotArrayList = constantReflection.readFieldValue(types.fieldFrameDescriptorSlots, frameDescriptor);
        JavaConstant slotArray = constantReflection.readFieldValue(types.fieldArrayListElementData, slotArrayList);
        int slotsArrayLength = constantReflection.readArrayLength(slotArray);
        int frameLength = constantReflection.readFieldValue(types.fieldFrameDescriptorSize, frameDescriptor).asInt();
        JavaKind[] frameSlotKindsCandidate = new JavaKind[frameLength];
        int limit = -1;
        for (int i = 0; i < slotsArrayLength; ++i) {
            JavaConstant slot = constantReflection.readArrayElement(slotArray, i);
            if (!slot.isNonNull()) continue;
            JavaConstant slotKind = constantReflection.readFieldValue(types.fieldFrameSlotKind, slot);
            JavaConstant slotIndex = constantReflection.readFieldValue(types.fieldFrameSlotIndex, slot);
            if (!slotKind.isNonNull() || !slotIndex.isNonNull()) continue;
            JavaKind kind = NewFrameNode.asJavaKind(constantReflection.readFieldValue(types.fieldFrameSlotKindTag, slotKind));
            int index = slotIndex.asInt();
            limit = Math.max(index, limit);
            if (index >= frameLength) {
                JavaKind[] newArray = new JavaKind[index + 1];
                System.arraycopy(frameSlotKindsCandidate, 0, newArray, 0, frameSlotKindsCandidate.length);
                frameSlotKindsCandidate = newArray;
            }
            frameSlotKindsCandidate[index] = kind;
        }
        this.frameSlotKinds = frameSlotKindsCandidate;
        this.frameSize = limit + 1;
        ResolvedJavaType frameType = types.classFrameClass;
        ResolvedJavaField[] frameFields = frameType.getInstanceFields(true);
        ResolvedJavaField localsField = NewFrameNode.findField(frameFields, "locals");
        ResolvedJavaField primitiveLocalsField = NewFrameNode.findField(frameFields, "primitiveLocals");
        ResolvedJavaField tagsField = NewFrameNode.findField(frameFields, "tags");
        this.virtualFrame = graph.add(new VirtualInstanceNode(frameType, frameFields, true));
        this.virtualFrameObjectArray = graph.add(new VirtualArrayNode((ResolvedJavaType)localsField.getType().getComponentType(), this.frameSize));
        if (primitiveLocalsField != null) {
            this.virtualFramePrimitiveArray = graph.add(new VirtualArrayNode((ResolvedJavaType)primitiveLocalsField.getType().getComponentType(), this.frameSize));
            this.virtualFrameTagArray = graph.add(new VirtualArrayNode((ResolvedJavaType)tagsField.getType().getComponentType(), this.frameSize));
        }
        Node[] c = new ValueNode[TruffleCompilerRuntime.getRuntime().getFrameSlotKindTagsCount()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = ConstantNode.forInt(i, graph);
        }
        this.smallIntConstants = new NodeInputList((Node)this, c);
    }

    public ValueNode getDescriptor() {
        return this.descriptor;
    }

    public ValueNode getArguments() {
        return this.arguments;
    }

    public boolean getIntrinsifyAccessors() {
        return this.intrinsifyAccessors;
    }

    public SpeculationLog.SpeculationReason getIntrinsifyAccessorsSpeculation() {
        return this.intrinsifyAccessorsSpeculation;
    }

    public boolean isValidSlotIndex(int index) {
        return index >= 0 && index < this.frameSize && this.frameSlotKinds[index] != null;
    }

    private static ResolvedJavaField findField(ResolvedJavaField[] fields, String fieldName) {
        for (ResolvedJavaField field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ResolvedJavaType frameType = this.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess());
        ResolvedJavaField[] frameFields = frameType.getInstanceFields(true);
        ResolvedJavaField descriptorField = NewFrameNode.findField(frameFields, "descriptor");
        ResolvedJavaField argumentsField = NewFrameNode.findField(frameFields, "arguments");
        ResolvedJavaField localsField = NewFrameNode.findField(frameFields, "locals");
        ResolvedJavaField primitiveLocalsField = NewFrameNode.findField(frameFields, "primitiveLocals");
        ResolvedJavaField tagsField = NewFrameNode.findField(frameFields, "tags");
        Object[] objectArrayEntryState = new ValueNode[this.frameSize];
        ValueNode[] primitiveArrayEntryState = new ValueNode[this.frameSize];
        Object[] tagArrayEntryState = new ValueNode[this.frameSize];
        if (this.frameSize > 0) {
            Arrays.fill(objectArrayEntryState, this.frameDefaultValue);
            if (this.virtualFrameTagArray != null) {
                Arrays.fill(tagArrayEntryState, this.smallIntConstants.get(0));
            }
            if (this.virtualFramePrimitiveArray != null) {
                for (int i = 0; i < this.frameSize; ++i) {
                    JavaKind kind = this.frameSlotKinds[i];
                    if (kind == null) {
                        kind = JavaKind.Int;
                    }
                    primitiveArrayEntryState[i] = ConstantNode.defaultForKind(kind, this.graph());
                }
            }
        }
        NodeSourcePosition sourcePosition = this.getNodeSourcePosition();
        tool.createVirtualObject(this.virtualFrameObjectArray, (ValueNode[])objectArrayEntryState, Collections.emptyList(), sourcePosition, false);
        if (this.virtualFramePrimitiveArray != null) {
            tool.createVirtualObject(this.virtualFramePrimitiveArray, primitiveArrayEntryState, Collections.emptyList(), sourcePosition, false);
        }
        if (this.virtualFrameTagArray != null) {
            tool.createVirtualObject(this.virtualFrameTagArray, (ValueNode[])tagArrayEntryState, Collections.emptyList(), sourcePosition, false);
        }
        assert (frameFields.length == 5 || frameFields.length == 3);
        ValueNode[] frameEntryState = new ValueNode[frameFields.length];
        List<ResolvedJavaField> frameFieldList = Arrays.asList(frameFields);
        frameEntryState[frameFieldList.indexOf((Object)descriptorField)] = this.getDescriptor();
        frameEntryState[frameFieldList.indexOf((Object)argumentsField)] = this.getArguments();
        frameEntryState[frameFieldList.indexOf((Object)localsField)] = this.virtualFrameObjectArray;
        if (primitiveLocalsField != null) {
            frameEntryState[frameFieldList.indexOf((Object)primitiveLocalsField)] = this.virtualFramePrimitiveArray;
        }
        if (tagsField != null) {
            frameEntryState[frameFieldList.indexOf((Object)tagsField)] = this.virtualFrameTagArray;
        }
        tool.createVirtualObject(this.virtualFrame, frameEntryState, Collections.emptyList(), sourcePosition, true);
        tool.replaceWithVirtual(this.virtualFrame);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        return this;
    }
}

