/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public class VirtualFrameClearNode
extends VirtualFrameAccessorNode
implements Virtualizable,
IterableNodeType {
    public static final NodeClass<VirtualFrameClearNode> TYPE = NodeClass.create(VirtualFrameClearNode.class);

    public VirtualFrameClearNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int illegalTag) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, illegalTag);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        boolean success;
        VirtualObjectNode tagVirtual;
        ValueNode tagAlias = tool.getAlias(this.frame.virtualFrameTagArray);
        if (tagAlias instanceof VirtualObjectNode && this.frameSlotIndex < (tagVirtual = (VirtualObjectNode)tagAlias).entryCount() && (success = tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstant(this.accessTag), tagVirtual.entryKind(tool.getMetaAccessExtensionProvider(), this.frameSlotIndex), -1L))) {
            tool.delete();
            return;
        }
        this.insertDeoptimization(tool);
    }
}

