/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.truffle.runtime.BytecodeOSRRootNode;
import org.graalvm.compiler.truffle.runtime.FrameWithoutBoxing;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

public final class BytecodeOSRMetadata {
    public static final BytecodeOSRMetadata DISABLED = new BytecodeOSRMetadata(null, Integer.MAX_VALUE);
    public static final int OSR_POLL_INTERVAL = 1024;
    private final BytecodeOSRNode osrNode;
    @CompilerDirectives.CompilationFinal
    private volatile LazyState lazyState;
    private final int osrThreshold;
    private int backEdgeCount;

    private LazyState getLazyState() {
        LazyState currentLazyState = this.lazyState;
        if (currentLazyState == null) {
            return this.getLazyStateBoundary();
        }
        return currentLazyState;
    }

    @CompilerDirectives.TruffleBoundary
    private LazyState getLazyStateBoundary() {
        return (LazyState)((Node)this.osrNode).atomic(() -> {
            LazyState lockedLazyState = this.lazyState;
            if (lockedLazyState == null) {
                lockedLazyState = this.lazyState = new LazyState(new ConcurrentHashMap<Integer, OptimizedCallTarget>());
            }
            return lockedLazyState;
        });
    }

    private void updateFrameSlots(FrameWithoutBoxing frame) {
        CompilerAsserts.neverPartOfCompilation();
        LazyState state = this.getLazyState();
        ((Node)this.osrNode).atomic(() -> {
            if (!Assumption.isValidAssumption((Assumption)state.frameVersion)) {
                FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
                state.frameDescriptor = frameDescriptor;
                state.frameVersion = frameDescriptor.getVersion();
                LazyState.access$302(state, frameDescriptor.getSlots().toArray(new FrameSlot[0]));
            }
            byte[] tags = frame.getTags();
            LazyState.access$402(state, Arrays.copyOf(tags, state.frameSlots.length));
        });
    }

    BytecodeOSRMetadata(BytecodeOSRNode osrNode, int osrThreshold) {
        this.osrNode = osrNode;
        this.osrThreshold = osrThreshold;
        this.backEdgeCount = 0;
    }

    Object tryOSR(int target, Object interpreterState, Runnable beforeTransfer, VirtualFrame parentFrame) {
        LazyState state = this.getLazyState();
        assert (state.frameDescriptor == null || state.frameDescriptor == parentFrame.getFrameDescriptor());
        OptimizedCallTarget osrTarget = (OptimizedCallTarget)state.compilationMap.get(target);
        if (osrTarget == null) {
            osrTarget = (OptimizedCallTarget)((Node)this.osrNode).atomic(() -> {
                OptimizedCallTarget lockedTarget = (OptimizedCallTarget)state.compilationMap.get(target);
                if (lockedTarget == null) {
                    lockedTarget = this.createOSRTarget(target, interpreterState, parentFrame.getFrameDescriptor());
                    this.requestOSRCompilation(target, lockedTarget, (FrameWithoutBoxing)parentFrame);
                    state.compilationMap.put(target, lockedTarget);
                }
                return lockedTarget;
            });
        }
        if (osrTarget.isCompiling()) {
            return null;
        }
        if (osrTarget.isValid()) {
            if (beforeTransfer != null) {
                beforeTransfer.run();
            }
            return osrTarget.callOSR(parentFrame);
        }
        if (osrTarget.isCompilationFailed()) {
            this.markCompilationFailed();
        } else {
            this.requestOSRCompilation(target, osrTarget, (FrameWithoutBoxing)parentFrame);
        }
        return null;
    }

    public boolean incrementAndPoll() {
        int newBackEdgeCount;
        return (newBackEdgeCount = ++this.backEdgeCount) >= this.osrThreshold && (newBackEdgeCount & 0x3FF) == 0;
    }

    private OptimizedCallTarget createOSRTarget(int target, Object interpreterState, FrameDescriptor frameDescriptor) {
        TruffleLanguage language = GraalRuntimeAccessor.NODES.getLanguage(((Node)this.osrNode).getRootNode());
        return GraalTruffleRuntime.getRuntime().createOSRCallTarget(new BytecodeOSRRootNode(language, frameDescriptor, this.osrNode, target, interpreterState));
    }

    private void requestOSRCompilation(int target, OptimizedCallTarget osrTarget, FrameWithoutBoxing frame) {
        this.osrNode.prepareOSR(target);
        this.updateFrameSlots(frame);
        osrTarget.compile(true);
        if (osrTarget.isCompilationFailed()) {
            this.markCompilationFailed();
        }
    }

    @ExplodeLoop
    public void transferFrame(FrameWithoutBoxing source, FrameWithoutBoxing target) {
        byte[] sourceTags;
        LazyState state = this.getLazyState();
        CompilerAsserts.partialEvaluationConstant((Object)state);
        if (source.getFrameDescriptor() != state.frameDescriptor) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Source frame descriptor is different from the descriptor used for compilation.");
        }
        if (target.getFrameDescriptor() != state.frameDescriptor) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Target frame descriptor is different from the descriptor used for compilation.");
        }
        if (!state.frameVersion.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.updateFrameSlots(source);
        }
        if ((sourceTags = source.getTags()).length != state.frameSlots.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            source.resize();
            sourceTags = source.getTags();
        }
        block9: for (int i = 0; i < state.frameSlots.length; ++i) {
            byte actualTag;
            boolean tagsCondition;
            FrameSlot slot = state.frameSlots[i];
            byte expectedTag = state.frameTags[i];
            boolean bl = tagsCondition = expectedTag == (actualTag = sourceTags[i]);
            if (!tagsCondition) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                ((LazyState)state).frameTags[i] = actualTag;
                expectedTag = actualTag;
            }
            switch (expectedTag) {
                case 5: {
                    target.setBoolean(slot, source.getBooleanUnsafe(i, slot, tagsCondition));
                    continue block9;
                }
                case 6: {
                    target.setByte(slot, source.getByteUnsafe(i, slot, tagsCondition));
                    continue block9;
                }
                case 3: {
                    target.setDouble(slot, source.getDoubleUnsafe(i, slot, tagsCondition));
                    continue block9;
                }
                case 4: {
                    target.setFloat(slot, source.getFloatUnsafe(i, slot, tagsCondition));
                    continue block9;
                }
                case 2: {
                    target.setInt(slot, source.getIntUnsafe(i, slot, tagsCondition));
                    continue block9;
                }
                case 1: {
                    target.setLong(slot, source.getLongUnsafe(i, slot, tagsCondition));
                    continue block9;
                }
                case 0: {
                    target.setObject(slot, source.getObjectUnsafe(i, slot, tagsCondition));
                    continue block9;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("Defined frame slot " + slot + " is illegal. Please initialize frame slot with a FrameSlotKind.");
                }
            }
        }
    }

    void nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        LazyState state = this.lazyState;
        if (state != null) {
            ((Node)this.osrNode).atomic(() -> {
                for (OptimizedCallTarget callTarget : state.compilationMap.values()) {
                    if (callTarget == null) continue;
                    if (callTarget.isCompilationFailed()) {
                        this.markCompilationFailed();
                    }
                    callTarget.nodeReplaced(oldNode, newNode, reason);
                }
            });
        }
    }

    private void markCompilationFailed() {
        ((Node)this.osrNode).atomic(() -> {
            this.osrNode.setOSRMetadata((Object)DISABLED);
            LazyState state = this.lazyState;
            if (state != null) {
                state.compilationMap.clear();
            }
        });
    }

    public Map<Integer, OptimizedCallTarget> getOSRCompilations() {
        return this.getLazyState().compilationMap;
    }

    public int getBackEdgeCount() {
        return this.backEdgeCount;
    }

    static final class LazyState {
        private final Map<Integer, OptimizedCallTarget> compilationMap;
        @CompilerDirectives.CompilationFinal
        private FrameDescriptor frameDescriptor;
        @CompilerDirectives.CompilationFinal
        private Assumption frameVersion;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private FrameSlot[] frameSlots;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private byte[] frameTags;

        LazyState(Map<Integer, OptimizedCallTarget> compilationMap) {
            this.compilationMap = compilationMap;
            this.frameDescriptor = null;
            this.frameVersion = null;
            this.frameSlots = null;
            this.frameTags = null;
        }

        static /* synthetic */ FrameSlot[] access$302(LazyState x0, FrameSlot[] x1) {
            x0.frameSlots = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$402(LazyState x0, byte[] x1) {
            x0.frameTags = x1;
            return x1;
        }
    }
}

