/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.AbstractOptimizedLoopNode;
import org.graalvm.compiler.truffle.runtime.BaseOSRRootNode;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.FrameWithoutBoxing;
import org.graalvm.compiler.truffle.runtime.GraalCompilerDirectives;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedLoopNode;
import org.graalvm.options.OptionValues;

public abstract class OptimizedOSRLoopNode
extends AbstractOptimizedLoopNode
implements ReplaceObserver {
    private volatile OptimizedCallTarget compiledOSRLoop;
    private volatile SpeculationLog speculationLog;
    private int baseLoopCount;
    private final int osrThreshold;
    private final boolean firstTierBackedgeCounts;
    private volatile boolean compilationDisabled;

    private OptimizedOSRLoopNode(RepeatingNode repeatingNode, int osrThreshold, boolean firstTierBackedgeCounts) {
        super(repeatingNode);
        this.osrThreshold = osrThreshold;
        this.firstTierBackedgeCounts = firstTierBackedgeCounts;
    }

    protected AbstractLoopOSRRootNode createRootNode(FrameDescriptor rootFrameDescriptor, Class<? extends VirtualFrame> clazz) {
        return new LoopOSRRootNode(this, new FrameDescriptor(), clazz);
    }

    public final Node copy() {
        OptimizedOSRLoopNode copy = (OptimizedOSRLoopNode)super.copy();
        copy.compiledOSRLoop = null;
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        Object status;
        RepeatingNode loopBody = this.repeatingNode;
        if (CompilerDirectives.inInterpreter()) {
            try {
                Object status2 = loopBody.initialLoopStatus();
                while (loopBody.shouldContinue(status2)) {
                    if (this.compiledOSRLoop == null) {
                        status2 = this.profilingLoop(frame);
                        continue;
                    }
                    status2 = this.compilingLoop(frame);
                }
                Object object = status2;
                return object;
            }
            finally {
                this.baseLoopCount = 0;
            }
        }
        if (GraalCompilerDirectives.hasNextTier()) {
            Object status3;
            long iterationsCompleted = 0L;
            try {
                while (this.inject(loopBody.shouldContinue(status3 = loopBody.executeRepeatingWithValue(frame)))) {
                    ++iterationsCompleted;
                    if (CompilerDirectives.inInterpreter()) {
                        Object object = this.execute(frame);
                        return object;
                    }
                    TruffleSafepoint.poll((Node)this);
                }
            }
            finally {
                if (this.firstTierBackedgeCounts && iterationsCompleted > 1L) {
                    LoopNode.reportLoopCount((Node)this, (int)OptimizedOSRLoopNode.toIntOrMaxInt(iterationsCompleted));
                }
            }
            return status3;
        }
        while (this.inject(loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue(frame)))) {
            if (CompilerDirectives.inInterpreter()) {
                return this.execute(frame);
            }
            TruffleSafepoint.poll((Node)this);
        }
        return status;
    }

    static int toIntOrMaxInt(long i) {
        return i > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object profilingLoop(VirtualFrame frame) {
        RepeatingNode loopBody = this.repeatingNode;
        long iterations = 0L;
        try {
            Object status;
            while (loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue(frame))) {
                if (++iterations + (long)this.baseLoopCount > (long)this.osrThreshold && !this.compilationDisabled) {
                    this.compileLoop(frame);
                    Object object = status;
                    return object;
                }
                TruffleSafepoint.poll((Node)this);
            }
            Object object = status;
            return object;
        }
        finally {
            this.reportLoopIterations(iterations);
        }
    }

    private void reportLoopIterations(long iterations) {
        this.baseLoopCount = OptimizedOSRLoopNode.toIntOrMaxInt((long)this.baseLoopCount + iterations);
        this.profileCounted(iterations);
        LoopNode.reportLoopCount((Node)this, (int)OptimizedOSRLoopNode.toIntOrMaxInt(iterations));
    }

    final void reportChildLoopCount(int iterations) {
        int newBaseLoopCount = this.baseLoopCount + iterations;
        if (newBaseLoopCount < 0) {
            newBaseLoopCount = Integer.MAX_VALUE;
        }
        this.baseLoopCount = newBaseLoopCount;
    }

    public final void forceOSR() {
        this.baseLoopCount = this.osrThreshold;
        RootNode rootNode = this.getRootNode();
        VirtualFrame dummyFrame = Truffle.getRuntime().createVirtualFrame(new Object[]{}, rootNode != null ? rootNode.getFrameDescriptor() : new FrameDescriptor());
        this.compileLoop(dummyFrame);
    }

    public final OptimizedCallTarget getCompiledOSRLoop() {
        return this.compiledOSRLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compilingLoop(VirtualFrame frame) {
        RepeatingNode loopBody = this.repeatingNode;
        long iterations = 0L;
        try {
            Object status;
            do {
                OptimizedCallTarget target;
                if ((target = this.compiledOSRLoop) == null) {
                    Object object = loopBody.initialLoopStatus();
                    return object;
                }
                if (!target.isSubmittedForCompilation()) {
                    if (target.isValid()) {
                        Object object = this.callOSR(target, frame);
                        return object;
                    }
                    this.invalidateOSRTarget("OSR compilation failed or cancelled");
                    Object object = loopBody.initialLoopStatus();
                    return object;
                }
                ++iterations;
                TruffleSafepoint.poll((Node)this);
            } while (loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue(frame)));
            Object object = status;
            return object;
        }
        finally {
            this.reportLoopIterations(iterations);
        }
    }

    private Object callOSR(OptimizedCallTarget target, VirtualFrame frame) {
        Object status = target.callOSR(frame);
        if (!this.repeatingNode.initialLoopStatus().equals(status)) {
            return status;
        }
        if (!target.isValid()) {
            this.invalidateOSRTarget("OSR compilation got invalidated");
        }
        return status;
    }

    private void compileLoop(final VirtualFrame frame) {
        this.atomic(new Runnable(){

            @Override
            public void run() {
                if (OptimizedOSRLoopNode.this.compilationDisabled) {
                    return;
                }
                if (OptimizedOSRLoopNode.this.compiledOSRLoop == null) {
                    OptimizedOSRLoopNode.this.compiledOSRLoop = OptimizedOSRLoopNode.this.compileImpl(frame);
                }
            }
        });
    }

    private AbstractLoopOSRRootNode createRootNodeImpl(RootNode root, Class<? extends VirtualFrame> frameClass) {
        return this.createRootNode(root == null ? null : root.getFrameDescriptor(), frameClass);
    }

    private OptimizedCallTarget compileImpl(VirtualFrame frame) {
        OptimizedCallTarget osrTarget;
        RootNode root = this.getRootNode();
        if (this.speculationLog == null) {
            this.speculationLog = GraalTruffleRuntime.getRuntime().createSpeculationLog();
        }
        if (!(osrTarget = GraalTruffleRuntime.getRuntime().createOSRCallTarget(this.createRootNodeImpl(root, frame.getClass()))).acceptForCompilation()) {
            this.compilationDisabled = true;
            return null;
        }
        osrTarget.setSpeculationLog(this.speculationLog);
        osrTarget.compile(true);
        return osrTarget;
    }

    public final boolean nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        this.callNodeReplacedOnOSRTarget(oldNode, newNode, reason);
        return false;
    }

    private void callNodeReplacedOnOSRTarget(final Node oldNode, final Node newNode, final CharSequence reason) {
        this.atomic(new Runnable(){

            @Override
            public void run() {
                OptimizedCallTarget target = OptimizedOSRLoopNode.this.compiledOSRLoop;
                if (target != null) {
                    OptimizedOSRLoopNode.this.resetCompiledOSRLoop();
                    target.nodeReplaced(oldNode, newNode, reason);
                }
            }
        });
    }

    private void resetCompiledOSRLoop() {
        OptimizedCallTarget target = this.compiledOSRLoop;
        if (target != null && target.isCompilationFailed()) {
            this.compilationDisabled = true;
        }
        this.compiledOSRLoop = null;
    }

    private void invalidateOSRTarget(final CharSequence reason) {
        this.atomic(new Runnable(){

            @Override
            public void run() {
                OptimizedCallTarget target = OptimizedOSRLoopNode.this.compiledOSRLoop;
                if (target != null) {
                    OptimizedOSRLoopNode.this.resetCompiledOSRLoop();
                    target.invalidate(reason);
                }
            }
        });
    }

    public static LoopNode create(RepeatingNode repeat) {
        EngineData engine = GraalTVMCI.getEngineData(null);
        OptionValues engineOptions = engine.engineOptions;
        if (engine.compilation && ((Boolean)engineOptions.get(PolyglotCompilerOptions.OSR)).booleanValue()) {
            return OptimizedOSRLoopNode.createDefault(repeat, engineOptions);
        }
        return OptimizedLoopNode.create(repeat);
    }

    private static LoopNode createDefault(RepeatingNode repeatableNode, OptionValues options) {
        return new OptimizedDefaultOSRLoopNode(repeatableNode, (Integer)options.get(PolyglotCompilerOptions.OSRCompilationThreshold), (Boolean)options.get(PolyglotCompilerOptions.FirstTierBackedgeCounts));
    }

    public static OptimizedOSRLoopNode createOSRLoop(RepeatingNode repeating, int osrThreshold, FrameSlot[] readFrameSlots, FrameSlot[] writtenFrameSlots) {
        if (readFrameSlots == null != (writtenFrameSlots == null)) {
            throw new IllegalArgumentException("If either readFrameSlots or writtenFrameSlots is set both must be provided.");
        }
        return new OptimizedVirtualizingOSRLoopNode(repeating, osrThreshold, false, readFrameSlots, writtenFrameSlots);
    }

    @Deprecated
    public static OptimizedOSRLoopNode createOSRLoop(RepeatingNode repeating, int osrThreshold, int invalidationBackoff, FrameSlot[] readFrameSlots, FrameSlot[] writtenFrameSlots) {
        return OptimizedOSRLoopNode.createOSRLoop(repeating, osrThreshold, readFrameSlots, writtenFrameSlots);
    }

    private static final class VirtualizingLoopOSRRootNode
    extends AbstractLoopOSRRootNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] readFrameSlots;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] writtenFrameSlots;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] readFrameSlotsTags;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] writtenFrameSlotsTags;
        private final int maxTagsLength;

        VirtualizingLoopOSRRootNode(VirtualizingLoopOSRRootNode previousRoot, OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz) {
            super(loop, frameDescriptor, clazz);
            this.readFrameSlots = previousRoot.readFrameSlots;
            this.writtenFrameSlots = previousRoot.writtenFrameSlots;
            this.readFrameSlotsTags = previousRoot.readFrameSlotsTags;
            this.writtenFrameSlotsTags = previousRoot.writtenFrameSlotsTags;
            this.maxTagsLength = previousRoot.maxTagsLength;
        }

        VirtualizingLoopOSRRootNode(OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz, FrameSlot[] readFrameSlots, FrameSlot[] writtenFrameSlots) {
            super(loop, frameDescriptor, clazz);
            this.readFrameSlots = readFrameSlots;
            this.writtenFrameSlots = writtenFrameSlots;
            this.readFrameSlotsTags = new byte[readFrameSlots.length];
            this.writtenFrameSlotsTags = new byte[writtenFrameSlots.length];
            int maxIndex = -1;
            maxIndex = VirtualizingLoopOSRRootNode.initializeFrameSlots(frameDescriptor, readFrameSlots, this.readFrameSlotsTags, maxIndex);
            maxIndex = VirtualizingLoopOSRRootNode.initializeFrameSlots(frameDescriptor, writtenFrameSlots, this.writtenFrameSlotsTags, maxIndex);
            this.maxTagsLength = maxIndex + 1;
        }

        private static int initializeFrameSlots(FrameDescriptor frameDescriptor, FrameSlot[] frameSlots, byte[] tags, int maxIndex) {
            int currentMaxIndex = maxIndex;
            for (int i = 0; i < frameSlots.length; ++i) {
                FrameSlot frameSlot = frameSlots[i];
                if (VirtualizingLoopOSRRootNode.getFrameSlotIndex(frameSlot) > currentMaxIndex) {
                    currentMaxIndex = VirtualizingLoopOSRRootNode.getFrameSlotIndex(frameSlot);
                }
                tags[i] = frameDescriptor.getFrameSlotKind((FrameSlot)frameSlot).tag;
            }
            return currentMaxIndex;
        }

        private static int getFrameSlotIndex(FrameSlot slot) {
            return slot.getIndex();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object executeOSR(VirtualFrame originalFrame) {
            FrameWithoutBoxing loopFrame = (FrameWithoutBoxing)originalFrame;
            FrameWithoutBoxing parentFrame = (FrameWithoutBoxing)loopFrame.getArguments()[0];
            this.executeTransfer(parentFrame, loopFrame, this.readFrameSlots, this.readFrameSlotsTags);
            try {
                Object status;
                RepeatingNode loopBody = this.loopNode.repeatingNode;
                while (loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue((VirtualFrame)loopFrame))) {
                    if (CompilerDirectives.inInterpreter()) {
                        Object object = loopBody.initialLoopStatus();
                        return object;
                    }
                    TruffleSafepoint.poll((Node)this);
                }
                Object object = status;
                return object;
            }
            finally {
                this.executeTransfer(loopFrame, parentFrame, this.writtenFrameSlots, this.writtenFrameSlotsTags);
            }
        }

        @ExplodeLoop
        private void executeTransfer(FrameWithoutBoxing source, FrameWithoutBoxing target, FrameSlot[] frameSlots, byte[] speculatedTags) {
            if (frameSlots == null) {
                return;
            }
            byte[] currentSourceTags = source.getTags();
            byte[] currentTargetTags = target.getTags();
            if (currentSourceTags.length < this.maxTagsLength || currentTargetTags.length < this.maxTagsLength) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AssertionError((Object)"Frames should never shrink.");
            }
            block9: for (int i = 0; i < frameSlots.length; ++i) {
                boolean tagsCondition;
                FrameSlot slot = frameSlots[i];
                int index = VirtualizingLoopOSRRootNode.getFrameSlotIndex(slot);
                byte speculatedTag = speculatedTags[i];
                byte currentSourceTag = currentSourceTags[index];
                if (CompilerDirectives.inInterpreter() && currentSourceTag == 0 && speculatedTag != 0) {
                    if (frameSlots == this.readFrameSlots) {
                        throw new AssertionError((Object)("Frame slot " + slot + " was never written outside the loop but virtualized as read frame slot."));
                    }
                    throw new AssertionError((Object)("Frame slot " + slot + " was never written in the loop but virtualized as written frame slot."));
                }
                boolean bl = tagsCondition = speculatedTag == currentSourceTag;
                if (!tagsCondition) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    speculatedTags[i] = currentSourceTag;
                    speculatedTag = currentSourceTag;
                }
                switch (speculatedTag) {
                    case 5: {
                        target.setBoolean(slot, source.getBooleanUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 6: {
                        target.setByte(slot, source.getByteUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 3: {
                        target.setDouble(slot, source.getDoubleUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 4: {
                        target.setFloat(slot, source.getFloatUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 2: {
                        target.setInt(slot, source.getIntUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 1: {
                        target.setLong(slot, source.getLongUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 0: {
                        target.setObject(slot, source.getObjectUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    default: {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw new AssertionError((Object)("Defined frame slot " + slot + " is illegal. Revirtualization failed. Please initialize frame slot with a FrameSlotKind."));
                    }
                }
            }
        }
    }

    static final class LoopOSRRootNode
    extends AbstractLoopOSRRootNode {
        LoopOSRRootNode(OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz) {
            super(loop, frameDescriptor, clazz);
        }
    }

    static abstract class AbstractLoopOSRRootNode
    extends BaseOSRRootNode {
        protected final Class<? extends VirtualFrame> clazz;
        @Node.Child
        protected OptimizedOSRLoopNode loopNode;

        AbstractLoopOSRRootNode(OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz) {
            super(null, frameDescriptor);
            this.loopNode = loop;
            this.clazz = clazz;
        }

        public SourceSection getSourceSection() {
            return this.loopNode.getSourceSection();
        }

        @Override
        protected Object executeOSR(VirtualFrame frame) {
            Object status;
            VirtualFrame parentFrame = this.clazz.cast(frame.getArguments()[0]);
            RepeatingNode loopBody = this.loopNode.repeatingNode;
            while (loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue(parentFrame))) {
                if (CompilerDirectives.inInterpreter()) {
                    return loopBody.initialLoopStatus();
                }
                TruffleSafepoint.poll((Node)this);
            }
            return status;
        }

        public final boolean isCloningAllowed() {
            return false;
        }

        public final String toString() {
            return this.loopNode.getRepeatingNode().toString() + "<OSR>";
        }
    }

    private static final class OptimizedVirtualizingOSRLoopNode
    extends OptimizedOSRLoopNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] readFrameSlots;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] writtenFrameSlots;
        private VirtualizingLoopOSRRootNode previousRoot;

        private OptimizedVirtualizingOSRLoopNode(RepeatingNode repeatableNode, int osrThreshold, boolean firstTierBackedgeCounts, FrameSlot[] readFrameSlots, FrameSlot[] writtenFrameSlots) {
            super(repeatableNode, osrThreshold, firstTierBackedgeCounts);
            this.readFrameSlots = readFrameSlots;
            this.writtenFrameSlots = writtenFrameSlots;
        }

        @Override
        protected AbstractLoopOSRRootNode createRootNode(FrameDescriptor rootFrameDescriptor, Class<? extends VirtualFrame> clazz) {
            if (this.readFrameSlots == null || this.writtenFrameSlots == null) {
                return super.createRootNode(rootFrameDescriptor, clazz);
            }
            FrameDescriptor frameDescriptor = rootFrameDescriptor == null ? new FrameDescriptor() : rootFrameDescriptor;
            this.previousRoot = this.previousRoot == null ? new VirtualizingLoopOSRRootNode(this, frameDescriptor, clazz, this.readFrameSlots, this.writtenFrameSlots) : new VirtualizingLoopOSRRootNode(this.previousRoot, this, frameDescriptor, clazz);
            return this.previousRoot;
        }
    }

    private static final class OptimizedDefaultOSRLoopNode
    extends OptimizedOSRLoopNode {
        OptimizedDefaultOSRLoopNode(RepeatingNode repeatableNode, int osrThreshold, boolean firstTierBackedgeCounts) {
            super(repeatableNode, osrThreshold, firstTierBackedgeCounts);
        }
    }
}

