/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import com.oracle.truffle.api.nodes.RootNode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotNmethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.hotspot.HotSpotTruffleRuntimeServices;

public final class HotSpotOptimizedCallTarget
extends OptimizedCallTarget {
    private static final InstalledCode INVALID_CODE = new InstalledCode(null);
    private InstalledCode installedCode = INVALID_CODE;

    public HotSpotOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        super(sourceCallTarget, rootNode);
    }

    public void setInstalledCode(InstalledCode code) {
        HotSpotNmethod nmethod;
        assert (code != null) : "code must never become null";
        InstalledCode oldCode = this.installedCode;
        if (oldCode == code) {
            return;
        }
        if (code instanceof HotSpotNmethod && (nmethod = (HotSpotNmethod)code).isDefault()) {
            throw new IllegalArgumentException("Cannot install a default nmethod for a " + this.getClass().getSimpleName());
        }
        this.installedCode = code;
    }

    @Override
    public boolean isValid() {
        return this.installedCode.isValid();
    }

    @Override
    public boolean isValidLastTier() {
        InstalledCode code = this.installedCode;
        return code.isValid() && code.getName().endsWith("#2");
    }

    @Override
    public long getCodeAddress() {
        return this.installedCode.getAddress();
    }

    @Override
    public SpeculationLog getCompilationSpeculationLog() {
        return HotSpotTruffleRuntimeServices.getCompilationSpeculationLog(this);
    }
}

