/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.compiler.truffle.runtime.hotspot.AbstractHotSpotTruffleRuntime;
import sun.misc.Unsafe;

final class HotSpotThreadLocalHandshake
extends ThreadLocalHandshake {
    private static final Unsafe UNSAFE = AbstractHotSpotTruffleRuntime.UNSAFE;
    static final HotSpotThreadLocalHandshake SINGLETON = new HotSpotThreadLocalHandshake();
    private static final ThreadLocal<ThreadLocalHandshake.TruffleSafepointImpl> STATE = ThreadLocal.withInitial(() -> SINGLETON.getThreadState(Thread.currentThread()));
    private static final int PENDING_OFFSET = AbstractHotSpotTruffleRuntime.getRuntime().getJVMCIReservedLongOffset0();
    private static final long THREAD_EETOP_OFFSET;

    HotSpotThreadLocalHandshake() {
    }

    protected boolean isSupported() {
        return HotSpotThreadLocalHandshake.handshakeSupported();
    }

    static boolean handshakeSupported() {
        return PENDING_OFFSET != -1;
    }

    public void poll(Node enclosingNode) {
        long eetop;
        if (HotSpotThreadLocalHandshake.handshakeSupported() && CompilerDirectives.injectBranchProbability((double)1.0E-4, (UNSAFE.getInt(null, (eetop = UNSAFE.getLong(Thread.currentThread(), THREAD_EETOP_OFFSET)) + (long)PENDING_OFFSET) != 0 ? 1 : 0) != 0)) {
            this.processHandshake(enclosingNode);
        }
    }

    static void doHandshake(Object node) {
        assert (HotSpotThreadLocalHandshake.handshakeSupported()) : "must not call doHandshake if handshake is not supported.";
        SINGLETON.processHandshake((Node)node);
    }

    protected void setFastPending(Thread t) {
        assert (HotSpotThreadLocalHandshake.handshakeSupported()) : "must not call setFastPending if handshake is not supported.";
        if (HotSpotThreadLocalHandshake.handshakeSupported()) {
            HotSpotThreadLocalHandshake.setVolatile(t, PENDING_OFFSET, 1);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public ThreadLocalHandshake.TruffleSafepointImpl getCurrent() {
        return STATE.get();
    }

    protected void clearFastPending() {
        assert (HotSpotThreadLocalHandshake.handshakeSupported()) : "must not call clearFastPending if handshake is not supported.";
        if (HotSpotThreadLocalHandshake.handshakeSupported()) {
            HotSpotThreadLocalHandshake.setVolatile(Thread.currentThread(), PENDING_OFFSET, 0);
        }
    }

    private static void setVolatile(Thread t, int offset, int value) {
        assert (t.isAlive()) : "thread must remain alive while setting fast pending";
        long eetop = UNSAFE.getLong(t, THREAD_EETOP_OFFSET);
        UNSAFE.putIntVolatile(null, eetop + (long)offset, value);
    }

    static {
        try {
            THREAD_EETOP_OFFSET = UNSAFE.objectFieldOffset(Thread.class.getDeclaredField("eetop"));
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }
}

