/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.virtual.EscapeObjectState;
import org.graalvm.compiler.nodes.virtual.LockState;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.virtual.nodes.MaterializedObjectState;
import org.graalvm.compiler.virtual.nodes.VirtualObjectState;

public class ObjectState {
    public static final CounterKey CREATE_ESCAPED_OBJECT_STATE = DebugContext.counter("CreateEscapeObjectState");
    public static final CounterKey GET_ESCAPED_OBJECT_STATE = DebugContext.counter("GetEscapeObjectState");
    private ValueNode[] entries;
    private ValueNode materializedValue;
    private LockState locks;
    private boolean ensureVirtualized;
    private EscapeObjectState cachedState;
    boolean copyOnWrite;

    public ObjectState(ValueNode[] entries, List<MonitorIdNode> locks, boolean ensureVirtualized) {
        this(entries, (LockState)null, ensureVirtualized);
        for (int i = locks.size() - 1; i >= 0; --i) {
            this.locks = new LockState(locks.get(i), this.locks);
        }
    }

    public ObjectState(ValueNode[] entries, LockState locks, boolean ensureVirtualized) {
        assert (ObjectState.checkIllegalValues(entries));
        this.entries = entries;
        this.locks = locks;
        this.ensureVirtualized = ensureVirtualized;
    }

    public ObjectState(ValueNode materializedValue, LockState locks, boolean ensureVirtualized) {
        assert (materializedValue != null);
        this.materializedValue = materializedValue;
        this.locks = locks;
        this.ensureVirtualized = ensureVirtualized;
    }

    private ObjectState(ObjectState other) {
        this.entries = other.entries == null ? null : (ValueNode[])other.entries.clone();
        this.materializedValue = other.materializedValue;
        this.locks = other.locks;
        this.cachedState = other.cachedState;
        this.ensureVirtualized = other.ensureVirtualized;
    }

    public ObjectState cloneState() {
        return new ObjectState(this);
    }

    public static boolean checkIllegalValues(ValueNode[] values) {
        if (values != null) {
            for (int v = 1; v < values.length; v += ObjectState.checkIllegalValue(values, v)) {
            }
        }
        return true;
    }

    public static int checkIllegalValue(ValueNode[] values, int v) {
        int res = 1;
        if (v > 0 && values[v].isIllegalConstant()) assert (values[v - 1].getStackKind().needsTwoSlots() || (res = ObjectState.checkByteArrayIllegal(values, v)) != -1);
        return res;
    }

    private static int checkByteArrayIllegal(ValueNode[] values, int valuePos) {
        int j;
        int bytes = 1;
        int i = valuePos - bytes;
        while (i > 0 && values[i].isIllegalConstant()) {
            i = valuePos - ++bytes;
        }
        assert (i >= 0 && values[i].getStackKind().isPrimitive());
        ValueNode value = values[i];
        int totalBytes = value.getStackKind().getByteCount();
        for (j = valuePos + 1; j < values.length && values[i].isIllegalConstant(); ++j) {
        }
        assert (j - i <= totalBytes);
        return j - valuePos;
    }

    public EscapeObjectState createEscapeObjectState(DebugContext debug, MetaAccessExtensionProvider metaAccessExtensionProvider, VirtualObjectNode virtual) {
        GET_ESCAPED_OBJECT_STATE.increment(debug);
        if (this.cachedState == null) {
            CREATE_ESCAPED_OBJECT_STATE.increment(debug);
            if (this.isVirtual()) {
                ValueNode[] newEntries = (ValueNode[])this.entries.clone();
                for (int i = 0; i < newEntries.length; ++i) {
                    if (newEntries[i].asJavaConstant() != JavaConstant.defaultForKind((JavaKind)virtual.entryKind(metaAccessExtensionProvider, i).getStackKind())) continue;
                    newEntries[i] = null;
                }
                this.cachedState = new VirtualObjectState(virtual, newEntries);
            } else {
                this.cachedState = new MaterializedObjectState(virtual, this.materializedValue);
            }
        }
        return this.cachedState;
    }

    public boolean isVirtual() {
        assert (this.materializedValue == null ^ this.entries == null);
        return this.materializedValue == null;
    }

    public ValueNode[] getEntries() {
        assert (this.isVirtual());
        return this.entries;
    }

    public ValueNode getEntry(int index) {
        assert (this.isVirtual());
        return this.entries[index];
    }

    public ValueNode getMaterializedValue() {
        assert (!this.isVirtual());
        return this.materializedValue;
    }

    public void setEntry(int index, ValueNode value) {
        assert (this.isVirtual());
        this.cachedState = null;
        this.entries[index] = value;
    }

    public void escape(ValueNode materialized) {
        assert (this.isVirtual());
        assert (materialized != null);
        this.materializedValue = materialized;
        this.entries = null;
        this.cachedState = null;
        assert (!this.isVirtual());
    }

    public void updateMaterializedValue(ValueNode value) {
        assert (!this.isVirtual());
        assert (value != null);
        this.cachedState = null;
        this.materializedValue = value;
    }

    public void addLock(MonitorIdNode monitorId) {
        this.locks = new LockState(monitorId, this.locks);
    }

    public MonitorIdNode removeLock() {
        try {
            MonitorIdNode monitorIdNode = this.locks.monitorId;
            return monitorIdNode;
        }
        finally {
            this.locks = this.locks.next;
        }
    }

    public LockState getLocks() {
        return this.locks;
    }

    public boolean hasLocks() {
        return this.locks != null;
    }

    public boolean locksEqual(ObjectState other) {
        LockState a = this.locks;
        LockState b = other.locks;
        while (a != null && b != null && a.monitorId == b.monitorId) {
            a = a.next;
            b = b.next;
        }
        return a == null && b == null;
    }

    public void setEnsureVirtualized(boolean ensureVirtualized) {
        this.ensureVirtualized = ensureVirtualized;
    }

    public boolean getEnsureVirtualized() {
        return this.ensureVirtualized;
    }

    public String toString() {
        StringBuilder str = new StringBuilder().append('{');
        if (this.locks != null) {
            str.append('l').append(this.locks).append(' ');
        }
        if (this.entries != null) {
            for (int i = 0; i < this.entries.length; ++i) {
                str.append("entry").append(i).append('=').append(this.entries[i]).append(' ');
            }
        }
        if (this.materializedValue != null) {
            str.append("mat=").append(this.materializedValue);
        }
        return str.append('}').toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.entries);
        result = 31 * result + (this.locks != null ? this.locks.monitorId.getLockDepth() : 0);
        result = 31 * result + (this.materializedValue == null ? 0 : this.materializedValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectState other = (ObjectState)obj;
        if (!Arrays.equals(this.entries, other.entries)) {
            return false;
        }
        if (!this.locksEqual(other)) {
            return false;
        }
        return !(this.materializedValue == null ? other.materializedValue != null : !this.materializedValue.equals(other.materializedValue));
    }

    public ObjectState share() {
        this.copyOnWrite = true;
        return this;
    }
}

