/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge.jni;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativebridge.jni.JNI;
import org.graalvm.nativebridge.jni.JNIMethodScope;
import org.graalvm.nativebridge.jni.JNIUtil;
import org.graalvm.word.WordFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class HSObject {
    private final JNI.JObject handle;
    private final Cleaner cleaner;
    private HSObject next;
    private static final Set<Cleaner> CLEANERS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ReferenceQueue<HSObject> CLEANERS_QUEUE = new ReferenceQueue();

    protected HSObject(JNI.JNIEnv env, JNI.JObject handle) {
        HSObject.cleanHandles(env);
        if (HSObject.checkingGlobalDuplicates()) {
            HSObject.checkNonExistingGlobalReference(env, handle);
        }
        this.handle = JNIUtil.NewGlobalRef(env, handle, this.getClass().getSimpleName());
        this.cleaner = new Cleaner(this, this.handle);
        CLEANERS.add(this.cleaner);
        this.next = null;
    }

    private static boolean checkingGlobalDuplicates() {
        return HSObject.assertionsEnabled() || JNIUtil.tracingAt(1);
    }

    protected HSObject(JNIMethodScope scope, JNI.JObject handle) {
        this.handle = handle;
        this.next = scope.locals;
        scope.locals = this;
        this.cleaner = null;
    }

    static int invalidate(HSObject head) {
        HSObject o = head;
        int count = 0;
        while (o != null) {
            HSObject next = o.next;
            o.next = o;
            o = next;
            ++count;
        }
        return count;
    }

    public JNI.JObject getHandle() {
        if (this.next == this) {
            throw new IllegalArgumentException("Reclaimed JNI reference: " + this);
        }
        return this.handle;
    }

    public String toString() {
        return String.format("%s[0x%x]", this.getClass().getSimpleName(), this.handle.rawValue());
    }

    public void release(JNI.JNIEnv env) {
        if (this.cleaner != null) {
            assert (this.next == null || this.next == this);
            this.next = this;
            this.cleaner.clean(env);
        }
    }

    public static void cleanHandles(JNI.JNIEnv env) {
        Cleaner cleaner;
        while ((cleaner = (Cleaner)CLEANERS_QUEUE.poll()) != null) {
            cleaner.clean(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkNonExistingGlobalReference(JNI.JNIEnv env, JNI.JObject handle) {
        Iterator<Cleaner> iterator = CLEANERS.iterator();
        while (iterator.hasNext()) {
            Cleaner cleaner;
            Cleaner cleaner2 = cleaner = iterator.next();
            synchronized (cleaner2) {
                if (cleaner.handle.isNonNull() && JNIUtil.IsSameObject(env, handle, cleaner.handle)) {
                    throw new IllegalArgumentException("Global JNI handle already exists for object referenced by " + handle.rawValue());
                }
            }
        }
    }

    private static boolean assertionsEnabled() {
        boolean res = false;
        if (!$assertionsDisabled) {
            res = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return res;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Cleaner
    extends PhantomReference<HSObject> {
        private JNI.JObject handle;

        Cleaner(HSObject referent, JNI.JObject handle) {
            super(referent, CLEANERS_QUEUE);
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clean(JNI.JNIEnv env) {
            if (CLEANERS.remove(this)) {
                if (HSObject.checkingGlobalDuplicates()) {
                    Cleaner cleaner = this;
                    synchronized (cleaner) {
                        JNIUtil.DeleteGlobalRef(env, this.handle);
                        this.handle = (JNI.JObject)WordFactory.nullPointer();
                    }
                } else {
                    JNIUtil.DeleteGlobalRef(env, this.handle);
                }
            }
        }
    }
}

