/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.jniutils;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Objects;
import org.graalvm.jniutils.HotSpotCalls;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.WordFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JNIExceptionWrapper
extends RuntimeException {
    private static final String HS_ENTRYPOINTS_CLASS = "org.graalvm.jniutils.JNIExceptionWrapperEntryPoints";
    private static final long serialVersionUID = 1L;
    private static final JNIMethodResolver CreateException = JNIMethodResolver.create("createException", Throwable.class, String.class);
    private static final JNIMethodResolver GetClassName = JNIMethodResolver.create("getClassName", String.class, Class.class);
    private static final JNIMethodResolver GetStackTrace = JNIMethodResolver.create("getStackTrace", byte[].class, Throwable.class);
    private static final JNIMethodResolver GetThrowableMessage = JNIMethodResolver.create("getThrowableMessage", String.class, Throwable.class);
    private static final JNIMethodResolver UpdateStackTrace = JNIMethodResolver.create("updateStackTrace", Throwable.class, Throwable.class, String[].class);
    private static volatile JNI.JClass entryPointsClass;
    private final JNI.JThrowable throwableHandle;
    private final boolean throwableRequiresStackTraceUpdate;

    private JNIExceptionWrapper(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        super(JNIExceptionWrapper.formatExceptionMessage(JNIExceptionWrapper.getClassName(env, throwableHandle), JNIExceptionWrapper.getMessage(env, throwableHandle)));
        this.throwableHandle = throwableHandle;
        this.throwableRequiresStackTraceUpdate = this.createMergedStackTrace(env);
    }

    private void throwInHotSpot(JNI.JNIEnv env) {
        JNI.JThrowable toThrow = this.throwableRequiresStackTraceUpdate ? JNIExceptionWrapper.updateStackTrace(env, this.throwableHandle, JNIExceptionWrapper.encode(this.getStackTrace())) : this.throwableHandle;
        JNIUtil.Throw(env, toThrow);
    }

    private boolean createMergedStackTrace(JNI.JNIEnv env) {
        boolean res;
        StackTraceElement[] mergedStack;
        StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(env, this.throwableHandle);
        if (hsStack.length == 0 || JNIExceptionWrapper.containsHotSpotCall(hsStack)) {
            mergedStack = hsStack;
            res = false;
        } else {
            StackTraceElement[] nativeStack = this.getStackTrace();
            boolean originatedInHotSpot = !hsStack[0].isNativeMethod();
            mergedStack = JNIExceptionWrapper.mergeStackTraces(hsStack, nativeStack, 0, JNIExceptionWrapper.getIndexOfPropagateJNIExceptionFrame(nativeStack), originatedInHotSpot);
            res = true;
        }
        this.setStackTrace(mergedStack);
        return res;
    }

    public static void wrapAndThrowPendingJNIException(JNI.JNIEnv env) {
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, ExceptionHandler.DEFAULT);
    }

    public static void wrapAndThrowPendingJNIException(JNI.JNIEnv env, ExceptionHandler exceptionHandler) {
        Objects.requireNonNull(exceptionHandler, "ExceptionHandler must be non null.");
        if (JNIUtil.ExceptionCheck(env)) {
            JNI.JThrowable exception = JNIUtil.ExceptionOccurred(env);
            if (JNIUtil.tracingAt(2) && exception.isNonNull()) {
                JNIUtil.ExceptionDescribe(env);
            }
            JNIUtil.ExceptionClear(env);
            exceptionHandler.handleException(new ExceptionHandlerContext(env, exception));
        }
    }

    public static void throwInHotSpot(JNI.JNIEnv env, Throwable original) {
        try {
            JNIUtil.trace(2, original);
            if (original.getClass() == JNIExceptionWrapper.class) {
                ((JNIExceptionWrapper)original).throwInHotSpot(env);
            } else {
                JNIUtil.Throw(env, JNIExceptionWrapper.createHSException(env, original));
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw t;
            }
            original.addSuppressed(t);
            original.printStackTrace();
        }
    }

    public static JNI.JThrowable createHSException(JNI.JNIEnv env, Throwable original) {
        JNI.JThrowable hsThrowable;
        if (original instanceof JNIExceptionWrapper) {
            JNIExceptionWrapper jniExceptionWrapper = (JNIExceptionWrapper)original;
            hsThrowable = jniExceptionWrapper.throwableHandle;
            if (jniExceptionWrapper.throwableRequiresStackTraceUpdate) {
                hsThrowable = JNIExceptionWrapper.updateStackTrace(env, hsThrowable, JNIExceptionWrapper.encode(jniExceptionWrapper.getStackTrace()));
            }
        } else {
            StackTraceElement[] nativeStack;
            hsThrowable = (JNI.JThrowable)JNIExceptionWrapper.createExceptionOfSameType(env, original);
            boolean hasSameExceptionType = hsThrowable.isNonNull();
            if (!hasSameExceptionType) {
                String message = JNIExceptionWrapper.formatExceptionMessage(original.getClass().getName(), original.getMessage());
                JNI.JString hsMessage = JNIUtil.createHSString(env, message);
                hsThrowable = (JNI.JThrowable)JNIExceptionWrapper.callCreateException(env, hsMessage);
            }
            if ((nativeStack = original.getStackTrace()).length != 0) {
                StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(env, hsThrowable);
                String[] merged = JNIExceptionWrapper.encode(JNIExceptionWrapper.mergeStackTraces(hsStack, nativeStack, hasSameExceptionType ? 0 : 1, 0, false));
                hsThrowable = JNIExceptionWrapper.updateStackTrace(env, hsThrowable, merged);
            }
        }
        return hsThrowable;
    }

    public static JNIExceptionWrapper forHSException(JNI.JNIEnv env, JNI.JThrowable jThrowable) {
        if (jThrowable.isNull()) {
            throw new NullPointerException("jThrowable must be non null");
        }
        return new JNIExceptionWrapper(env, jThrowable);
    }

    private static StackTraceElement[] mergeStackTraces(StackTraceElement[] hotSpotStackTrace, StackTraceElement[] nativeStackTrace, int hotSpotStackStartIndex, int nativeStackStartIndex, boolean originatedInHotSpot) {
        int targetIndex = 0;
        StackTraceElement[] merged = new StackTraceElement[hotSpotStackTrace.length - hotSpotStackStartIndex + nativeStackTrace.length - nativeStackStartIndex];
        boolean startingHotSpotFrame = true;
        boolean startingnativeFrame = true;
        boolean useHotSpotStack = originatedInHotSpot;
        int hotSpotStackIndex = hotSpotStackStartIndex;
        int nativeStackIndex = nativeStackStartIndex;
        while (hotSpotStackIndex < hotSpotStackTrace.length || nativeStackIndex < nativeStackTrace.length) {
            if (useHotSpotStack) {
                while (hotSpotStackIndex < hotSpotStackTrace.length && (startingHotSpotFrame || !hotSpotStackTrace[hotSpotStackIndex].isNativeMethod())) {
                    startingHotSpotFrame = false;
                    merged[targetIndex++] = hotSpotStackTrace[hotSpotStackIndex++];
                }
                startingHotSpotFrame = true;
            } else {
                useHotSpotStack = true;
            }
            while (nativeStackIndex < nativeStackTrace.length && (startingnativeFrame || !HotSpotCalls.isHotSpotCall(nativeStackTrace[nativeStackIndex]))) {
                startingnativeFrame = false;
                merged[targetIndex++] = nativeStackTrace[nativeStackIndex++];
            }
            startingnativeFrame = true;
        }
        return merged;
    }

    private static String[] encode(StackTraceElement[] stackTrace) {
        String[] res = new String[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            String methodName = stackTrace[i].getMethodName();
            String fileName = stackTrace[i].getFileName();
            int lineNumber = stackTrace[i].getLineNumber();
            res[i] = String.format("%s|%s|%s|%d", className == null ? "" : className.replace('|', '!'), methodName == null ? "" : methodName.replace('|', '!'), fileName == null ? "" : fileName.replace('|', '!'), lineNumber);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StackTraceElement[] getJNIExceptionStackTrace(JNI.JNIEnv env, JNI.JObject throwableHandle) {
        byte[] serializedStackTrace = JNIUtil.createArray(env, (JNI.JByteArray)JNIExceptionWrapper.callGetStackTrace(env, throwableHandle));
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(serializedStackTrace));){
            int len = in.readInt();
            StackTraceElement[] res = new StackTraceElement[len];
            for (int i = 0; i < len; ++i) {
                String className = in.readUTF();
                String methodName = in.readUTF();
                String fileName = in.readUTF();
                fileName = fileName.isEmpty() ? null : fileName;
                int lineNumber = in.readInt();
                res[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
            }
            StackTraceElement[] stackTraceElementArray = res;
            return stackTraceElementArray;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static boolean containsHotSpotCall(StackTraceElement[] stackTrace) {
        for (StackTraceElement e : stackTrace) {
            if (!HotSpotCalls.isHotSpotCall(e)) continue;
            return true;
        }
        return false;
    }

    private static JNI.JThrowable updateStackTrace(JNI.JNIEnv env, JNI.JThrowable throwableHandle, String[] encodedStackTrace) {
        JNI.JClass string = JNIUtil.findClass(env, JNIUtil.getBinaryName(String.class.getName()));
        JNI.JObjectArray stackTraceHandle = JNIUtil.NewObjectArray(env, encodedStackTrace.length, string, (JNI.JObject)WordFactory.nullPointer());
        for (int i = 0; i < encodedStackTrace.length; ++i) {
            JNI.JString element = JNIUtil.createHSString(env, encodedStackTrace[i]);
            JNIUtil.SetObjectArrayElement(env, stackTraceHandle, i, element);
        }
        return (JNI.JThrowable)JNIExceptionWrapper.callUpdateStackTrace(env, throwableHandle, stackTraceHandle);
    }

    private static String getMessage(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        JNI.JString message = (JNI.JString)JNIExceptionWrapper.callGetThrowableMessage(env, throwableHandle);
        return JNIUtil.createString(env, message);
    }

    private static String getClassName(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        JNI.JClass classHandle = JNIUtil.GetObjectClass(env, throwableHandle);
        JNI.JString className = (JNI.JString)JNIExceptionWrapper.callGetClassName(env, classHandle);
        return JNIUtil.createString(env, className);
    }

    private static String formatExceptionMessage(String className, String message) {
        StringBuilder builder = new StringBuilder(className);
        if (message != null) {
            builder.append(": ").append(message);
        }
        return builder.toString();
    }

    private static int getIndexOfPropagateJNIExceptionFrame(StackTraceElement[] stackTrace) {
        boolean state = false;
        for (int i = 0; i < stackTrace.length; ++i) {
            if (JNIExceptionWrapper.isStackFrame(stackTrace[i], JNIExceptionWrapper.class, "wrapAndThrowPendingJNIException")) {
                state = true;
                continue;
            }
            if (!state) continue;
            return i;
        }
        return 0;
    }

    private static boolean isStackFrame(StackTraceElement stackTraceElement, Class<?> clazz, String methodName) {
        return clazz.getName().equals(stackTraceElement.getClassName()) && methodName.equals(stackTraceElement.getMethodName());
    }

    private static <T extends JNI.JObject> T createExceptionOfSameType(JNI.JNIEnv env, Throwable original) {
        WordFactory.nullPointer();
        String className = original.getClass().getTypeName();
        JNI.JClass exceptionClass = JNIUtil.findClass(env, (JNI.JObject)WordFactory.nullPointer(), JNIUtil.getBinaryName(className), false);
        if (exceptionClass.isNonNull()) {
            HotSpotCalls.JNIMethod constructor = HotSpotCalls.JNIMethod.findMethod(env, exceptionClass, false, false, "<init>", JNIUtil.encodeMethodSignature(Void.TYPE, String.class));
            if (constructor != null) {
                JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                args.addressOf(0).setJObject(JNIUtil.createHSString(env, original.getMessage()));
                Object res = HotSpotCalls.getDefault().callNewObject(env, exceptionClass, constructor, args);
                return (T)res;
            }
            constructor = HotSpotCalls.JNIMethod.findMethod(env, exceptionClass, false, false, "<init>", JNIUtil.encodeMethodSignature(Void.TYPE, new Class[0]));
            if (constructor != null) {
                Object res = HotSpotCalls.getDefault().callNewObject(env, exceptionClass, constructor, (JNI.JValue)WordFactory.nullPointer());
                return (T)res;
            }
        }
        return (T)((JNI.JObject)WordFactory.nullPointer());
    }

    private static <T extends JNI.JObject> T callCreateException(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (T)HotSpotCalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getHotSpotEntryPoints(env), CreateException.resolve(env), args);
    }

    private static <T extends JNI.JObject> T callUpdateStackTrace(JNI.JNIEnv env, JNI.JObject p0, JNI.JObject p1) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        args.addressOf(1).setJObject(p1);
        return (T)HotSpotCalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getHotSpotEntryPoints(env), UpdateStackTrace.resolve(env), args);
    }

    private static <T extends JNI.JObject> T callGetThrowableMessage(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (T)HotSpotCalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getHotSpotEntryPoints(env), GetThrowableMessage.resolve(env), args);
    }

    static <T extends JNI.JObject> T callGetClassName(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (T)HotSpotCalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getHotSpotEntryPoints(env), GetClassName.resolve(env), args);
    }

    private static <T extends JNI.JObject> T callGetStackTrace(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (T)HotSpotCalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getHotSpotEntryPoints(env), GetStackTrace.resolve(env), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JNI.JClass getHotSpotEntryPoints(JNI.JNIEnv env) {
        JNI.JClass res = entryPointsClass;
        if (!res.isNull()) return res;
        String binaryName = JNIUtil.getBinaryName(HS_ENTRYPOINTS_CLASS);
        JNI.JObject classLoader = JNIUtil.getJVMCIClassLoader(env);
        JNI.JClass entryPoints = classLoader.isNonNull() ? JNIUtil.findClass(env, classLoader, binaryName) : JNIUtil.findClass(env, binaryName);
        if (entryPoints.isNull()) {
            JNIUtil.ExceptionClear(env);
            throw new InternalError("Failed to load org.graalvm.jniutils.JNIExceptionWrapperEntryPoints");
        }
        Class<JNIExceptionWrapper> clazz = JNIExceptionWrapper.class;
        synchronized (JNIExceptionWrapper.class) {
            res = entryPointsClass;
            if (!res.isNull()) return res;
            entryPointsClass = res = JNIUtil.NewGlobalRef(env, entryPoints, "Class<org.graalvm.jniutils.JNIExceptionWrapperEntryPoints>");
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return res;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class JNIMethodResolver
    implements HotSpotCalls.JNIMethod {
        private final String methodName;
        private final String methodSignature;
        private volatile JNI.JMethodID methodId;

        private JNIMethodResolver(String methodName, String methodSignature) {
            this.methodName = methodName;
            this.methodSignature = methodSignature;
        }

        JNIMethodResolver resolve(JNI.JNIEnv jniEnv) {
            JNI.JMethodID res = this.methodId;
            if (res.isNull()) {
                JNI.JClass entryPointClass = JNIExceptionWrapper.getHotSpotEntryPoints(jniEnv);
                try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)this.methodName);
                     CTypeConversion.CCharPointerHolder sig = CTypeConversion.toCString((CharSequence)this.methodSignature);){
                    res = JNIUtil.GetStaticMethodID(jniEnv, entryPointClass, name.get(), sig.get());
                    if (res.isNull()) {
                        throw new InternalError("No such method: " + this.methodName);
                    }
                    this.methodId = res;
                }
            }
            return this;
        }

        @Override
        public JNI.JMethodID getJMethodID() {
            return this.methodId;
        }

        @Override
        public String getDisplayName() {
            return this.methodName;
        }

        static JNIMethodResolver create(String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
            return new JNIMethodResolver(methodName, JNIUtil.encodeMethodSignature(returnType, parameterTypes));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ExceptionHandler {
        public static final ExceptionHandler DEFAULT = new ExceptionHandler(){

            @Override
            public void handleException(ExceptionHandlerContext context) {
                context.throwJNIExceptionWrapper();
            }
        };

        @SafeVarargs
        public static ExceptionHandler allowExceptions(final Class<? extends Throwable> ... allowedExceptions) {
            return new ExceptionHandler(){

                @Override
                public void handleException(ExceptionHandlerContext context) {
                    JNI.JThrowable throwable = context.getThrowable();
                    JNI.JNIEnv env = context.getEnv();
                    JNI.JClass throwableClass = JNIUtil.GetObjectClass(env, throwable);
                    boolean allowed = false;
                    for (Class allowedException : allowedExceptions) {
                        JNI.JClass allowedExceptionClass = JNIUtil.findClass(env, JNIUtil.getBinaryName(allowedException.getName()));
                        if (!allowedExceptionClass.isNonNull() || !JNIUtil.IsSameObject(env, throwableClass, allowedExceptionClass)) continue;
                        allowed = true;
                        break;
                    }
                    if (!allowed) {
                        context.throwJNIExceptionWrapper();
                    }
                }
            };
        }

        public void handleException(ExceptionHandlerContext var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class ExceptionHandlerContext {
        private final JNI.JNIEnv env;
        private final JNI.JThrowable throwable;

        ExceptionHandlerContext(JNI.JNIEnv env, JNI.JThrowable throwable) {
            this.env = env;
            this.throwable = throwable;
        }

        public JNI.JNIEnv getEnv() {
            return this.env;
        }

        public JNI.JThrowable getThrowable() {
            return this.throwable;
        }

        public String getThrowableMessage() {
            return JNIExceptionWrapper.getMessage(this.env, this.throwable);
        }

        public String getThrowableClassName() {
            return JNIExceptionWrapper.getClassName(this.env, this.throwable);
        }

        public StackTraceElement[] getMergedStackTrace() {
            StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(this.env, this.throwable);
            if (hsStack.length == 0 || JNIExceptionWrapper.containsHotSpotCall(hsStack)) {
                return hsStack;
            }
            StackTraceElement[] nativeStack = Thread.currentThread().getStackTrace();
            boolean originatedInHotSpot = !hsStack[0].isNativeMethod();
            return JNIExceptionWrapper.mergeStackTraces(hsStack, nativeStack, 0, JNIExceptionWrapper.getIndexOfPropagateJNIExceptionFrame(nativeStack), originatedInHotSpot);
        }

        public void throwJNIExceptionWrapper() {
            throw new JNIExceptionWrapper(this.env, this.throwable);
        }
    }
}

