/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIExceptionWrapper;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.word.WordFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JNIClassCache {
    private static final Map<String, JNIClassData> classesByName = new ConcurrentHashMap<String, JNIClassData>();

    private JNIClassCache() {
    }

    public static JNI.JClass lookupClass(JNI.JNIEnv env, Class<?> clazz) throws JNIExceptionWrapper {
        return JNIClassCache.lookupClass(env, clazz.getName());
    }

    public static JNI.JClass lookupClass(JNI.JNIEnv env, String className) throws JNIExceptionWrapper {
        return JNIClassCache.lookupClassImpl(env, className, true);
    }

    public static JNI.JClass lookupOptionalClass(JNI.JNIEnv env, Class<?> clazz) {
        return JNIClassCache.lookupOptionalClass(env, clazz.getName());
    }

    public static JNI.JClass lookupOptionalClass(JNI.JNIEnv env, String className) {
        return JNIClassCache.lookupClassImpl(env, className, false);
    }

    private static JNI.JClass lookupClassImpl(JNI.JNIEnv env, String className, boolean required) {
        return classesByName.computeIfAbsent(className, cn -> {
            JNI.JClass jClass = JNIUtil.findClass(env, (JNI.JObject)WordFactory.nullPointer(), JNIUtil.getBinaryName(className), required);
            JNIClassData res = jClass.isNull() ? JNIClassData.INVALID : new JNIClassData(JNIUtil.NewGlobalRef(env, jClass, className));
            return res;
        }).jClassGlobal;
    }

    public static void dispose(JNI.JNIEnv jniEnv) {
        Iterator<JNIClassData> iterator = classesByName.values().iterator();
        while (iterator.hasNext()) {
            JNIClassData classData = iterator.next();
            iterator.remove();
            if (classData == JNIClassData.INVALID) continue;
            JNIUtil.DeleteGlobalRef(jniEnv, classData.jClassGlobal);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class JNIClassData {
        static final JNIClassData INVALID = new JNIClassData(null);
        private final JNI.JClass jClassGlobal;

        JNIClassData(JNI.JClass jClassGlobal) {
            this.jClassGlobal = jClassGlobal;
        }
    }
}

