/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import org.graalvm.collections.Pair;
import org.graalvm.nativebridge.JNIHotSpotMarshaller;
import org.graalvm.nativebridge.JNINativeMarshaller;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.polyglot.TypeLiteral;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JNIConfig {
    private final Map<Type, JNIHotSpotMarshaller<?>> hotSpotMarshallers;
    private final Map<Type, JNINativeMarshaller<?>> nativeMarshallers;
    private final Map<Class<? extends Annotation>, List<Pair<Class<?>, JNIHotSpotMarshaller<?>>>> annotationHotSpotMarshallers;
    private final Map<Class<? extends Annotation>, List<Pair<Class<?>, JNINativeMarshaller<?>>>> annotationNativeMarshallers;
    private final LongUnaryOperator attachThreadAction;
    private final LongUnaryOperator detachThreadAction;
    private final LongBinaryOperator shutDownIsolateAction;
    private final LongBinaryOperator releaseNativeObjectAction;

    JNIConfig(Map<Type, JNIHotSpotMarshaller<?>> hotSpotMarshallers, Map<Type, JNINativeMarshaller<?>> nativeMarshallers, Map<Class<? extends Annotation>, List<Pair<Class<?>, JNIHotSpotMarshaller<?>>>> annotationHotSpotMarshallers, Map<Class<? extends Annotation>, List<Pair<Class<?>, JNINativeMarshaller<?>>>> annotationNativeMarshallers, LongUnaryOperator attachThreadAction, LongUnaryOperator detachThreadAction, LongBinaryOperator shutDownIsolateAction, LongBinaryOperator releaseNativeObjectAction) {
        this.hotSpotMarshallers = hotSpotMarshallers;
        this.nativeMarshallers = nativeMarshallers;
        this.annotationHotSpotMarshallers = annotationHotSpotMarshallers;
        this.annotationNativeMarshallers = annotationNativeMarshallers;
        this.attachThreadAction = attachThreadAction;
        this.detachThreadAction = detachThreadAction;
        this.shutDownIsolateAction = shutDownIsolateAction;
        this.releaseNativeObjectAction = releaseNativeObjectAction;
    }

    @SafeVarargs
    public final <T> JNIHotSpotMarshaller<T> lookupHotSpotMarshaller(Class<T> type, Class<? extends Annotation> ... annotationTypes) {
        JNIHotSpotMarshaller<?> res = this.lookupHotSpotMarshallerImpl(type, annotationTypes);
        if (res != null) {
            return res;
        }
        throw JNIConfig.unsupported(type);
    }

    @SafeVarargs
    public final <T> JNIHotSpotMarshaller<T> lookupHotSpotMarshaller(TypeLiteral<T> type, Class<? extends Annotation> ... annotationTypes) {
        JNIHotSpotMarshaller<?> res = this.lookupHotSpotMarshallerImpl(type.getType(), annotationTypes);
        if (res != null) {
            return res;
        }
        throw JNIConfig.unsupported(type.getType());
    }

    @SafeVarargs
    public final <T> JNINativeMarshaller<T> lookupNativeMarshaller(Class<T> type, Class<? extends Annotation> ... annotationTypes) {
        JNINativeMarshaller<?> res = this.lookupNativeMarshallerImpl(type, annotationTypes);
        if (res != null) {
            return res;
        }
        throw JNIConfig.unsupported(type);
    }

    @SafeVarargs
    public final <T> JNINativeMarshaller<T> lookupNativeMarshaller(TypeLiteral<T> type, Class<? extends Annotation> ... annotationTypes) {
        JNINativeMarshaller<?> res = this.lookupNativeMarshallerImpl(type.getType(), annotationTypes);
        if (res != null) {
            return res;
        }
        throw JNIConfig.unsupported(type.getType());
    }

    long attachThread(long isolate) {
        return this.attachThreadAction.applyAsLong(isolate);
    }

    boolean detachThread(long isolateThread) {
        return this.detachThreadAction.applyAsLong(isolateThread) == 0L;
    }

    boolean releaseNativeObject(long isolateThread, long handle) {
        return this.releaseNativeObjectAction.applyAsLong(isolateThread, handle) == 0L;
    }

    boolean shutDownIsolate(long isolate, long isolateThread) {
        return this.shutDownIsolateAction.applyAsLong(isolate, isolateThread) == 0L;
    }

    private static RuntimeException unsupported(Type type) {
        throw new UnsupportedOperationException(String.format("Marshalling of %s is not supported", type));
    }

    @SafeVarargs
    private final JNIHotSpotMarshaller<?> lookupHotSpotMarshallerImpl(Type type, Class<? extends Annotation> ... annotationTypes) {
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            JNIHotSpotMarshaller res = (JNIHotSpotMarshaller)JNIConfig.lookup(this.annotationHotSpotMarshallers, type, annotationType);
            if (res == null) continue;
            return res;
        }
        return this.hotSpotMarshallers.get(type);
    }

    @SafeVarargs
    private final JNINativeMarshaller<?> lookupNativeMarshallerImpl(Type type, Class<? extends Annotation> ... annotationTypes) {
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            JNINativeMarshaller res = (JNINativeMarshaller)JNIConfig.lookup(this.annotationNativeMarshallers, type, annotationType);
            if (res == null) continue;
            return res;
        }
        return this.nativeMarshallers.get(type);
    }

    private static <T> T lookup(Map<Class<? extends Annotation>, List<Pair<Class<?>, T>>> marshallers, Type type, Class<? extends Annotation> annotationType) {
        List<Pair<Class<?>, T>> marshallersForAnnotation = marshallers.get(annotationType);
        if (marshallersForAnnotation != null) {
            Class<?> rawType = JNIConfig.erasure(type);
            for (Pair<Class<?>, T> marshaller : marshallersForAnnotation) {
                if (!((Class)marshaller.getLeft()).isAssignableFrom(rawType)) continue;
                return (T)marshaller.getRight();
            }
        }
        return null;
    }

    private static Class<?> erasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return JNIConfig.arrayTypeFromComponentType(JNIConfig.erasure(((GenericArrayType)type).getGenericComponentType()));
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private static Class<?> arrayTypeFromComponentType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Builder {
        private static final LongUnaryOperator ATTACH_UNSUPPORTED = isolate -> {
            throw new UnsupportedOperationException("Attach is not supported.");
        };
        private static final LongUnaryOperator DETACH_UNSUPPORTED = isolateThread -> {
            throw new UnsupportedOperationException("Detach is not supported.");
        };
        private static final LongBinaryOperator SHUTDOWN_UNSUPPORTED = (isolate, isolateThread) -> {
            throw new UnsupportedOperationException("Isolate shutdown is not supported.");
        };
        private static final LongBinaryOperator RELEASE_UNSUPPORTED = (isolateThread, handle) -> {
            throw new UnsupportedOperationException("Native object clean up is not supported.");
        };
        private final Map<Type, JNIHotSpotMarshaller<?>> hotSpotMarshallers;
        private final Map<Type, JNINativeMarshaller<?>> nativeMarshallers;
        private final Map<Class<? extends Annotation>, List<Pair<Class<?>, JNIHotSpotMarshaller<?>>>> annotationHotSpotMarshallers;
        private final Map<Class<? extends Annotation>, List<Pair<Class<?>, JNINativeMarshaller<?>>>> annotationNativeMarshallers;
        private LongUnaryOperator attachThreadAction = ATTACH_UNSUPPORTED;
        private LongUnaryOperator detachThreadAction = DETACH_UNSUPPORTED;
        private LongBinaryOperator shutDownIsolateAction = SHUTDOWN_UNSUPPORTED;
        private LongBinaryOperator releaseNativeObjectAction = RELEASE_UNSUPPORTED;

        Builder() {
            this.hotSpotMarshallers = new HashMap();
            this.nativeMarshallers = new HashMap();
            this.annotationHotSpotMarshallers = new HashMap();
            this.annotationNativeMarshallers = new HashMap();
        }

        public <T> Builder registerHotSpotMarshaller(Class<T> type, JNIHotSpotMarshaller<T> marshaller) {
            Objects.requireNonNull(type, "Type must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            this.hotSpotMarshallers.put(type, marshaller);
            return this;
        }

        public <T> Builder registerNativeMarshaller(Class<T> type, JNINativeMarshaller<T> marshaller) {
            Objects.requireNonNull(type, "Type must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            this.nativeMarshallers.put(type, marshaller);
            return this;
        }

        public <T> Builder registerHotSpotMarshaller(TypeLiteral<T> type, JNIHotSpotMarshaller<T> marshaller) {
            Objects.requireNonNull(type, "Type must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            this.hotSpotMarshallers.put(type.getType(), marshaller);
            return this;
        }

        public <T> Builder registerNativeMarshaller(TypeLiteral<T> type, JNINativeMarshaller<T> marshaller) {
            Objects.requireNonNull(type, "Type must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            this.nativeMarshallers.put(type.getType(), marshaller);
            return this;
        }

        public <T> Builder registerHotSpotMarshaller(Class<T> type, Class<? extends Annotation> annotationType, JNIHotSpotMarshaller<T> marshaller) {
            Objects.requireNonNull(type, "Type must be non null.");
            Objects.requireNonNull(annotationType, "AnnotationType must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            Builder.insert(this.annotationHotSpotMarshallers, type, annotationType, marshaller);
            return this;
        }

        public <T> Builder registerNativeMarshaller(Class<T> type, Class<? extends Annotation> annotationType, JNINativeMarshaller<T> marshaller) {
            Objects.requireNonNull(type, "Type must be non null.");
            Objects.requireNonNull(annotationType, "AnnotationType must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            Builder.insert(this.annotationNativeMarshallers, type, annotationType, marshaller);
            return this;
        }

        private static <T> void insert(Map<Class<? extends Annotation>, List<Pair<Class<?>, T>>> into, Class<?> type, Class<? extends Annotation> annotationType, T marshaller) {
            List types = into.computeIfAbsent(annotationType, k -> new LinkedList());
            Pair toInsert = Pair.create(type, marshaller);
            boolean inserted = false;
            ListIterator<Pair> it = types.listIterator();
            while (it.hasNext()) {
                Pair current = (Pair)it.next();
                if (!((Class)current.getLeft()).isAssignableFrom(type)) continue;
                it.set(toInsert);
                it.add(current);
                inserted = true;
                break;
            }
            if (!inserted) {
                types.add(toInsert);
            }
        }

        public Builder setAttachThreadAction(LongUnaryOperator action) {
            Objects.requireNonNull(action, "Action must be non null.");
            if (ImageInfo.inImageCode()) {
                throw new IllegalStateException("AttachThreadAction cannot be set in native image.");
            }
            this.attachThreadAction = action;
            return this;
        }

        public Builder setDetachThreadAction(LongUnaryOperator action) {
            Objects.requireNonNull(action, "Action must be non null.");
            if (ImageInfo.inImageCode()) {
                throw new IllegalStateException("DetachThreadAction cannot be set in native image.");
            }
            this.detachThreadAction = action;
            return this;
        }

        public Builder setShutDownIsolateAction(LongBinaryOperator action) {
            Objects.requireNonNull(action, "Action must be non null.");
            if (ImageInfo.inImageCode()) {
                throw new IllegalStateException("DetachThreadAction cannot be set in native image.");
            }
            this.shutDownIsolateAction = action;
            return this;
        }

        public Builder setReleaseNativeObjectAction(LongBinaryOperator action) {
            Objects.requireNonNull(action, "Action must be non null.");
            if (ImageInfo.inImageCode()) {
                throw new IllegalStateException("ReleaseNativeObjectAction cannot be set in native image.");
            }
            this.releaseNativeObjectAction = action;
            return this;
        }

        public JNIConfig build() {
            return new JNIConfig(this.hotSpotMarshallers, this.nativeMarshallers, this.annotationHotSpotMarshallers, this.annotationNativeMarshallers, this.attachThreadAction, this.detachThreadAction, this.shutDownIsolateAction, this.releaseNativeObjectAction);
        }
    }
}

