/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.amd64;

import java.util.function.IntConsumer;
import java.util.function.Supplier;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.options.OptionValues;

public class AMD64MacroAssembler
extends AMD64Assembler {
    public AMD64MacroAssembler(TargetDescription target) {
        super(target);
    }

    public AMD64MacroAssembler(TargetDescription target, OptionValues optionValues) {
        super(target, optionValues);
    }

    public AMD64MacroAssembler(TargetDescription target, OptionValues optionValues, boolean hasIntelJccErratum) {
        super(target, optionValues, hasIntelJccErratum);
    }

    public final void decrementq(Register reg) {
        this.decrementq(reg, 1);
    }

    public final void decrementq(Register reg, int value) {
        if (value == Integer.MIN_VALUE) {
            this.subq(reg, value);
            return;
        }
        if (value < 0) {
            this.incrementq(reg, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.decq(reg);
        } else {
            this.subq(reg, value);
        }
    }

    public final void decrementq(AMD64Address dst, int value) {
        if (value == Integer.MIN_VALUE) {
            this.subq(dst, value);
            return;
        }
        if (value < 0) {
            this.incrementq(dst, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.decq(dst);
        } else {
            this.subq(dst, value);
        }
    }

    public final void incrementq(Register reg) {
        this.incrementq(reg, 1);
    }

    public void incrementq(Register reg, int value) {
        if (value == Integer.MIN_VALUE) {
            this.addq(reg, value);
            return;
        }
        if (value < 0) {
            this.decrementq(reg, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.incq(reg);
        } else {
            this.addq(reg, value);
        }
    }

    public final void incrementq(AMD64Address dst, int value) {
        if (value == Integer.MIN_VALUE) {
            this.addq(dst, value);
            return;
        }
        if (value < 0) {
            this.decrementq(dst, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.incq(dst);
        } else {
            this.addq(dst, value);
        }
    }

    public final void movptr(Register dst, AMD64Address src) {
        this.movq(dst, src);
    }

    public final void movptr(AMD64Address dst, Register src) {
        this.movq(dst, src);
    }

    public final void movptr(AMD64Address dst, int src) {
        this.movslq(dst, src);
    }

    public final void cmpptr(Register src1, Register src2) {
        this.cmpq(src1, src2);
    }

    public final void cmpptr(Register src1, AMD64Address src2) {
        this.cmpq(src1, src2);
    }

    public final void decrementl(Register reg) {
        this.decrementl(reg, 1);
    }

    public final void decrementl(Register reg, int value) {
        if (value == Integer.MIN_VALUE) {
            this.subl(reg, value);
            return;
        }
        if (value < 0) {
            this.incrementl(reg, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.decl(reg);
        } else {
            this.subl(reg, value);
        }
    }

    public final void decrementl(AMD64Address dst, int value) {
        if (value == Integer.MIN_VALUE) {
            this.subl(dst, value);
            return;
        }
        if (value < 0) {
            this.incrementl(dst, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.decl(dst);
        } else {
            this.subl(dst, value);
        }
    }

    public final void incrementl(Register reg, int value) {
        if (value == Integer.MIN_VALUE) {
            this.addl(reg, value);
            return;
        }
        if (value < 0) {
            this.decrementl(reg, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.incl(reg);
        } else {
            this.addl(reg, value);
        }
    }

    public final void incrementl(AMD64Address dst, int value) {
        if (value == Integer.MIN_VALUE) {
            this.addl(dst, value);
            return;
        }
        if (value < 0) {
            this.decrementl(dst, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.incl(dst);
        } else {
            this.addl(dst, value);
        }
    }

    public void movflt(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM) && src.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(dst) || AMD64MacroAssembler.isAVX512Register(src)) {
            AMD64Assembler.VexMoveOp.VMOVAPS.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movaps(dst, src);
        }
    }

    public void movflt(Register dst, AMD64Address src) {
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(dst)) {
            AMD64Assembler.VexMoveOp.VMOVSS.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movss(dst, src);
        }
    }

    public void movflt(AMD64Address dst, Register src) {
        assert (src.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(src)) {
            AMD64Assembler.VexMoveOp.VMOVSS.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movss(dst, src);
        }
    }

    public void movdbl(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM) && src.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(dst) || AMD64MacroAssembler.isAVX512Register(src)) {
            AMD64Assembler.VexMoveOp.VMOVAPD.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movapd(dst, src);
        }
    }

    public void movdbl(Register dst, AMD64Address src) {
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(dst)) {
            AMD64Assembler.VexMoveOp.VMOVSD.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movsd(dst, src);
        }
    }

    public void movdbl(AMD64Address dst, Register src) {
        assert (src.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(src)) {
            AMD64Assembler.VexMoveOp.VMOVSD.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movsd(dst, src);
        }
    }

    public final void movlong(AMD64Address dst, long src) {
        if (NumUtil.isInt(src)) {
            AMD64Assembler.AMD64MIOp.MOV.emit((AMD64Assembler)this, AMD64BaseAssembler.OperandSize.QWORD, dst, (int)src);
        } else {
            AMD64Address high = new AMD64Address(dst.getBase(), dst.getIndex(), dst.getScale(), dst.getDisplacement() + 4, dst.getDisplacementAnnotation(), dst.instructionStartPosition);
            this.movl(dst, (int)(src & 0xFFFFFFFFFFFFFFFFL));
            this.movl(high, (int)(src >> 32));
        }
    }

    public final void setl(AMD64Assembler.ConditionFlag cc, Register dst) {
        this.setb(cc, dst);
        this.movzbl(dst, dst);
    }

    public final void setq(AMD64Assembler.ConditionFlag cc, Register dst) {
        this.setb(cc, dst);
        this.movzbq(dst, dst);
    }

    public final void flog(Register dest, Register value, boolean base10, AMD64Address tmp) {
        if (base10) {
            this.fldlg2();
        } else {
            this.fldln2();
        }
        this.trigPrologue(value, tmp);
        this.fyl2x();
        this.trigEpilogue(dest, tmp);
    }

    public final void fsin(Register dest, Register value, AMD64Address tmp) {
        this.trigPrologue(value, tmp);
        this.fsin();
        this.trigEpilogue(dest, tmp);
    }

    public final void fcos(Register dest, Register value, AMD64Address tmp) {
        this.trigPrologue(value, tmp);
        this.fcos();
        this.trigEpilogue(dest, tmp);
    }

    public final void ftan(Register dest, Register value, AMD64Address tmp) {
        this.trigPrologue(value, tmp);
        this.fptan();
        this.fstp(0);
        this.trigEpilogue(dest, tmp);
    }

    public final void fpop() {
        this.ffree(0);
        this.fincstp();
    }

    private void trigPrologue(Register value, AMD64Address tmp) {
        assert (value.getRegisterCategory().equals((Object)AMD64.XMM));
        this.movdbl(tmp, value);
        this.fldd(tmp);
    }

    private void trigEpilogue(Register dest, AMD64Address tmp) {
        assert (dest.getRegisterCategory().equals((Object)AMD64.XMM));
        this.fstpd(tmp);
        this.movdbl(dest, tmp);
    }

    public final int directCall(boolean align) {
        this.emitAlignmentForDirectCall(align);
        if (this.mitigateJCCErratum(5) != 0) {
            this.emitAlignmentForDirectCall(align);
        }
        int callPos = this.position();
        this.call();
        return callPos;
    }

    private void emitAlignmentForDirectCall(boolean align) {
        int displacementPos;
        if (align && (displacementPos = this.position() + this.target.arch.getMachineCodeCallDisplacementOffset()) % 4 != 0) {
            this.nop(4 - displacementPos % 4);
        }
    }

    public final int indirectCall(Register callReg) {
        int bytesToEmit = AMD64MacroAssembler.needsRex(callReg) ? 3 : 2;
        this.mitigateJCCErratum(bytesToEmit);
        int beforeCall = this.position();
        this.call(callReg);
        assert (beforeCall + bytesToEmit == this.position());
        return beforeCall;
    }

    public final int directCall(long address, Register scratch) {
        int bytesToEmit = AMD64MacroAssembler.needsRex(scratch) ? 13 : 12;
        this.mitigateJCCErratum(bytesToEmit);
        int beforeCall = this.position();
        this.movq(scratch, address);
        this.call(scratch);
        assert (beforeCall + bytesToEmit == this.position());
        return beforeCall;
    }

    public final int directJmp(long address, Register scratch) {
        int bytesToEmit = AMD64MacroAssembler.needsRex(scratch) ? 13 : 12;
        this.mitigateJCCErratum(bytesToEmit);
        int beforeJmp = this.position();
        this.movq(scratch, address);
        this.jmpWithoutAlignment(scratch);
        assert (beforeJmp + bytesToEmit == this.position());
        return beforeJmp;
    }

    private void alignFusedPair(Label branchTarget, boolean isShortJmp, int prevOpInBytes) {
        assert (prevOpInBytes < 26) : "Fused pair may be longer than 0x20 bytes.";
        if (branchTarget == null) {
            this.mitigateJCCErratum(prevOpInBytes + 6);
        } else if (isShortJmp) {
            this.mitigateJCCErratum(prevOpInBytes + 2);
        } else if (!branchTarget.isBound()) {
            this.mitigateJCCErratum(prevOpInBytes + 6);
        } else {
            long disp = branchTarget.position() - (this.position() + prevOpInBytes);
            if (NumUtil.isByte(disp - 2L)) {
                this.mitigateJCCErratum(prevOpInBytes + 2);
                disp = branchTarget.position() - (this.position() + prevOpInBytes);
                if (NumUtil.isByte(disp - 2L)) {
                    return;
                }
            }
            this.mitigateJCCErratum(prevOpInBytes + 6);
        }
    }

    private void applyMIOpAndJcc(AMD64Assembler.AMD64MIOp op, AMD64BaseAssembler.OperandSize size, Register src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp, boolean annotateImm, IntConsumer applyBeforeFusedPair) {
        int bytesToEmit = AMD64MacroAssembler.getPrefixInBytes(size, src, op.srcIsByte) + 1 + 1 + op.immediateSize(size);
        this.alignFusedPair(branchTarget, isShortJmp, bytesToEmit);
        int beforeFusedPair = this.position();
        if (applyBeforeFusedPair != null) {
            applyBeforeFusedPair.accept(beforeFusedPair);
        }
        op.emit((AMD64Assembler)this, size, src, imm32, annotateImm);
        assert (beforeFusedPair + bytesToEmit == this.position());
        this.jcc(cc, branchTarget, isShortJmp);
        assert (this.ensureWithinBoundary(beforeFusedPair));
    }

    private void applyMIOpAndJcc(AMD64Assembler.AMD64MIOp op, AMD64BaseAssembler.OperandSize size, AMD64Address src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp, boolean annotateImm, IntConsumer applyBeforeFusedPair) {
        int bytesToEmit = AMD64MacroAssembler.getPrefixInBytes(size, src) + 1 + AMD64MacroAssembler.addressInBytes(src) + op.immediateSize(size);
        this.alignFusedPair(branchTarget, isShortJmp, bytesToEmit);
        int beforeFusedPair = this.position();
        if (applyBeforeFusedPair != null) {
            applyBeforeFusedPair.accept(beforeFusedPair);
        }
        op.emit((AMD64Assembler)this, size, src, imm32, annotateImm);
        assert (beforeFusedPair + bytesToEmit == this.position());
        this.jcc(cc, branchTarget, isShortJmp);
        assert (this.ensureWithinBoundary(beforeFusedPair));
    }

    private int applyRMOpAndJcc(AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, Register src1, Register src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        int bytesToEmit = AMD64MacroAssembler.getPrefixInBytes(size, src1, op.dstIsByte, src2, op.srcIsByte) + 1 + 1;
        this.alignFusedPair(branchTarget, isShortJmp, bytesToEmit);
        int beforeFusedPair = this.position();
        op.emit((AMD64Assembler)this, size, src1, src2);
        int beforeJcc = this.position();
        assert (beforeFusedPair + bytesToEmit == beforeJcc);
        this.jcc(cc, branchTarget, isShortJmp);
        assert (this.ensureWithinBoundary(beforeFusedPair));
        return beforeJcc;
    }

    private int applyRMOpAndJcc(AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, Register src1, AMD64Address src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp, IntConsumer applyBeforeFusedPair) {
        int bytesToEmit = AMD64MacroAssembler.getPrefixInBytes(size, src1, op.dstIsByte, src2) + 1 + AMD64MacroAssembler.addressInBytes(src2);
        this.alignFusedPair(branchTarget, isShortJmp, bytesToEmit);
        int beforeFusedPair = this.position();
        if (applyBeforeFusedPair != null) {
            applyBeforeFusedPair.accept(beforeFusedPair);
        }
        op.emit((AMD64Assembler)this, size, src1, src2);
        int beforeJcc = this.position();
        assert (beforeFusedPair + bytesToEmit == beforeJcc);
        this.jcc(cc, branchTarget, isShortJmp);
        assert (this.ensureWithinBoundary(beforeFusedPair));
        return beforeJcc;
    }

    public void applyMOpAndJcc(AMD64Assembler.AMD64MOp op, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        int bytesToEmit = AMD64MacroAssembler.getPrefixInBytes(size, dst, op.srcIsByte) + 1 + 1;
        this.alignFusedPair(branchTarget, isShortJmp, bytesToEmit);
        int beforeFusedPair = this.position();
        op.emit((AMD64Assembler)this, size, dst);
        assert (beforeFusedPair + bytesToEmit == this.position());
        this.jcc(cc, branchTarget, isShortJmp);
        assert (this.ensureWithinBoundary(beforeFusedPair));
    }

    public final void testAndJcc(AMD64BaseAssembler.OperandSize size, Register src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64MIOp.TEST, size, src, imm32, cc, branchTarget, isShortJmp, false, null);
    }

    public final void testlAndJcc(Register src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64MIOp.TEST, AMD64BaseAssembler.OperandSize.DWORD, src, imm32, cc, branchTarget, isShortJmp, false, null);
    }

    public final void testAndJcc(AMD64BaseAssembler.OperandSize size, AMD64Address src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp, IntConsumer applyBeforeFusedPair) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64MIOp.TEST, size, src, imm32, cc, branchTarget, isShortJmp, false, applyBeforeFusedPair);
    }

    public final void testAndJcc(AMD64BaseAssembler.OperandSize size, Register src1, Register src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64RMOp.TEST, size, src1, src2, cc, branchTarget, isShortJmp);
    }

    public final void testlAndJcc(Register src1, Register src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64RMOp.TEST, AMD64BaseAssembler.OperandSize.DWORD, src1, src2, cc, branchTarget, isShortJmp);
    }

    public final int testqAndJcc(Register src1, Register src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        return this.applyRMOpAndJcc(AMD64Assembler.AMD64RMOp.TEST, AMD64BaseAssembler.OperandSize.QWORD, src1, src2, cc, branchTarget, isShortJmp);
    }

    public final void testAndJcc(AMD64BaseAssembler.OperandSize size, Register src1, AMD64Address src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp, IntConsumer applyBeforeFusedPair) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64RMOp.TEST, size, src1, src2, cc, branchTarget, isShortJmp, applyBeforeFusedPair);
    }

    public final void testbAndJcc(Register src1, Register src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64RMOp.TESTB, AMD64BaseAssembler.OperandSize.BYTE, src1, src2, cc, branchTarget, isShortJmp);
    }

    public final void testbAndJcc(Register src1, AMD64Address src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64RMOp.TESTB, AMD64BaseAssembler.OperandSize.BYTE, src1, src2, cc, branchTarget, isShortJmp, null);
    }

    public final void cmpAndJcc(AMD64BaseAssembler.OperandSize size, Register src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp, boolean annotateImm, IntConsumer applyBeforeFusedPair) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getMIOpcode(size, NumUtil.isByte(imm32)), size, src, imm32, cc, branchTarget, isShortJmp, annotateImm, applyBeforeFusedPair);
    }

    public final void cmplAndJcc(Register src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)), AMD64BaseAssembler.OperandSize.DWORD, src, imm32, cc, branchTarget, isShortJmp, false, null);
    }

    public final void cmpqAndJcc(Register src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)), AMD64BaseAssembler.OperandSize.QWORD, src, imm32, cc, branchTarget, isShortJmp, false, null);
    }

    public final void cmpAndJcc(AMD64BaseAssembler.OperandSize size, AMD64Address src, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp, boolean annotateImm, IntConsumer applyBeforeFusedPair) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getMIOpcode(size, NumUtil.isByte(imm32)), size, src, imm32, cc, branchTarget, isShortJmp, annotateImm, applyBeforeFusedPair);
    }

    public final void cmpAndJcc(AMD64BaseAssembler.OperandSize size, Register src1, Register src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(size), size, src1, src2, cc, branchTarget, isShortJmp);
    }

    public final void cmplAndJcc(Register src1, Register src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(AMD64BaseAssembler.OperandSize.DWORD), AMD64BaseAssembler.OperandSize.DWORD, src1, src2, cc, branchTarget, isShortJmp);
    }

    public final int cmpqAndJcc(Register src1, Register src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        return this.applyRMOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(AMD64BaseAssembler.OperandSize.QWORD), AMD64BaseAssembler.OperandSize.QWORD, src1, src2, cc, branchTarget, isShortJmp);
    }

    public final void cmpAndJcc(AMD64BaseAssembler.OperandSize size, Register src1, AMD64Address src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp, IntConsumer applyBeforeFusedPair) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(size), size, src1, src2, cc, branchTarget, isShortJmp, applyBeforeFusedPair);
    }

    public final void cmplAndJcc(Register src1, AMD64Address src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(AMD64BaseAssembler.OperandSize.DWORD), AMD64BaseAssembler.OperandSize.DWORD, src1, src2, cc, branchTarget, isShortJmp, null);
    }

    public final int cmpqAndJcc(Register src1, AMD64Address src2, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        return this.applyRMOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(AMD64BaseAssembler.OperandSize.QWORD), AMD64BaseAssembler.OperandSize.QWORD, src1, src2, cc, branchTarget, isShortJmp, null);
    }

    public final void cmpAndJcc(AMD64BaseAssembler.OperandSize size, Register src1, Supplier<AMD64Address> src2, AMD64Assembler.ConditionFlag cc, Label branchTarget) {
        AMD64Address placeHolder = this.getPlaceholder(this.position());
        AMD64Assembler.AMD64RMOp op = AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(size);
        int bytesToEmit = AMD64MacroAssembler.getPrefixInBytes(size, src1, op.dstIsByte, placeHolder) + 1 + AMD64MacroAssembler.addressInBytes(placeHolder);
        this.alignFusedPair(branchTarget, false, bytesToEmit);
        int beforeFusedPair = this.position();
        AMD64Address src2AsAddress = src2.get();
        op.emit((AMD64Assembler)this, size, src1, src2AsAddress);
        assert (beforeFusedPair + bytesToEmit == this.position());
        this.jcc(cc, branchTarget, false);
        assert (this.ensureWithinBoundary(beforeFusedPair));
    }

    public final void andlAndJcc(Register dst, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.AND.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)), AMD64BaseAssembler.OperandSize.DWORD, dst, imm32, cc, branchTarget, isShortJmp, false, null);
    }

    public final void addqAndJcc(Register dst, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)), AMD64BaseAssembler.OperandSize.QWORD, dst, imm32, cc, branchTarget, isShortJmp, false, null);
    }

    public final void sublAndJcc(Register dst, Register src, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.SUB.getRMOpcode(AMD64BaseAssembler.OperandSize.DWORD), AMD64BaseAssembler.OperandSize.DWORD, dst, src, cc, branchTarget, isShortJmp);
    }

    public final void subqAndJcc(Register dst, Register src, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyRMOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.SUB.getRMOpcode(AMD64BaseAssembler.OperandSize.QWORD), AMD64BaseAssembler.OperandSize.QWORD, dst, src, cc, branchTarget, isShortJmp);
    }

    public final void sublAndJcc(Register dst, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)), AMD64BaseAssembler.OperandSize.DWORD, dst, imm32, cc, branchTarget, isShortJmp, false, null);
    }

    public final void subqAndJcc(Register dst, int imm32, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMIOpAndJcc(AMD64Assembler.AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)), AMD64BaseAssembler.OperandSize.QWORD, dst, imm32, cc, branchTarget, isShortJmp, false, null);
    }

    public final void incqAndJcc(Register dst, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMOpAndJcc(AMD64Assembler.AMD64MOp.INC, AMD64BaseAssembler.OperandSize.QWORD, dst, cc, branchTarget, isShortJmp);
    }

    public final void decqAndJcc(Register dst, AMD64Assembler.ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        this.applyMOpAndJcc(AMD64Assembler.AMD64MOp.DEC, AMD64BaseAssembler.OperandSize.QWORD, dst, cc, branchTarget, isShortJmp);
    }
}

