/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import org.graalvm.compiler.core.common.alloc.Trace;
import org.graalvm.compiler.core.common.alloc.TraceBuilderResult;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;

public final class BiDirectionalTraceBuilder {
    private final Deque<AbstractBlockBase<?>> worklist;
    private final BitSet processed;
    private final Trace[] blockToTrace;

    public static TraceBuilderResult computeTraces(DebugContext debug, AbstractBlockBase<?> startBlock, AbstractBlockBase<?>[] blocks, TraceBuilderResult.TrivialTracePredicate pred) {
        return new BiDirectionalTraceBuilder(blocks).build(debug, startBlock, blocks, pred);
    }

    private BiDirectionalTraceBuilder(AbstractBlockBase<?>[] blocks) {
        this.processed = new BitSet(blocks.length);
        this.worklist = BiDirectionalTraceBuilder.createQueue(blocks);
        this.blockToTrace = new Trace[blocks.length];
    }

    private static Deque<AbstractBlockBase<?>> createQueue(AbstractBlockBase<?>[] blocks) {
        ArrayList queue = new ArrayList(Arrays.asList(blocks));
        queue.sort(BiDirectionalTraceBuilder::compare);
        return new ArrayDeque(queue);
    }

    private static int compare(AbstractBlockBase<?> a, AbstractBlockBase<?> b) {
        return Double.compare(b.getRelativeFrequency(), a.getRelativeFrequency());
    }

    private boolean processed(AbstractBlockBase<?> b) {
        return this.processed.get(b.getId());
    }

    private TraceBuilderResult build(DebugContext debug, AbstractBlockBase<?> startBlock, AbstractBlockBase<?>[] blocks, TraceBuilderResult.TrivialTracePredicate pred) {
        try (Indent indent = debug.logAndIndent("BiDirectionalTraceBuilder: start trace building");){
            ArrayList<Trace> traces = this.buildTraces(debug);
            assert (traces.get(0).getBlocks()[0].equals(startBlock)) : "The first traces always contains the start block";
            TraceBuilderResult traceBuilderResult = TraceBuilderResult.create(debug, blocks, traces, this.blockToTrace, pred);
            return traceBuilderResult;
        }
    }

    protected ArrayList<Trace> buildTraces(DebugContext debug) {
        ArrayList<Trace> traces = new ArrayList<Trace>();
        while (!this.worklist.isEmpty()) {
            AbstractBlockBase<?> block = this.worklist.pollFirst();
            assert (block != null);
            if (this.processed(block)) continue;
            Trace trace = new Trace(this.findTrace(debug, block));
            for (AbstractBlockBase<?> traceBlock : trace.getBlocks()) {
                this.blockToTrace[traceBlock.getId()] = trace;
            }
            trace.setId(traces.size());
            traces.add(trace);
        }
        return traces;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<AbstractBlockBase<?>> findTrace(DebugContext debug, AbstractBlockBase<?> initBlock) {
        ArrayDeque trace = new ArrayDeque();
        try (Indent i = debug.logAndIndent("StartTrace: %s", initBlock);){
            Indent indentFront = debug.logAndIndent("Head:");
            Object object = null;
            try {
                void var8_12;
                AbstractBlockBase<?> abstractBlockBase = initBlock;
                while (var8_12 != null) {
                    this.addBlockToTrace(debug, (AbstractBlockBase<?>)var8_12);
                    trace.addFirst((AbstractBlockBase<?>)var8_12);
                    AbstractBlockBase<?> abstractBlockBase2 = this.selectPredecessor((AbstractBlockBase<?>)var8_12);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (indentFront != null) {
                    if (object != null) {
                        try {
                            indentFront.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        indentFront.close();
                    }
                }
            }
            int blockNr = 0;
            for (AbstractBlockBase abstractBlockBase : trace) {
                abstractBlockBase.setLinearScanNumber(blockNr++);
            }
            Throwable throwable = null;
            try (Indent indentBack = debug.logAndIndent("Tail:");){
                AbstractBlockBase<?> block = this.selectSuccessor(initBlock);
                while (block != null) {
                    this.addBlockToTrace(debug, block);
                    trace.addLast(block);
                    block.setLinearScanNumber(blockNr++);
                    block = this.selectSuccessor(block);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        debug.log("Trace: %s", trace);
        return trace;
    }

    private void addBlockToTrace(DebugContext debug, AbstractBlockBase<?> block) {
        debug.log("add %s (freq: %f)", block, (Object)block.getRelativeFrequency());
        this.processed.set(block.getId());
    }

    private AbstractBlockBase<?> selectPredecessor(AbstractBlockBase<?> block) {
        AbstractBlockBase next = null;
        for (AbstractBlockBase pred : block.getPredecessors()) {
            if (this.processed(pred) || BiDirectionalTraceBuilder.isBackEdge(pred, block) || next != null && !(pred.getRelativeFrequency() > next.getRelativeFrequency())) continue;
            next = pred;
        }
        return next;
    }

    private static boolean isBackEdge(AbstractBlockBase<?> from, AbstractBlockBase<?> to) {
        assert (Arrays.asList(from.getSuccessors()).contains(to)) : "No edge from " + from + " to " + to;
        return from.isLoopEnd() && to.isLoopHeader() && from.getLoop().equals(to.getLoop());
    }

    private AbstractBlockBase<?> selectSuccessor(AbstractBlockBase<?> block) {
        AbstractBlockBase next = null;
        for (AbstractBlockBase succ : block.getSuccessors()) {
            if (this.processed(succ) || next != null && !(succ.getRelativeFrequency() > next.getRelativeFrequency())) continue;
            next = succ;
        }
        return next;
    }
}

