/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import java.nio.ByteBuffer;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.core.common.util.AlignedUnsafeArrayTypeWriter;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.TypeWriter;
import org.graalvm.compiler.core.common.util.UnalignedUnsafeArrayTypeWriter;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public abstract class UnsafeArrayTypeWriter
implements TypeWriter {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private static final int MIN_CHUNK_LENGTH = 200;
    private static final int MAX_CHUNK_LENGTH = 16000;
    public static final long HIGH_WORD_SHIFT = 6L;
    public static final long NUM_HIGH_CODES = 64L;
    public static final long NUM_LOW_CODES = 192L;
    public static final long MAX_BYTES = 11L;
    protected final Chunk firstChunk;
    protected Chunk writeChunk;
    protected int totalSize;

    public static UnsafeArrayTypeWriter create(boolean supportsUnalignedMemoryAccess) {
        if (supportsUnalignedMemoryAccess) {
            return new UnalignedUnsafeArrayTypeWriter();
        }
        return new AlignedUnsafeArrayTypeWriter();
    }

    protected UnsafeArrayTypeWriter() {
        this.writeChunk = this.firstChunk = new Chunk(200);
    }

    @Override
    public final long getBytesWritten() {
        return this.totalSize;
    }

    public final byte[] toArray(byte[] result) {
        assert (result.length == this.totalSize);
        int resultIdx = 0;
        Chunk cur = this.firstChunk;
        while (cur != null) {
            System.arraycopy(cur.data, 0, result, resultIdx, cur.size);
            resultIdx += cur.size;
            cur = cur.next;
        }
        assert (resultIdx == this.totalSize);
        return result;
    }

    public final ByteBuffer toByteBuffer(ByteBuffer buffer) {
        assert (buffer.remaining() <= this.totalSize);
        int initialPos = buffer.position();
        Chunk cur = this.firstChunk;
        while (cur != null) {
            buffer.put(cur.data, 0, cur.size);
            cur = cur.next;
        }
        assert (buffer.position() - initialPos == this.totalSize);
        return buffer;
    }

    public final byte[] toArray() {
        byte[] result = new byte[TypeConversion.asS4(this.getBytesWritten())];
        return this.toArray(result);
    }

    @Override
    public final void putS1(long value) {
        long offset = this.writeOffset(1);
        UNSAFE.putByte(this.writeChunk.data, offset, TypeConversion.asS1(value));
    }

    @Override
    public final void putU1(long value) {
        long offset = this.writeOffset(1);
        UNSAFE.putByte(this.writeChunk.data, offset, TypeConversion.asU1(value));
    }

    @Override
    public final void putU2(long value) {
        this.putS2(TypeConversion.asU2(value));
    }

    @Override
    public final void putU4(long value) {
        this.putS4(TypeConversion.asU4(value));
    }

    @Override
    public void putS2(long value) {
        long offset = this.writeOffset(2);
        this.putS2(value, this.writeChunk, offset);
    }

    @Override
    public void putS4(long value) {
        long offset = this.writeOffset(4);
        this.putS4(value, this.writeChunk, offset);
    }

    @Override
    public void putS8(long value) {
        long offset = this.writeOffset(8);
        this.putS8(value, this.writeChunk, offset);
    }

    protected abstract void putS2(long var1, Chunk var3, long var4);

    protected abstract void putS4(long var1, Chunk var3, long var4);

    protected abstract void putS8(long var1, Chunk var3, long var4);

    protected long writeOffset(int writeBytes) {
        if (this.writeChunk.size + writeBytes >= this.writeChunk.data.length) {
            Chunk newChunk;
            this.writeChunk.next = newChunk = new Chunk(Math.min(this.writeChunk.data.length * 2, 16000));
            this.writeChunk = newChunk;
        }
        assert (Unsafe.ARRAY_BYTE_INDEX_SCALE == 1);
        long result = this.writeChunk.size + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        this.totalSize += writeBytes;
        this.writeChunk.size += writeBytes;
        assert (this.writeChunk.size <= this.writeChunk.data.length);
        return result;
    }

    @Override
    public void patchS4(long value, long offset) {
        long chunkStartOffset = 0L;
        Chunk chunk = this.firstChunk;
        while (chunkStartOffset + (long)chunk.size <= offset) {
            chunkStartOffset += (long)chunk.size;
            chunk = chunk.next;
        }
        long targetOffset = offset - chunkStartOffset;
        assert (targetOffset + 4L <= (long)chunk.size) : "out of bounds";
        this.putS4(value, chunk, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + targetOffset);
    }

    @Override
    public void putSV(long value) {
        this.write(UnsafeArrayTypeWriter.encodeSign(value));
    }

    @Override
    public void putUV(long value) {
        this.write(value);
    }

    private static long encodeSign(long value) {
        return value << 1 ^ value >> 63;
    }

    private void write(long value) {
        if (UnsignedMath.belowThan(value, 192L)) {
            this.putU1(value);
        } else {
            this.writePacked(value);
        }
    }

    private void writePacked(long value) {
        long sum = value;
        int i = 1;
        while (UnsignedMath.aboveOrEqual(sum, 192L) && (long)i < 11L) {
            long u1 = 192L + ((sum -= 192L) & 0x3FL);
            sum >>>= 6;
            this.putU1(u1);
            ++i;
        }
        assert (sum == (sum & 0xFFL)) : "not a byte";
        this.putU1(sum & 0xFFL);
    }

    static class Chunk {
        protected final byte[] data;
        protected int size;
        protected Chunk next;

        protected Chunk(int arrayLength) {
            this.data = new byte[arrayLength];
        }
    }
}

