/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.CausableByCompilerAssert;
import org.graalvm.compiler.debug.DebugConfig;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpHandler;
import org.graalvm.compiler.debug.DebugFilter;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.DebugVerifyHandler;
import org.graalvm.compiler.debug.MethodFilter;
import org.graalvm.compiler.debug.ScopeImpl;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.OptionValues;

final class DebugConfigImpl
implements DebugConfig {
    private final OptionValues options;
    private final DebugFilter countFilter;
    private final DebugFilter logFilter;
    private final DebugFilter trackMemUseFilter;
    private final DebugFilter timerFilter;
    private final DebugFilter dumpFilter;
    private final DebugFilter verifyFilter;
    private final MethodFilter methodFilter;
    private final List<DebugDumpHandler> dumpHandlers;
    private final List<DebugVerifyHandler> verifyHandlers;
    private final PrintStream output;

    DebugConfigImpl(OptionValues options) {
        this(options, TTY.out, Collections.emptyList(), Collections.emptyList());
    }

    DebugConfigImpl(OptionValues options, PrintStream output, List<DebugDumpHandler> dumpHandlers, List<DebugVerifyHandler> verifyHandlers) {
        this(options, DebugOptions.Log.getValue(options), DebugOptions.Count.getValue(options), DebugOptions.TrackMemUse.getValue(options), DebugOptions.Time.getValue(options), DebugOptions.Dump.getValue(options), DebugConfigImpl.getVerifyOptionValue(options), DebugOptions.MethodFilter.getValue(options), output, dumpHandlers, verifyHandlers);
    }

    DebugConfigImpl(OptionValues options, String logFilter, String countFilter, String trackMemUseFilter, String timerFilter, String dumpFilter, String verifyFilter, String methodFilter, PrintStream output, List<DebugDumpHandler> dumpHandlers, List<DebugVerifyHandler> verifyHandlers) {
        this.options = options;
        this.logFilter = DebugFilter.parse(logFilter);
        this.countFilter = DebugFilter.parse(countFilter);
        this.trackMemUseFilter = DebugFilter.parse(trackMemUseFilter);
        this.timerFilter = DebugFilter.parse(timerFilter);
        this.dumpFilter = DebugFilter.parse(dumpFilter);
        this.verifyFilter = DebugFilter.parse(verifyFilter);
        this.methodFilter = methodFilter == null || methodFilter.isEmpty() ? null : MethodFilter.parse(methodFilter);
        this.dumpHandlers = Collections.unmodifiableList(dumpHandlers);
        this.verifyHandlers = Collections.unmodifiableList(verifyHandlers);
        this.output = output;
    }

    private static String getVerifyOptionValue(OptionValues values) {
        return !DebugOptions.Verify.hasBeenSet(values) && Assertions.assertionsEnabled() ? "" : DebugOptions.Verify.getValue(values);
    }

    @Override
    public OptionValues getOptions() {
        return this.options;
    }

    @Override
    public int getLogLevel(DebugContext.Scope scope) {
        return this.getLevel(scope, this.logFilter);
    }

    @Override
    public boolean isLogEnabledForMethod(DebugContext.Scope scope) {
        return this.isEnabledForMethod(scope, this.logFilter);
    }

    @Override
    public boolean isCountEnabled(DebugContext.Scope scope) {
        return this.isEnabled(scope, this.countFilter);
    }

    @Override
    public boolean isMemUseTrackingEnabled(DebugContext.Scope scope) {
        return this.isEnabled(scope, this.trackMemUseFilter);
    }

    @Override
    public int getDumpLevel(DebugContext.Scope scope) {
        return this.getLevel(scope, this.dumpFilter);
    }

    @Override
    public boolean isDumpEnabledForMethod(DebugContext.Scope scope) {
        return this.isEnabledForMethod(scope, this.dumpFilter);
    }

    @Override
    public boolean isVerifyEnabled(DebugContext.Scope scope) {
        return this.isEnabled(scope, this.verifyFilter);
    }

    @Override
    public boolean isVerifyEnabledForMethod(DebugContext.Scope scope) {
        return this.isEnabledForMethod(scope, this.verifyFilter);
    }

    @Override
    public boolean isTimeEnabled(DebugContext.Scope scope) {
        return this.isEnabled(scope, this.timerFilter);
    }

    @Override
    public PrintStream output() {
        return this.output;
    }

    private boolean isEnabled(DebugContext.Scope scope, DebugFilter filter) {
        return this.getLevel(scope, filter) > 0;
    }

    private int getLevel(DebugContext.Scope scope, DebugFilter filter) {
        int level;
        if (filter == null) {
            level = 0;
        } else {
            String currentScope = scope.getQualifiedName();
            level = filter.matchLevel(currentScope);
        }
        if (level >= 0 && !this.checkMethodFilter(scope)) {
            level = -1;
        }
        return level;
    }

    private boolean isEnabledForMethod(DebugContext.Scope scope, DebugFilter filter) {
        return filter != null && this.checkMethodFilter(scope);
    }

    private boolean checkMethodFilter(DebugContext.Scope scope) {
        if (this.methodFilter == null) {
            return true;
        }
        JavaMethod lastMethod = null;
        Iterable<Object> context = scope.getCurrentContext();
        for (Object o : context) {
            JavaMethod method;
            if (this.methodFilter == null || (method = DebugConfig.asJavaMethod(o)) == null) continue;
            if (!DebugOptions.MethodFilterRootOnly.getValue(this.options).booleanValue()) {
                if (!this.methodFilter.matches(method)) continue;
                return true;
            }
            lastMethod = method;
        }
        return lastMethod != null && this.methodFilter.matches(lastMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Debug config:");
        DebugConfigImpl.add(sb, "Log", this.logFilter);
        DebugConfigImpl.add(sb, "Count", this.countFilter);
        DebugConfigImpl.add(sb, "Time", this.timerFilter);
        DebugConfigImpl.add(sb, "Dump", this.dumpFilter);
        DebugConfigImpl.add(sb, "MethodFilter", this.methodFilter);
        return sb.toString();
    }

    private static void add(StringBuilder sb, String name, Object filter) {
        if (filter != null) {
            sb.append(' ');
            sb.append(name);
            sb.append('=');
            if (filter instanceof Object[]) {
                sb.append(Arrays.toString((Object[])filter));
            } else {
                sb.append(String.valueOf(filter));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeException interceptException(DebugContext debug, Throwable e) {
        if (e instanceof BailoutException) {
            boolean causedByCompilerAssert;
            boolean bl = causedByCompilerAssert = e instanceof CausableByCompilerAssert && ((CausableByCompilerAssert)((Object)e)).isCausedByCompilerAssert();
            if (!DebugOptions.InterceptBailout.getValue(this.options).booleanValue() && !causedByCompilerAssert) {
                return null;
            }
        }
        OptionValues interceptOptions = new OptionValues(this.options, DebugOptions.Count, null, DebugOptions.Time, null, DebugOptions.TrackMemUse, null, DebugOptions.Verify, null, DebugOptions.Dump, ":1", DebugOptions.Log, ":1");
        DebugConfigImpl config = new DebugConfigImpl(interceptOptions, this.output, this.dumpHandlers, this.verifyHandlers);
        ScopeImpl scope = debug.currentScope;
        scope.updateFlags(config);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(baos));
            debug.log("Exception raised in scope %s: %s", (Object)debug.getCurrentScopeName(), (Object)baos);
            IdentityHashMap<Object, Object> firstSeen = new IdentityHashMap<Object, Object>();
            for (Object o : debug.context()) {
                if (firstSeen.containsKey(o)) continue;
                firstSeen.put(o, o);
                if (DebugOptions.DumpOnError.getValue(this.options).booleanValue() || DebugOptions.Dump.getValue(this.options) != null) {
                    debug.forceDump(o, "Exception: %s", e);
                }
                debug.log("Context obj %s", o);
            }
        }
        finally {
            scope.updateFlags(this);
        }
        return null;
    }

    @Override
    public Collection<DebugDumpHandler> dumpHandlers() {
        return this.dumpHandlers;
    }

    @Override
    public Collection<DebugVerifyHandler> verifyHandlers() {
        return this.verifyHandlers;
    }
}

