/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

class CompilationCounters {
    private final OptionValues options;
    private final Map<ResolvedJavaMethod, Integer> counters = new HashMap<ResolvedJavaMethod, Integer>();

    CompilationCounters(OptionValues options) {
        TTY.println("Warning: Compilation counters enabled, excessive recompilation of a method will cause a failure!");
        this.options = options;
    }

    synchronized void countCompilation(ResolvedJavaMethod method) {
        Integer val = this.counters.get(method);
        val = val != null ? val + 1 : 1;
        this.counters.put(method, val);
        if (val > Options.CompilationCountLimit.getValue(this.options)) {
            TTY.printf("Error. Method %s was compiled too many times. Number of compilations: %d\n", HotSpotGraalCompiler.fmt(method), Options.CompilationCountLimit.getValue(this.options));
            TTY.println("==================================== High compilation counters ====================================");
            TreeSet<Map.Entry<ResolvedJavaMethod, Integer>> sortedCounters = new TreeSet<Map.Entry<ResolvedJavaMethod, Integer>>(new CounterComparator());
            for (Map.Entry<ResolvedJavaMethod, Integer> entry : this.counters.entrySet()) {
                sortedCounters.add(entry);
            }
            for (Map.Entry<Object, Integer> entry : sortedCounters) {
                if (entry.getValue() < Options.CompilationCountLimit.getValue(this.options) / 2) continue;
                TTY.out.printf("%d\t%s%n", entry.getValue(), HotSpotGraalCompiler.str((JavaMethod)entry.getKey()));
            }
            TTY.flush();
            HotSpotGraalServices.exit(-1, HotSpotJVMCIRuntime.runtime());
        }
    }

    static final class CounterComparator
    implements Comparator<Map.Entry<ResolvedJavaMethod, Integer>> {
        CounterComparator() {
        }

        @Override
        public int compare(Map.Entry<ResolvedJavaMethod, Integer> o1, Map.Entry<ResolvedJavaMethod, Integer> o2) {
            if (o1.getValue() < o2.getValue()) {
                return -1;
            }
            if (o1.getValue() > o2.getValue()) {
                return 1;
            }
            return HotSpotGraalCompiler.str((JavaMethod)o1.getKey()).compareTo(HotSpotGraalCompiler.str((JavaMethod)o2.getKey()));
        }
    }

    public static class Options {
        @Option(help={"The number of compilations allowed for any method before the VM exits (a value of 0 means there is no limit)."}, type=OptionType.Debug)
        public static final OptionKey<Integer> CompilationCountLimit = new OptionKey<Integer>(0);
    }
}

