/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.code.Register;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.core.amd64.AMD64AddressNode;
import org.graalvm.compiler.core.amd64.AMD64CompressAddressLowering;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.loop.BasicInductionVariable;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.DerivedInductionVariable;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;

public class AMD64HotSpotAddressLowering
extends AMD64CompressAddressLowering {
    private static final int ADDRESS_BITS = 64;
    private static final int INT_BITS = 32;
    private final long heapBase;
    private final Register heapBaseRegister;

    public AMD64HotSpotAddressLowering(GraalHotSpotVMConfig config, Register heapBaseRegister) {
        this.heapBase = config.getOopEncoding().getBase();
        this.heapBaseRegister = this.heapBase == 0L ? null : heapBaseRegister;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final boolean improveUncompression(AMD64AddressNode addr, CompressionNode compression, ValueNode other) {
        CompressEncoding encoding = compression.getEncoding();
        if (!AMD64Address.Scale.isScaleShiftSupported(encoding.getShift())) {
            return false;
        }
        if (this.heapBaseRegister != null && encoding.getBase() == this.heapBase) {
            if (other != null) return false;
            ValueNode base = compression.graph().unique(new AMD64CompressAddressLowering.HeapBaseNode(this.heapBaseRegister));
            addr.setBase(base);
        } else if (encoding.getBase() != 0L) {
            if (!AMD64HotSpotAddressLowering.updateDisplacement(addr, encoding.getBase(), false)) return false;
            addr.setBase(other);
        } else {
            addr.setBase(other);
        }
        AMD64Address.Scale scale = AMD64Address.Scale.fromShift(encoding.getShift());
        addr.setScale(scale);
        addr.setIndex(compression.getValue());
        return true;
    }

    @Override
    public void preProcess(StructuredGraph graph, LoopsDataProvider loopsDataProvider) {
        if (graph.hasLoops()) {
            LoopsData loopsData = loopsDataProvider.getLoopsData(graph);
            loopsData.detectedCountedLoops();
            for (LoopEx loop : loopsData.countedLoops()) {
                for (OffsetAddressNode offsetAdressNode : loop.whole().nodes().filter(OffsetAddressNode.class)) {
                    AMD64HotSpotAddressLowering.tryOptimize(offsetAdressNode, loop);
                }
            }
        }
    }

    @Override
    public void postProcess(AddressNode lowered) {
        AMD64AddressNode address = (AMD64AddressNode)lowered;
        address.setBase(AMD64HotSpotAddressLowering.tryImplicitZeroExtend(address.getBase()));
        address.setIndex(AMD64HotSpotAddressLowering.tryImplicitZeroExtend(address.getIndex()));
    }

    private static void tryOptimize(OffsetAddressNode offsetAddress, LoopEx loop) {
        ValueNode currentValue;
        EconomicMap<Node, InductionVariable> ivs = loop.getInductionVariables();
        InductionVariable currentIV = (InductionVariable)ivs.get((Object)offsetAddress.getOffset());
        while (currentIV != null && currentIV instanceof DerivedInductionVariable && !(currentValue = currentIV.valueNode()).isDeleted()) {
            ValueNode input;
            ZeroExtendNode zeroExtendNode;
            if (currentValue instanceof ZeroExtendNode && AMD64HotSpotAddressLowering.applicableToImplicitZeroExtend(zeroExtendNode = (ZeroExtendNode)currentValue) && (input = zeroExtendNode.getValue()) instanceof AddNode) {
                AddNode add = (AddNode)input;
                if (add.getX().isConstant()) {
                    AMD64HotSpotAddressLowering.optimizeAdd(zeroExtendNode, (ConstantNode)add.getX(), add.getY(), loop);
                } else if (add.getY().isConstant()) {
                    AMD64HotSpotAddressLowering.optimizeAdd(zeroExtendNode, (ConstantNode)add.getY(), add.getX(), loop);
                }
            }
            currentIV = ((DerivedInductionVariable)currentIV).getBase();
        }
    }

    private static void optimizeAdd(ZeroExtendNode zeroExtendNode, ConstantNode constant, ValueNode other, LoopEx loop) {
        StructuredGraph graph = zeroExtendNode.graph();
        AddNode addNode = graph.unique(new AddNode(AMD64HotSpotAddressLowering.signExtend(other, loop), ConstantNode.forLong(constant.asJavaConstant().asInt(), graph)));
        zeroExtendNode.replaceAtUsages(addNode);
    }

    private static ValueNode signExtend(ValueNode input, LoopEx loop) {
        EconomicMap<Node, InductionVariable> ivs;
        InductionVariable inductionVariable;
        StructuredGraph graph = input.graph();
        if (input instanceof PhiNode && (inductionVariable = (InductionVariable)(ivs = loop.getInductionVariables()).get((Object)input)) != null && inductionVariable instanceof BasicInductionVariable) {
            CountedLoopInfo countedLoopInfo = loop.counted();
            IntegerStamp initStamp = (IntegerStamp)inductionVariable.initNode().stamp(NodeView.DEFAULT);
            if (initStamp.isPositive()) {
                if (inductionVariable.isConstantExtremum() && countedLoopInfo.counterNeverOverflows()) {
                    long init = inductionVariable.constantInit();
                    long stride = inductionVariable.constantStride();
                    long extremum = inductionVariable.constantExtremum();
                    if (init >= 0L && extremum >= 0L) {
                        long shortestTrip = (extremum - init) / stride + 1L;
                        if (countedLoopInfo.constantMaxTripCount().equals(shortestTrip)) {
                            return graph.unique(new ZeroExtendNode(input, 32, 64, true));
                        }
                    }
                }
                if (countedLoopInfo.getLimitCheckedIV() == inductionVariable && inductionVariable.direction() == InductionVariable.Direction.Up && (countedLoopInfo.getOverFlowGuard() != null || countedLoopInfo.counterNeverOverflows())) {
                    return graph.unique(new ZeroExtendNode(input, 32, 64, true));
                }
            }
        }
        return input.graph().maybeAddOrUnique(SignExtendNode.create(input, 64, NodeView.DEFAULT));
    }

    private static boolean applicableToImplicitZeroExtend(ZeroExtendNode zeroExtendNode) {
        return zeroExtendNode.isInputAlwaysPositive() && zeroExtendNode.getInputBits() == 32 && zeroExtendNode.getResultBits() == 64;
    }

    private static ValueNode tryImplicitZeroExtend(ValueNode input) {
        ZeroExtendNode zeroExtendNode;
        if (input instanceof ZeroExtendNode && AMD64HotSpotAddressLowering.applicableToImplicitZeroExtend(zeroExtendNode = (ZeroExtendNode)input)) {
            return zeroExtendNode.getValue();
        }
        return input;
    }
}

