/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.amd64.AMD64LoweringProviderMixin;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.amd64.AMD64X87MathIntrinsicNode;
import org.graalvm.compiler.hotspot.amd64.AMD64X87MathSnippets;
import org.graalvm.compiler.hotspot.meta.DefaultHotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.replacements.HotSpotAllocationSnippets;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.amd64.AMD64ConvertSnippets;
import org.graalvm.compiler.replacements.amd64.AMD64TruffleArrayUtilsWithMaskSnippets;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;

public class AMD64HotSpotLoweringProvider
extends DefaultHotSpotLoweringProvider
implements AMD64LoweringProviderMixin {
    private AMD64ConvertSnippets.Templates convertSnippets;
    private AMD64X87MathSnippets.Templates mathSnippets;

    public AMD64HotSpotLoweringProvider(HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, HotSpotRegistersProvider registers, HotSpotConstantReflectionProvider constantReflection, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(runtime, metaAccess, foreignCalls, registers, constantReflection, platformConfig, metaAccessExtensionProvider, target);
    }

    @Override
    public void initialize(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, GraalHotSpotVMConfig config, HotSpotAllocationSnippets.Templates allocationSnippetTemplates) {
        this.convertSnippets = new AMD64ConvertSnippets.Templates(options, providers);
        this.mathSnippets = new AMD64X87MathSnippets.Templates(options, providers);
        providers.getReplacements().registerSnippetTemplateCache(new AMD64TruffleArrayUtilsWithMaskSnippets.Templates(options, providers));
        super.initialize(options, factories, providers, config, allocationSnippetTemplates);
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        if (this.lowerAMD64(n, tool)) {
            return;
        }
        if (n instanceof FloatConvertNode) {
            this.convertSnippets.lower((FloatConvertNode)n, tool);
        } else if (n instanceof UnaryMathIntrinsicNode) {
            this.lowerUnaryMath((UnaryMathIntrinsicNode)n, tool);
        } else {
            super.lower(n, tool);
        }
    }

    private void lowerUnaryMath(UnaryMathIntrinsicNode math, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        StructuredGraph graph = math.graph();
        ResolvedJavaMethod method = graph.method();
        if (method != null && this.getReplacements().isSnippet(method)) {
            return;
        }
        if (!HotSpotBackend.Options.GraalArithmeticStubs.getValue(graph.getOptions()).booleanValue()) {
            switch (math.getOperation()) {
                case SIN: 
                case COS: 
                case TAN: {
                    this.mathSnippets.lower(math, tool);
                    return;
                }
                case LOG: {
                    math.replaceAtUsages(graph.addOrUnique(new AMD64X87MathIntrinsicNode(math.getValue(), UnaryMathIntrinsicNode.UnaryOperation.LOG)));
                    return;
                }
                case LOG10: {
                    math.replaceAtUsages(graph.addOrUnique(new AMD64X87MathIntrinsicNode(math.getValue(), UnaryMathIntrinsicNode.UnaryOperation.LOG10)));
                    return;
                }
            }
        }
        ForeignCallNode call = graph.add(new ForeignCallNode(this.foreignCalls, math.getOperation().foreignCallSignature, math.getValue()));
        graph.addAfterFixed(tool.lastFixedNode(), call);
        math.replaceAtUsages(call);
    }

    @Override
    public boolean supportsRounding() {
        return ((AMD64)this.getTarget().arch).getFeatures().contains(AMD64.CPUFeature.SSE4_1);
    }
}

