/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.nodes.CallTargetNode;

@Opcode(value="CALL_DIRECT")
final class AMD64HotspotDirectVirtualCallOp
extends AMD64Call.DirectCallOp {
    public static final LIRInstructionClass<AMD64HotspotDirectVirtualCallOp> TYPE = LIRInstructionClass.create(AMD64HotspotDirectVirtualCallOp.class);
    private final CallTargetNode.InvokeKind invokeKind;
    private final GraalHotSpotVMConfig config;

    AMD64HotspotDirectVirtualCallOp(ResolvedJavaMethod target, Value result, Value[] parameters, Value[] temps, LIRFrameState state, CallTargetNode.InvokeKind invokeKind, GraalHotSpotVMConfig config) {
        super((LIRInstructionClass<? extends AMD64Call.DirectCallOp>)TYPE, target, result, parameters, temps, state);
        this.invokeKind = invokeKind;
        this.config = config;
        assert (invokeKind.isIndirect());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        crb.recordMark(this.invokeKind == CallTargetNode.InvokeKind.Virtual ? HotSpotMarkId.INVOKEVIRTUAL : HotSpotMarkId.INVOKEINTERFACE);
        masm.movq(AMD64.rax, this.config.nonOopBits);
        if (this.config.supportsMethodHandleDeoptimizationEntry() && this.config.isMethodHandleCall((HotSpotResolvedJavaMethod)this.callTarget)) {
            crb.setNeedsMHDeoptHandler();
        }
        AMD64Call.directCall(crb, masm, (InvokeTarget)this.callTarget, null, true, this.state);
    }
}

