/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.debug;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.core.GraalServiceThread;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.CSVUtil;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.PathUtilities;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

public class BenchmarkCounters {
    public static boolean enabled = false;
    public static final ConcurrentHashMap<String, Counter> counterMap = new ConcurrentHashMap();
    public static long[] delta;
    private static final String CSV_FMT;

    public static int getIndexConstantIncrement(String name, String group, GraalHotSpotVMConfig config, long increment) {
        Counter counter = BenchmarkCounters.getCounter(name, group, config);
        counter.staticCounters.addAndGet(increment);
        return counter.index;
    }

    public static int getIndex(String name, String group, GraalHotSpotVMConfig config) {
        Counter counter = BenchmarkCounters.getCounter(name, group, config);
        return counter.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="concurrent abstraction calls are in synchronized block")
    private static Counter getCounter(String name, String group, GraalHotSpotVMConfig config) throws GraalError {
        if (!enabled) {
            throw new GraalError("cannot access count index when counters are not enabled: " + group + ", " + name);
        }
        String nameGroup = name + "#" + group;
        Counter counter = counterMap.get(nameGroup);
        if (counter == null) {
            Class<BenchmarkCounters> clazz = BenchmarkCounters.class;
            // MONITORENTER : org.graalvm.compiler.hotspot.debug.BenchmarkCounters.class
            counter = counterMap.get(nameGroup);
            if (counter == null) {
                counter = new Counter(counterMap.size(), group, new AtomicLong());
                counterMap.put(nameGroup, counter);
            }
            // MONITOREXIT : clazz
        }
        assert (counter.group.equals(group)) : "mismatching groups: " + counter.group + " vs. " + group;
        int countersSize = config.jvmciCountersSize;
        if (counter.index < countersSize) return counter;
        throw new GraalError("too many counters, reduce number of counters or increase -XX:JVMCICounterSize=... (current value: " + countersSize + ")");
    }

    private static synchronized void dump(OptionValues options, PrintStream out, double seconds, long[] counters, int maxRows) {
        if (!counterMap.isEmpty()) {
            try (Dumper dumper = Dumper.getDumper(options, out, counterMap.size(), seconds, maxRows);){
                TreeSet set = new TreeSet();
                counterMap.forEach((nameGroup, counter) -> set.add(counter.group));
                for (String group : set) {
                    if (group == null) continue;
                    if (Options.BenchmarkCountersDumpStatic.getValue(options).booleanValue()) {
                        dumper.dumpCounters(true, group, BenchmarkCounters.collectStaticCounters(), counterMap.entrySet(), options);
                    }
                    if (!Options.BenchmarkCountersDumpDynamic.getValue(options).booleanValue()) continue;
                    dumper.dumpCounters(false, group, BenchmarkCounters.collectDynamicCounters(counters), counterMap.entrySet(), options);
                }
            }
            BenchmarkCounters.clear(counters);
        }
    }

    private static synchronized long[] collectDynamicCounters(long[] counters) {
        long[] array = (long[])counters.clone();
        for (int i = 0; i < array.length; ++i) {
            int n = i;
            array[n] = array[n] - delta[i];
        }
        return array;
    }

    private static synchronized long[] collectStaticCounters() {
        long[] array = new long[counterMap.size()];
        for (Counter counter : counterMap.values()) {
            array[counter.index] = counter.staticCounters.get();
        }
        return array;
    }

    private static synchronized void clear(long[] counters) {
        delta = counters;
    }

    private static boolean shouldDumpComputerReadable(OptionValues options) {
        String dumpFile = Options.BenchmarkCountersFile.getValue(options);
        return dumpFile != null && (dumpFile.endsWith(".csv") || dumpFile.endsWith(".CSV"));
    }

    private static String getName(String nameGroup, String group) {
        return nameGroup.substring(0, nameGroup.length() - group.length() - 1);
    }

    private static long percentage(long counter, long sum) {
        return (counter * 200L + 1L) / sum / 2L;
    }

    public static void initialize(final HotSpotJVMCIRuntime jvmciRuntime, final OptionValues options) {
        if (Options.BenchmarkDynamicCounters.getValue(options) != null) {
            String[] arguments = Options.BenchmarkDynamicCounters.getValue(options).split(",");
            if (arguments.length == 0 || arguments.length % 3 != 0) {
                throw new GraalError("invalid arguments to BenchmarkDynamicCounters: (err|out),start,end,(err|out),start,end,... (~ matches multiple digits)");
            }
            for (int i = 0; i < arguments.length; i += 3) {
                final class BenchmarkCountersOutputStream
                extends CallbackOutputStream {
                    private long startTime;
                    private boolean running;
                    private boolean waitingForEnd;

                    BenchmarkCountersOutputStream(PrintStream delegate, String start, String end) {
                        super(delegate, "\n", end, start);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    protected void patternFound(int index) {
                        switch (index) {
                            case 2: {
                                this.startTime = System.nanoTime();
                                BenchmarkCounters.access$500(jvmciRuntime.collectCounters());
                                this.running = true;
                                break;
                            }
                            case 1: {
                                if (!this.running) break;
                                this.waitingForEnd = true;
                                break;
                            }
                            case 0: {
                                if (!this.waitingForEnd) break;
                                this.waitingForEnd = false;
                                this.running = false;
                                scope = BenchmarkCounters.access$600(options);
                                var3_3 = null;
                                BenchmarkCounters.access$700(options, scope.out, (double)(System.nanoTime() - this.startTime) / 1.0E9, jvmciRuntime.collectCounters(), 100);
                                if (scope == null) break;
                                if (var3_3 == null) ** GOTO lbl27
                                try {
                                    scope.close();
                                }
                                catch (Throwable var4_4) {
                                    var3_3.addSuppressed(var4_4);
                                }
                                break;
lbl27:
                                // 1 sources

                                scope.close();
                                break;
                                catch (Throwable var4_5) {
                                    try {
                                        var3_3 = var4_5;
                                        throw var4_5;
                                    }
                                    catch (Throwable var5_6) {
                                        if (scope != null) {
                                            if (var3_3 != null) {
                                                try {
                                                    scope.close();
                                                }
                                                catch (Throwable var6_7) {
                                                    var3_3.addSuppressed(var6_7);
                                                }
                                            } else {
                                                scope.close();
                                            }
                                        }
                                        throw var5_6;
                                    }
                                }
                            }
                        }
                    }
                }
                if (arguments[i].equals("err")) {
                    System.setErr(new PrintStream(new BenchmarkCountersOutputStream(System.err, arguments[i + 1], arguments[i + 2])));
                    continue;
                }
                if (arguments[i].equals("out")) {
                    System.setOut(new PrintStream(new BenchmarkCountersOutputStream(System.out, arguments[i + 1], arguments[i + 2])));
                    continue;
                }
                throw new GraalError("invalid arguments to BenchmarkDynamicCounters: err|out");
            }
            enabled = true;
        }
        if (Options.GenericDynamicCounters.getValue(options).booleanValue()) {
            enabled = true;
        }
        if (Options.TimedDynamicCounters.getValue(options) > 0) {
            GraalServiceThread thread = new GraalServiceThread(BenchmarkCounters.class.getSimpleName(), new Runnable(){
                long lastTime = System.nanoTime();

                @Override
                public void run() {
                    PrintStreamScope scope = BenchmarkCounters.getPrintStream(options);
                    Throwable throwable = null;
                    try {
                        try {
                            while (true) {
                                try {
                                    Thread.sleep(Options.TimedDynamicCounters.getValue(options).intValue());
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                long time = System.nanoTime();
                                BenchmarkCounters.dump(options, scope.out, (double)(time - this.lastTime) / 1.0E9, jvmciRuntime.collectCounters(), 10);
                                this.lastTime = time;
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (scope != null) {
                            if (throwable != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                scope.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            });
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.start();
            enabled = true;
        }
        if (enabled) {
            BenchmarkCounters.clear(jvmciRuntime.collectCounters());
        }
    }

    public static void shutdown(HotSpotJVMCIRuntime jvmciRuntime, OptionValues options, long compilerStartTime) {
        if (Options.GenericDynamicCounters.getValue(options).booleanValue()) {
            try (PrintStreamScope scope = BenchmarkCounters.getPrintStream(options);){
                BenchmarkCounters.dump(options, scope.out, (double)(System.nanoTime() - compilerStartTime) / 1.0E9, jvmciRuntime.collectCounters(), 100);
            }
        }
    }

    private static PrintStreamScope getPrintStream(OptionValues options) {
        return new PrintStreamScope(options);
    }

    static /* synthetic */ void access$500(long[] x0) {
        BenchmarkCounters.clear(x0);
    }

    static {
        CSV_FMT = CSVUtil.buildFormatString("%s", "%s", "%s", "%d");
    }

    static class PrintStreamScope
    implements AutoCloseable {
        final PrintStream out;

        PrintStreamScope(OptionValues options) {
            PrintStream ps = TTY.out;
            if (Options.BenchmarkCountersFile.getValue(options) != null) {
                try {
                    String file = PathUtilities.getAbsolutePath(Options.BenchmarkCountersFile.getValue(options));
                    TTY.println("Writing benchmark counters to '%s'", file);
                    ps = new PrintStream(PathUtilities.openOutputStream(file));
                }
                catch (IOException e) {
                    TTY.out().println(e.getMessage());
                    TTY.out().println("Fallback to default");
                }
            }
            this.out = ps;
        }

        @Override
        public void close() {
            if (this.out != TTY.out) {
                this.out.close();
            }
        }
    }

    private static abstract class CallbackOutputStream
    extends OutputStream {
        protected final PrintStream delegate;
        private final byte[][] patterns;
        private final int[] positions;

        CallbackOutputStream(PrintStream delegate, String ... patterns) {
            this.delegate = delegate;
            this.positions = new int[patterns.length];
            this.patterns = new byte[patterns.length][];
            for (int i = 0; i < patterns.length; ++i) {
                this.patterns[i] = patterns[i].getBytes();
            }
        }

        protected abstract void patternFound(int var1);

        @Override
        public void write(int b) throws IOException {
            try {
                this.delegate.write(b);
                for (int i = 0; i < this.patterns.length; ++i) {
                    byte[] cs = this.patterns[i];
                    int j = this.positions[i];
                    byte patternChar = cs[j];
                    if (patternChar != 126 || !Character.isDigit(b)) {
                        if (patternChar == 126) {
                            int n = i;
                            int n2 = this.positions[n] + 1;
                            this.positions[n] = n2;
                            patternChar = cs[n2];
                        }
                        if (b == patternChar) {
                            int n = i;
                            this.positions[n] = this.positions[n] + 1;
                        } else {
                            this.positions[i] = 0;
                        }
                    }
                    if (this.positions[i] != this.patterns[i].length) continue;
                    this.positions[i] = 0;
                    this.patternFound(i);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace(this.delegate);
                throw e;
            }
        }
    }

    private static class ComputerReadableDumper
    extends Dumper {
        ComputerReadableDumper(PrintStream out) {
            super(out);
        }

        @Override
        public void start(int size) {
        }

        @Override
        public void close() {
        }

        @Override
        public void dumpCounters(boolean staticCounter, String group, long[] array, Set<Map.Entry<String, Counter>> counterEntrySet, OptionValues options) {
            String category = staticCounter ? "static counters" : "dynamic counters";
            for (Map.Entry<String, Counter> entry : counterEntrySet) {
                Counter counter = entry.getValue();
                if (!counter.group.equals(group)) continue;
                String name = BenchmarkCounters.getName(entry.getKey(), group);
                int index = counter.index;
                long value = array[index];
                CSVUtil.Escape.println(this.out, CSV_FMT, category, group, name, value);
            }
        }
    }

    private static class HumanReadableDumper
    extends Dumper {
        private final double seconds;
        private final int maxRows;

        HumanReadableDumper(PrintStream out, double seconds, int maxRows) {
            super(out);
            this.seconds = seconds;
            this.maxRows = maxRows;
        }

        @Override
        public void start(int size) {
            this.out.println("====== dynamic counters (" + size + " in total) ======");
        }

        @Override
        public void close() {
            this.out.println("============================");
        }

        @Override
        public void dumpCounters(boolean staticCounter, String group, long[] array, Set<Map.Entry<String, Counter>> counterEntrySet, OptionValues options) {
            TreeMap<Long, String> sorted = new TreeMap<Long, String>();
            long sum = 0L;
            for (Map.Entry<String, Counter> entry : counterEntrySet) {
                Counter counter = entry.getValue();
                int index = counter.index;
                if (!counter.group.equals(group)) continue;
                sum += array[index];
                sorted.put(array[index] * (long)array.length + (long)index, BenchmarkCounters.getName(entry.getKey(), group));
            }
            if (sum > 0L) {
                String numFmt;
                if (Options.BenchmarkCounterPrintingCutoff.getValue(options).booleanValue()) {
                    long cutoff = sorted.size() < 10 ? 1L : Math.max(1L, sum / 100L);
                    int cnt = sorted.size();
                    Iterator iter = sorted.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        long counter = (Long)entry.getKey() / (long)array.length;
                        if (counter < cutoff || cnt > this.maxRows) {
                            iter.remove();
                        }
                        --cnt;
                    }
                } else {
                    Iterator iter = sorted.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, Counter> entry;
                        entry = iter.next();
                        long counter = (Long)((Object)entry.getKey()) / (long)array.length;
                        if (counter != 0L) continue;
                        iter.remove();
                    }
                }
                String string = numFmt = Options.DynamicCountersPrintGroupSeparator.getValue(options) != false ? "%,19d" : "%19d";
                if (staticCounter) {
                    this.out.println("=========== " + group + " (static counters):");
                    for (Map.Entry entry : sorted.entrySet()) {
                        long counter = (Long)entry.getKey() / (long)array.length;
                        this.out.format(Locale.US, numFmt + " %3d%%  %s\n", counter, BenchmarkCounters.percentage(counter, sum), entry.getValue());
                    }
                    this.out.format(Locale.US, numFmt + " total\n", sum);
                } else if (group.startsWith("~")) {
                    this.out.println("=========== " + group + " (dynamic counters), time = " + this.seconds + " s:");
                    for (Map.Entry entry : sorted.entrySet()) {
                        long counter = (Long)entry.getKey() / (long)array.length;
                        this.out.format(Locale.US, numFmt + "/s %3d%%  %s\n", (long)((double)counter / this.seconds), BenchmarkCounters.percentage(counter, sum), entry.getValue());
                    }
                    this.out.format(Locale.US, numFmt + "/s total\n", (long)((double)sum / this.seconds));
                } else {
                    this.out.println("=========== " + group + " (dynamic counters):");
                    for (Map.Entry entry : sorted.entrySet()) {
                        long counter = (Long)entry.getKey() / (long)array.length;
                        this.out.format(Locale.US, numFmt + " %3d%%  %s\n", counter, BenchmarkCounters.percentage(counter, sum), entry.getValue());
                    }
                    this.out.format(Locale.US, numFmt + " total\n", sum);
                }
            }
        }
    }

    private static abstract class Dumper
    implements AutoCloseable {
        protected final PrintStream out;

        public static Dumper getDumper(OptionValues options, PrintStream out, int counterSize, double second, int maxRows) {
            Dumper dumper = BenchmarkCounters.shouldDumpComputerReadable(options) ? new ComputerReadableDumper(out) : new HumanReadableDumper(out, second, maxRows);
            dumper.start(counterSize);
            return dumper;
        }

        private Dumper(PrintStream out) {
            this.out = out;
        }

        protected abstract void start(int var1);

        public abstract void dumpCounters(boolean var1, String var2, long[] var3, Set<Map.Entry<String, Counter>> var4, OptionValues var5);

        @Override
        public abstract void close();
    }

    private static class Counter {
        public final int index;
        public final String group;
        public final AtomicLong staticCounters;

        Counter(int index, String group, AtomicLong staticCounters) {
            this.index = index;
            this.group = group;
            this.staticCounters = staticCounters;
        }
    }

    public static class Options {
        @Option(help={"Turn on the benchmark counters, and displays the results on VM shutdown"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> GenericDynamicCounters = new OptionKey<Boolean>(false);
        @Option(help={"Turn on the benchmark counters, and displays the results every n milliseconds"}, type=OptionType.Debug)
        public static final OptionKey<Integer> TimedDynamicCounters = new OptionKey<Integer>(-1);
        @Option(help={"file:doc-files/BenchmarkDynamicCountersHelp.txt"}, type=OptionType.Debug)
        public static final OptionKey<String> BenchmarkDynamicCounters = new OptionKey<Object>(null);
        @Option(help={"Use grouping separators for number printing"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> DynamicCountersPrintGroupSeparator = new OptionKey<Boolean>(true);
        @Option(help={"File to which benchmark counters are dumped. A CSV format is used if the file ends with .csv otherwise a more human readable format is used. The fields in the CSV format are: category, group, name, value"}, type=OptionType.Debug)
        public static final OptionKey<String> BenchmarkCountersFile = new OptionKey<Object>(null);
        @Option(help={"Dump dynamic counters"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> BenchmarkCountersDumpDynamic = new OptionKey<Boolean>(true);
        @Option(help={"Dump static counters"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> BenchmarkCountersDumpStatic = new OptionKey<Boolean>(false);
        @Option(help={"file:doc-files/AbortOnBenchmarkCounterOverflowHelp.txt"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> AbortOnBenchmarkCounterOverflow = new OptionKey<Boolean>(false);
        @Option(help={"Use a cutoff to print only most significant counters."}, type=OptionType.Debug)
        public static final OptionKey<Boolean> BenchmarkCounterPrintingCutoff = new OptionKey<Boolean>(true);
    }
}

