/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.VolatileCallSite;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.zip.CRC32;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.VMIntrinsicMethod;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigAccess;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotExceptionDispatchPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotInvocationPlugins;
import org.graalvm.compiler.hotspot.meta.HotSpotJITClassInitializationPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotNodePlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotLoadReservedReferenceNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotStoreReservedReferenceNode;
import org.graalvm.compiler.hotspot.replacements.BigIntegerSubstitutions;
import org.graalvm.compiler.hotspot.replacements.CallSiteTargetNode;
import org.graalvm.compiler.hotspot.replacements.DigestBaseSubstitutions;
import org.graalvm.compiler.hotspot.replacements.FastNotifyNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotIdentityHashCodeNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotInvocationPluginHelper;
import org.graalvm.compiler.hotspot.replacements.HotSpotReflectionGetCallerClassNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HubGetClassNode;
import org.graalvm.compiler.hotspot.replacements.ObjectCloneNode;
import org.graalvm.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ForeignCallPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginFactory;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.InvocationPluginHelper;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyCallNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopySnippets;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;
import sun.misc.Unsafe;

public class HotSpotGraphBuilderPlugins {
    public static final String reflectionClass = JavaVersionUtil.JAVA_SPEC <= 8 ? "sun.reflect.Reflection" : "jdk.internal.reflect.Reflection";

    public static GraphBuilderConfiguration.Plugins create(final HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, final GraalHotSpotVMConfig config, final HotSpotWordTypes wordTypes, final MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, final SnippetReflectionProvider snippetReflection, final HotSpotHostForeignCallsProvider foreignCalls, final ReplacementsImpl replacements, OptionValues options, TargetDescription target) {
        final HotSpotInvocationPlugins invocationPlugins = new HotSpotInvocationPlugins(graalRuntime, config, compilerConfiguration);
        final GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        plugins.appendNodePlugin(new HotSpotExceptionDispatchPlugin(config, wordTypes.getWordKind()));
        if (!Services.IS_IN_NATIVE_IMAGE) {
            HotSpotWordOperationPlugin wordOperationPlugin = new HotSpotWordOperationPlugin(snippetReflection, wordTypes);
            HotSpotNodePlugin nodePlugin = new HotSpotNodePlugin(wordOperationPlugin);
            plugins.appendTypePlugin(nodePlugin);
            plugins.appendNodePlugin(nodePlugin);
        }
        plugins.appendNodePlugin(new MethodHandlePlugin(constantReflection.getMethodHandleAccess(), !config.supportsMethodHandleDeoptimizationEntry()));
        plugins.appendInlineInvokePlugin(replacements);
        if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        if (config.instanceKlassInitThreadOffset != -1) {
            plugins.setClassInitializationPlugin(new HotSpotJITClassInitializationPlugin());
        }
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                HotSpotGraphBuilderPlugins.registerObjectPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerClassPlugins(plugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSystemPlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerThreadPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCallSitePlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerReflectionPlugins(invocationPlugins, replacements, config);
                HotSpotGraphBuilderPlugins.registerAESPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32CPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSHAPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerGHASHPlugins(invocationPlugins, config, metaAccess);
                HotSpotGraphBuilderPlugins.registerCounterModePlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBase64Plugins(invocationPlugins, config, metaAccess);
                HotSpotGraphBuilderPlugins.registerUnsafePlugins(invocationPlugins, config, replacements);
                StandardGraphBuilderPlugins.registerInvocationPlugins(metaAccess, snippetReflection, invocationPlugins, replacements, true, false, true, graalRuntime.getHostProviders().getLowerer());
                HotSpotGraphBuilderPlugins.registerArrayPlugins(invocationPlugins, replacements, config);
                HotSpotGraphBuilderPlugins.registerStringPlugins(invocationPlugins, replacements, wordTypes, foreignCalls, config);
                HotSpotGraphBuilderPlugins.registerArraysSupportPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerReferencePlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerTrufflePlugins(invocationPlugins, wordTypes, config);
            }
        });
        if (!Services.IS_IN_NATIVE_IMAGE) {
            NodeIntrinsificationProvider nodeIntrinsificationProvider = new NodeIntrinsificationProvider(metaAccess, snippetReflection, foreignCalls, wordTypes, target);
            invocationPlugins.defer(() -> {
                for (GeneratedPluginFactory factory : GraalServices.load(GeneratedPluginFactory.class)) {
                    factory.registerPlugins(invocationPlugins, nodeIntrinsificationProvider);
                }
            });
        }
        return plugins;
    }

    private static void registerTrufflePlugins(InvocationPlugins plugins, final WordTypes wordTypes, final GraalHotSpotVMConfig config) {
        if (config.jvmciReservedReference0Offset == -1) {
            return;
        }
        InvocationPlugins.Registration tl = new InvocationPlugins.Registration(plugins, "org.graalvm.compiler.truffle.runtime.hotspot.HotSpotFastThreadLocal");
        tl.register1("get", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                int jvmciReservedReference0Offset = config.jvmciReservedReference0Offset;
                GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
                b.addPush(JavaKind.Object, new HotSpotLoadReservedReferenceNode(b.getMetaAccess(), wordTypes, jvmciReservedReference0Offset));
                return true;
            }
        });
        tl.register2("set", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object[].class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                int jvmciReservedReference0Offset = config.jvmciReservedReference0Offset;
                GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
                b.add(new HotSpotStoreReservedReferenceNode(wordTypes, value, jvmciReservedReference0Offset));
                return true;
            }
        });
    }

    private static void registerObjectPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Object.class), replacements);
        r.register1("clone", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Object, new ObjectCloneNode(MacroNode.MacroParams.of(b, targetMethod, object)));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        r.register1("hashCode", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        if (config.inlineNotify()) {
            r.register1("notify", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.add(new FastNotifyNode(object, false, b.bci()));
                    return true;
                }

                @Override
                public boolean inlineOnly() {
                    return true;
                }
            });
        }
        if (config.inlineNotifyAll()) {
            r.register1("notifyAll", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.add(new FastNotifyNode(object, true, b.bci()));
                    return true;
                }

                @Override
                public boolean inlineOnly() {
                    return true;
                }
            });
        }
    }

    private static void registerClassPlugins(GraphBuilderConfiguration.Plugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)((Object)Class.class), replacements);
        r.register1("getModifiers", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    PiNode nonNullKlass = helper.emitNullReturnGuard(klass, ConstantNode.forInt(1041), 0.25);
                    helper.emitFinalReturn(JavaKind.Int, helper.readKlassModifierFlags(nonNullKlass));
                }
                return true;
            }
        });
        r.register1("isInterface", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, ConstantNode.forBoolean(false), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(512), NodeView.DEFAULT);
                    helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                }
                return true;
            }
        });
        r.register1("isPrimitive", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    LogicNode isNull = b.add(IsNullNode.create(klass));
                    b.addPush(JavaKind.Boolean, ConditionalNode.create(isNull, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                }
                return true;
            }
        });
        r.register1("getSuperclass", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    ConstantNode nullValue = ConstantNode.defaultForKind(JavaKind.Object);
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, nullValue, 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(512), NodeView.DEFAULT);
                    helper.emitReturnIfNot(test, nullValue, 0.25);
                    ValueNode layoutHelper = helper.klassLayoutHelper(klassNonNull);
                    ResolvedJavaType objectType = b.getMetaAccess().lookupJavaType(Object.class);
                    ConstantNode objectClass = ConstantNode.forConstant(b.getConstantReflection().asJavaClass(objectType), b.getMetaAccess());
                    helper.emitReturnIf(layoutHelper, Condition.LT, ConstantNode.forInt(config.klassLayoutHelperNeutralValue), objectClass, 0.25);
                    ValueNode superKlass = helper.readKlassSuperKlass(klassNonNull);
                    PiNode superKlassNonNull = helper.emitNullReturnGuard(superKlass, nullValue, 0.25);
                    helper.emitFinalReturn(JavaKind.Object, new HubGetClassNode(b.getMetaAccess(), superKlassNonNull));
                }
                return true;
            }
        });
        if (config.jvmAccIsHiddenClass != 0) {
            r.register1("isHidden", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                        ValueNode klass = helper.readKlassFromClass(receiver.get());
                        PiNode nonNullKlass = helper.emitNullReturnGuard(klass, ConstantNode.forBoolean(false), 0.25);
                        ValueNode accessFlags = helper.readKlassAccessFlags(nonNullKlass);
                        LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(config.jvmAccIsHiddenClass), NodeView.DEFAULT);
                        helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                    }
                    return true;
                }
            });
        }
        if (config.getFieldOffset("ArrayKlass::_component_mirror", Integer.class, "oop", Integer.MAX_VALUE, GraalHotSpotVMConfigAccess.JDK <= 8) != Integer.MAX_VALUE) {
            r.register1("getComponentType", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                        ValueNode klass = helper.readKlassFromClass(receiver.get());
                        ConstantNode nullValue = ConstantNode.defaultForKind(JavaKind.Object);
                        PiNode klassNonNull = helper.emitNullReturnGuard(klass, nullValue, 0.25);
                        ValueNode layoutHelper = helper.klassLayoutHelper(klassNonNull);
                        AbstractBeginNode guard = helper.emitReturnIf(layoutHelper, Condition.GE, ConstantNode.forInt(config.klassLayoutHelperNeutralValue), nullValue, 0.25);
                        ValueNode componentMirror = helper.readArrayKlassComponentMirror(klassNonNull, guard);
                        helper.emitFinalReturn(JavaKind.Object, componentMirror);
                    }
                    return true;
                }
            });
        }
    }

    private static void registerCallSitePlugins(InvocationPlugins plugins) {
        InvocationPlugin plugin = new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode callSite = receiver.get();
                ConstantNode folded = CallSiteTargetNode.tryFold(GraphUtil.originalValue(callSite, true), b.getMetaAccess(), b.getAssumptions());
                if (folded != null) {
                    b.addPush(JavaKind.Object, folded);
                } else {
                    b.addPush(JavaKind.Object, new CallSiteTargetNode(MacroNode.MacroParams.of(b, targetMethod, callSite)));
                }
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        };
        plugins.register(plugin, (Type)((Object)ConstantCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
        plugins.register(plugin, (Type)((Object)MutableCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
        plugins.register(plugin, (Type)((Object)VolatileCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, reflectionClass, replacements);
        r.register0("getCallerClass", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, new HotSpotReflectionGetCallerClassNode(MacroNode.MacroParams.of(b, targetMethod, new ValueNode[0])));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        r.register1("getClassAccessFlags", (Type)((Object)Class.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(b.nullCheckedValue(arg));
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, ConstantNode.forInt(1041), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    helper.emitFinalReturn(JavaKind.Int, new AndNode(accessFlags, ConstantNode.forInt(config.jvmAccWrittenFlags)));
                }
                return true;
            }
        });
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = JavaVersionUtil.JAVA_SPEC <= 8 ? new InvocationPlugins.Registration(plugins, (Type)((Object)Unsafe.class), replacements) : new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
        r.register6(HotSpotBackend.copyMemoryName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, (Type)((Object)Object.class), Long.TYPE, Long.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode srcBase, ValueNode srcOffset, ValueNode destBase, ValueNode destOffset, ValueNode bytes) {
                b.add(new UnsafeCopyMemoryNode(config.doingUnsafeAccessOffset != Integer.MAX_VALUE, receiver.get(), srcBase, srcOffset, destBase, destOffset, bytes));
                return true;
            }
        });
        r.register2("allocateInstance", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Class.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode clazz) {
                unsafe.get();
                DynamicNewInstanceNode.createAndPush(b, clazz);
                return true;
            }
        });
    }

    private static void registerSystemPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)System.class));
        r.register0("currentTimeMillis", new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_MILLIS));
        r.register0("nanoTime", new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_NANOS));
        r.register1("identityHashCode", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        ArrayCopySnippets.registerSystemArraycopyPlugin(r);
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Array.class), replacements);
        r.setAllowOverwrite(true);
        r.register2("newInstance", (Type)((Object)Class.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode componentType, ValueNode length) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode nonNullComponentType = b.nullCheckedValue(componentType);
                    ValueNode arrayClass = helper.loadArrayKlass(nonNullComponentType);
                    helper.doFallbackIf(IsNullNode.create(arrayClass), 0.25);
                    helper.emitFinalReturn(JavaKind.Object, new DynamicNewArrayNode(nonNullComponentType, length, true));
                }
                return true;
            }
        });
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements, final WordTypes wordTypes, final ArrayCopyForeignCalls foreignCalls, final GraalHotSpotVMConfig vmConfig) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
            utf16r.register3("toBytes", (Type)((Object)char[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){
                private static final int MAX_LENGTH = 0x3FFFFFFF;

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode length) {
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, vmConfig);){
                        helper.intrinsicRangeCheck(srcBegin, Condition.LT, ConstantNode.forInt(0));
                        helper.intrinsicRangeCheck(length, Condition.LT, ConstantNode.forInt(0));
                        helper.intrinsicRangeCheck(length, Condition.GT, ConstantNode.forInt(0x3FFFFFFF));
                        ArrayLengthNode valueLength = b.add(new ArrayLengthNode(value));
                        SubNode limit = b.add(new SubNode(valueLength, length));
                        helper.intrinsicRangeCheck(srcBegin, Condition.GT, limit);
                        NewArrayNode newArray = b.add(new NewArrayNode(b.getMetaAccess().lookupJavaType(Byte.TYPE), b.add(new LeftShiftNode(length, ConstantNode.forInt(1))), false));
                        b.addPush(JavaKind.Object, newArray);
                        b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, newArray, ConstantNode.forInt(0), length, JavaKind.Char, LocationIdentity.init(), false, true, true, vmConfig.heapWordSize));
                    }
                    return true;
                }
            });
            utf16r.register5("getChars", (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)char[].class), Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode srcEnd, ValueNode dst, ValueNode dstBegin) {
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, vmConfig);){
                        ValueNode length = helper.sub(srcEnd, srcBegin);
                        helper.intrinsicRangeCheck(srcBegin, Condition.LT, ConstantNode.forInt(0));
                        helper.intrinsicRangeCheck(length, Condition.LT, ConstantNode.forInt(0));
                        ValueNode srcLimit = helper.sub(helper.shr(helper.length(value), 1), length);
                        helper.intrinsicRangeCheck(srcBegin, Condition.GT, srcLimit);
                        ValueNode limit = helper.sub(helper.length(dst), length);
                        helper.intrinsicRangeCheck(dstBegin, Condition.GT, limit);
                        b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, dst, dstBegin, length, JavaKind.Char, JavaKind.Byte, JavaKind.Char, false, true, true, vmConfig.heapWordSize));
                    }
                    return true;
                }
            });
        }
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class), replacements);
        r.register0("currentThread", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode value = helper.readCurrentThreadObject();
                    b.push(JavaKind.Object, value);
                }
                return true;
            }
        });
        if (config.osThreadInterruptedOffset != Integer.MAX_VALUE) {
            assert (!config.threadObjectFieldIsHandle);
            r.register2("isInterrupted", (Type)((Object)InvocationPlugin.Receiver.class), Boolean.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clearInterrupted) {
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                        ValueNode receiverThreadObject = receiver.get();
                        CurrentJavaThreadNode thread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
                        ValueNode currentThreadObject = helper.readCurrentThreadObject(thread);
                        helper.doFallbackIf(receiverThreadObject, Condition.NE, currentThreadObject, 0.25);
                        ValueNode osThread = helper.readOsThread(thread);
                        ValueNode interrupted = helper.readOsThreadInterrupted(osThread);
                        helper.emitReturnIf(interrupted, Condition.EQ, ConstantNode.forInt(0), ConstantNode.forBoolean(false), 0.75);
                        helper.doFallbackIf(clearInterrupted, Condition.EQ, ConstantNode.forBoolean(true), 0.25);
                        LogicNode test = helper.createCompare(interrupted, CanonicalCondition.EQ, ConstantNode.forInt(0));
                        helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                    }
                    return true;
                }
            });
        }
    }

    public static String lookupIntrinsicName(GraalHotSpotVMConfig config, String className, String name1, String name2) {
        return (String)HotSpotGraphBuilderPlugins.selectIntrinsicName(config, className, name1, name2).getLeft();
    }

    public static Pair<String, String> selectIntrinsicName(GraalHotSpotVMConfig config, String className, String name1, String name2) {
        boolean foundName1 = false;
        boolean foundName2 = false;
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (!className.equals(intrinsic.declaringClass)) continue;
            if (name1.equals(intrinsic.name)) {
                foundName1 = true;
                continue;
            }
            if (!name2.equals(intrinsic.name)) continue;
            foundName2 = true;
        }
        if (foundName1 && !foundName2) {
            return Pair.create((Object)name1, (Object)name2);
        }
        if (foundName2 && !foundName1) {
            return Pair.create((Object)name2, (Object)name1);
        }
        throw GraalError.shouldNotReachHere();
    }

    public static boolean isIntrinsicName(GraalHotSpotVMConfig config, String className, String name) {
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (!className.equals(intrinsic.declaringClass) || !name.equals(intrinsic.name)) continue;
            return true;
        }
        return false;
    }

    private static void registerAESPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (config.useAESIntrinsics) {
            assert (config.aescryptEncryptBlockStub != 0L);
            assert (config.aescryptDecryptBlockStub != 0L);
            assert (config.cipherBlockChainingEncryptAESCryptStub != 0L);
            assert (config.cipherBlockChainingDecryptAESCryptStub != 0L);
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CipherBlockChaining", replacements);
            Pair<String, String> cbcEncryptName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "com/sun/crypto/provider/CipherBlockChaining", "implEncrypt", "encrypt");
            try {
                r.registerOptional6((String)cbcEncryptName.getLeft(), (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, new CipherBlockChainingCryptPlugin(true));
            }
            catch (NoSuchMethodError e3) {
                throw new GraalError(e3, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", cbcEncryptName.getRight(), cbcEncryptName.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
            }
            Pair<String, String> cbcDecryptName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "com/sun/crypto/provider/CipherBlockChaining", "implDecrypt", "decrypt");
            try {
                r.registerOptional6((String)cbcDecryptName.getLeft(), (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, new CipherBlockChainingCryptPlugin(false));
            }
            catch (NoSuchMethodError e2) {
                throw new GraalError(e2, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", cbcDecryptName.getRight(), cbcDecryptName.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
            }
            r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.AESCrypt", replacements);
            Pair<String, String> aesEncryptName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "com/sun/crypto/provider/AESCrypt", "implEncryptBlock", "encryptBlock");
            try {
                r.registerOptional5((String)aesEncryptName.getLeft(), (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, new AESCryptPlugin(true));
            }
            catch (NoSuchMethodError e1) {
                throw new GraalError(e1, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", aesEncryptName.getRight(), aesEncryptName.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
            }
            Pair<String, String> aesDecryptName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "com/sun/crypto/provider/AESCrypt", "implDecryptBlock", "decryptBlock");
            try {
                r.registerOptional5((String)aesDecryptName.getLeft(), (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, new AESCryptPlugin(false));
            }
            catch (NoSuchMethodError e) {
                throw new GraalError(e, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", aesDecryptName.getRight(), aesDecryptName.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
            }
        }
    }

    private static void registerBigIntegerPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)BigInteger.class), replacements);
        assert (!config.useMultiplyToLenIntrinsic() || config.multiplyToLen != 0L);
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            r.registerConditionalMethodSubstitution(config.useMultiplyToLenIntrinsic(), BigIntegerSubstitutions.class, "multiplyToLen", "multiplyToLenStatic", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class});
        } else {
            r.registerConditionalMethodSubstitution(config.useMultiplyToLenIntrinsic(), BigIntegerSubstitutions.class, "implMultiplyToLen", "multiplyToLenStatic", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class});
        }
        if (config.useMulAddIntrinsic()) {
            r.register5("implMulAdd", (Type)((Object)int[].class), (Type)((Object)int[].class), Integer.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode out, ValueNode in, ValueNode offset, ValueNode len, ValueNode k) {
                    try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                        ValueNode outNonNull = b.nullCheckedValue(out);
                        ArrayLengthNode outNonNullLength = b.add(new ArrayLengthNode(outNonNull));
                        SubNode newOffset = new SubNode(outNonNullLength, offset);
                        ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MUL_ADD, helper.arrayStart(outNonNull, JavaKind.Int), helper.arrayStart(in, JavaKind.Int), newOffset, len, k);
                        b.addPush(JavaKind.Int, call);
                    }
                    return true;
                }
            });
        }
        if (config.useMontgomeryMultiplyIntrinsic()) {
            r.register6("implMontgomeryMultiply", (Type)((Object)int[].class), (Type)((Object)int[].class), (Type)((Object)int[].class), Integer.TYPE, Long.TYPE, (Type)((Object)int[].class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode bObject, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                    try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                        b.addPush(JavaKind.Object, product);
                        b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_MULTIPLY, helper.arrayStart(a, JavaKind.Int), helper.arrayStart(bObject, JavaKind.Int), helper.arrayStart(n, JavaKind.Int), len, inv, helper.arrayStart(product, JavaKind.Int)));
                    }
                    return true;
                }
            });
        }
        if (config.useMontgomerySquareIntrinsic()) {
            r.register5("implMontgomerySquare", (Type)((Object)int[].class), (Type)((Object)int[].class), Integer.TYPE, Long.TYPE, (Type)((Object)int[].class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                    try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                        b.addPush(JavaKind.Object, product);
                        b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_SQUARE, helper.arrayStart(a, JavaKind.Int), helper.arrayStart(n, JavaKind.Int), len, inv, helper.arrayStart(product, JavaKind.Int)));
                    }
                    return true;
                }
            });
        }
        if (config.useSquareToLenIntrinsic()) {
            r.register4("implSquareToLen", (Type)((Object)int[].class), Integer.TYPE, (Type)((Object)int[].class), Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode len, ValueNode z, ValueNode zlen) {
                    try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                        b.addPush(JavaKind.Object, z);
                        b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.SQUARE_TO_LEN, helper.arrayStart(x, JavaKind.Int), len, helper.arrayStart(z, JavaKind.Int), zlen));
                    }
                    return true;
                }
            });
        }
    }

    private static void registerSHAPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        SHAInvocationPlugin plugin;
        InvocationPlugins.Registration r;
        boolean useSha1 = config.useSHA1Intrinsics();
        boolean useSha256 = config.useSHA256Intrinsics();
        boolean useSha512 = config.useSHA512Intrinsics();
        if (HotSpotGraphBuilderPlugins.isIntrinsicName(config, "sun/security/provider/DigestBase", "implCompressMultiBlock0") && (useSha1 || useSha256 || useSha512)) {
            InvocationPlugins.Registration r2 = new InvocationPlugins.Registration(plugins, "sun.security.provider.DigestBase", replacements);
            r2.registerMethodSubstitution(DigestBaseSubstitutions.class, "implCompressMultiBlock0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE});
        }
        Pair<String, String> implCompressName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "sun/security/provider/SHA", "implCompress", "implCompress0");
        if (useSha1) {
            assert (config.sha1ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA", replacements);
            plugin = new SHAInvocationPlugin(HotSpotBackend.SHA_IMPL_COMPRESS);
            try {
                r.register3((String)implCompressName.getLeft(), (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, plugin);
            }
            catch (NoSuchMethodError e) {
                throw new GraalError(e, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", implCompressName.getRight(), implCompressName.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
            }
        }
        if (useSha256) {
            assert (config.sha256ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA2", replacements);
            plugin = new SHAInvocationPlugin(HotSpotBackend.SHA2_IMPL_COMPRESS);
            try {
                r.register3((String)implCompressName.getLeft(), (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, plugin);
            }
            catch (NoSuchMethodError e) {
                throw new GraalError(e, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", implCompressName.getRight(), implCompressName.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
            }
        }
        if (useSha512) {
            assert (config.sha512ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA5", replacements);
            plugin = new SHAInvocationPlugin(HotSpotBackend.SHA5_IMPL_COMPRESS);
            try {
                r.register3((String)implCompressName.getLeft(), (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, plugin);
            }
            catch (NoSuchMethodError e) {
                throw new GraalError(e, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", implCompressName.getRight(), implCompressName.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
            }
        }
    }

    private static void registerGHASHPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess) {
        if (config.useGHASHIntrinsics()) {
            assert (config.ghashProcessBlocks != 0L);
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.GHASH");
            r.register5("processBlocks", (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)long[].class), (Type)((Object)long[].class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode data, ValueNode inOffset, ValueNode blocks, ValueNode state, ValueNode hashSubkey) {
                    int longArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Long);
                    int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                    ValueNode dataOffset = AddNode.create(ConstantNode.forInt(byteArrayBaseOffset), inOffset, NodeView.DEFAULT);
                    ComputeObjectAddressNode dataAddress = b.add(new ComputeObjectAddressNode(data, dataOffset));
                    ComputeObjectAddressNode stateAddress = b.add(new ComputeObjectAddressNode(state, ConstantNode.forInt(longArrayBaseOffset)));
                    ComputeObjectAddressNode hashSubkeyAddress = b.add(new ComputeObjectAddressNode(hashSubkey, ConstantNode.forInt(longArrayBaseOffset)));
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.GHASH_PROCESS_BLOCKS, stateAddress, hashSubkeyAddress, dataAddress, blocks));
                    return true;
                }
            });
        }
    }

    private static void registerCounterModePlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (HotSpotGraphBuilderPlugins.isIntrinsicName(config, "com/sun/crypto/provider/CounterMode", "implCrypt") && config.useAESCTRIntrinsics) {
            assert (config.counterModeAESCrypt != 0L);
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CounterMode", replacements);
            r.register6("implCrypt", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, new CounterModeCryptPlugin());
        }
    }

    private static void registerBase64Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess) {
        if (config.useBase64Intrinsics()) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Encoder");
            r.register7("encodeBlock", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Boolean.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL) {
                    int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                    ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                    ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_ENCODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL));
                    return true;
                }
            });
        }
    }

    private static void registerCRC32Plugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        if (config.useCRC32Intrinsics) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)CRC32.class), replacements);
            r.register2("update", Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode arg) {
                    ConstantNode crcTableRawAddress = ConstantNode.forLong(config.crcTableAddress);
                    XorNode c = new XorNode(crc, ConstantNode.forInt(-1));
                    AndNode index = new AndNode(new XorNode(arg, c), ConstantNode.forInt(255));
                    LeftShiftNode offset = new LeftShiftNode(index, ConstantNode.forInt(2));
                    OffsetAddressNode address = new OffsetAddressNode(crcTableRawAddress, new SignExtendNode(offset, 32, 64));
                    ValueNode result = b.add(new JavaReadNode(JavaKind.Int, (AddressNode)address, HotSpotBackend.CRC_TABLE_LOCATION, OnHeapMemoryAccess.BarrierType.NONE, false));
                    result = new XorNode(result, new UnsignedRightShiftNode(c, ConstantNode.forInt(8)));
                    b.addPush(JavaKind.Int, new XorNode(result, ConstantNode.forInt(-1)));
                    return true;
                }
            });
            String updateBytesName = JavaVersionUtil.JAVA_SPEC <= 8 ? "updateBytes" : "updateBytes0";
            r.register4(updateBytesName, Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode len) {
                    int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                    ComputeObjectAddressNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                    return true;
                }
            });
            String updateByteBufferName = JavaVersionUtil.JAVA_SPEC <= 8 ? "updateByteBuffer" : "updateByteBuffer0";
            r.register4(updateByteBufferName, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode len) {
                    AddNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                    return true;
                }
            });
        }
    }

    private static void registerCRC32CPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC > 8 && config.useCRC32CIntrinsics) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.CRC32C", replacements);
            r.register4("updateBytes", Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode end) {
                    int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                    ComputeObjectAddressNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                    return true;
                }
            });
            r.register4("updateDirectByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode end) {
                    AddNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                    return true;
                }
            });
        }
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC > 8 && config.useVectorizedMismatchIntrinsic) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport", replacements);
            r.register6("vectorizedMismatch", (Type)((Object)Object.class), Long.TYPE, (Type)((Object)Object.class), Long.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode aOffset, ValueNode bObject, ValueNode bOffset, ValueNode length, ValueNode log2ArrayIndexScale) {
                    ComputeObjectAddressNode aAddr = b.add(new ComputeObjectAddressNode(a, aOffset));
                    ComputeObjectAddressNode bAddr = b.add(new ComputeObjectAddressNode(bObject, bOffset));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.VECTORIZED_MISMATCH, aAddr, bAddr, length, log2ArrayIndexScale));
                    return true;
                }
            });
        }
    }

    private static void registerReferencePlugins(InvocationPlugins plugins, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC >= 16) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Reference.class), replacements);
            r.register2("refersTo0", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode o) {
                    ConstantNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                    AddressNode address = b.add(new OffsetAddressNode(receiver.get(), offset));
                    FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                    JavaReadNode read = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, OnHeapMemoryAccess.BarrierType.WEAK_FIELD, true));
                    LogicNode objectEquals = b.add(ObjectEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), read, o, NodeView.DEFAULT));
                    b.addPush(JavaKind.Boolean, ConditionalNode.create(objectEquals, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                    return true;
                }

                @Override
                public boolean inlineOnly() {
                    return true;
                }
            });
            r = new InvocationPlugins.Registration(plugins, (Type)((Object)PhantomReference.class), replacements);
            r.register2("refersTo0", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode o) {
                    ConstantNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                    AddressNode address = b.add(new OffsetAddressNode(receiver.get(), offset));
                    FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                    JavaReadNode read = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, OnHeapMemoryAccess.BarrierType.PHANTOM_FIELD, true));
                    LogicNode objectEquals = b.add(ObjectEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), read, o, NodeView.DEFAULT));
                    b.addPush(JavaKind.Boolean, ConditionalNode.create(objectEquals, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                    return true;
                }

                @Override
                public boolean inlineOnly() {
                    return true;
                }
            });
        }
    }

    static class CounterModeCryptPlugin
    implements InvocationPlugin {
        CounterModeCryptPlugin() {
        }

        public static ResolvedJavaType getType(ResolvedJavaType context, String typeName) {
            try {
                UnresolvedJavaType unresolved = UnresolvedJavaType.create((String)typeName);
                return unresolved.resolve(context);
            }
            catch (LinkageError e) {
                throw new GraalError(e);
            }
        }

        static ResolvedJavaType aesCryptType(ResolvedJavaType context) {
            return CounterModeCryptPlugin.getType(context, "Lcom/sun/crypto/provider/AESCrypt;");
        }

        static ResolvedJavaType feedbackCipherType(ResolvedJavaType context) {
            return CounterModeCryptPlugin.getType(context, "Lcom/sun/crypto/provider/FeedbackCipher;");
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode len, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ValueNode nonNullReceiver = receiver.get();
                ResolvedJavaField embeddedCipherField = helper.getField(CounterModeCryptPlugin.feedbackCipherType(targetMethod.getDeclaringClass()), "embeddedCipher");
                ValueNode embeddedCipher = helper.loadField(nonNullReceiver, embeddedCipherField);
                LogicNode typeCheck = InstanceOfNode.create(TypeReference.create(b.getAssumptions(), CounterModeCryptPlugin.aesCryptType(targetMethod.getDeclaringClass())), embeddedCipher);
                helper.doFallbackIfNot(typeCheck, 0.25);
                ValueNode nonNullIn = b.nullCheckedValue(in);
                ValueNode nonNullOut = b.nullCheckedValue(out);
                ValueNode inAddr = helper.arrayElementPointer(nonNullIn, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(nonNullOut, JavaKind.Byte, outOffset);
                ResolvedJavaField kField = helper.getField(CounterModeCryptPlugin.aesCryptType(targetMethod.getDeclaringClass()), "K");
                ValueNode k = b.nullCheckedValue(helper.loadField(embeddedCipher, kField));
                ResolvedJavaField counterField = helper.getField(targetMethod.getDeclaringClass(), "counter");
                ValueNode counter = helper.loadField(nonNullReceiver, counterField);
                ValueNode counterAddr = helper.arrayStart(counter, JavaKind.Byte);
                ResolvedJavaField encryptedCounterField = helper.getField(targetMethod.getDeclaringClass(), "encryptedCounter");
                ValueNode encryptedCounter = helper.loadField(nonNullReceiver, encryptedCounterField);
                ValueNode encryptedCounterAddr = helper.arrayStart(encryptedCounter, JavaKind.Byte);
                ValueNode kAddr = helper.arrayStart(k, JavaKind.Int);
                ComputeObjectAddressNode usedPtr = b.add(new ComputeObjectAddressNode(nonNullReceiver, helper.asWord(helper.getFieldOffset(targetMethod.getDeclaringClass(), "used"))));
                ForeignCallNode call = b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.COUNTERMODE_IMPL_CRYPT, inAddr, outAddr, kAddr, counterAddr, len, encryptedCounterAddr, usedPtr));
                helper.emitFinalReturn(JavaKind.Int, call);
            }
            return true;
        }
    }

    static class SHAInvocationPlugin
    implements InvocationPlugin {
        private final ForeignCallDescriptor descriptor;

        SHAInvocationPlugin(ForeignCallDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode buf, ValueNode ofs) {
            PiNode realReceiver = b.add(new PiNode(receiver.get(), targetMethod.getDeclaringClass(), false, true));
            JavaKind wordKind = JavaKind.Long;
            int stateOffset = HotSpotReplacementsUtil.getFieldOffset(targetMethod.getDeclaringClass(), "state");
            RawLoadNode state = b.add(new RawLoadNode(realReceiver, b.add(ConstantNode.forIntegerKind(wordKind, stateOffset)), JavaKind.Object, LocationIdentity.any()));
            int intArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Int);
            int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
            ComputeObjectAddressNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), ofs)));
            ComputeObjectAddressNode stateAddr = b.add(new ComputeObjectAddressNode(state, ConstantNode.forInt(intArrayBaseOffset)));
            b.add(new ForeignCallNode(this.descriptor, bufAddr, stateAddr));
            return true;
        }
    }

    public static class CipherBlockChainingCryptPlugin
    implements InvocationPlugin {
        private final boolean doEncrypt;

        public static ResolvedJavaType getType(ResolvedJavaType context, String typeName) {
            try {
                UnresolvedJavaType unresolved = UnresolvedJavaType.create((String)typeName);
                return unresolved.resolve(context);
            }
            catch (LinkageError e) {
                throw new GraalError(e);
            }
        }

        static ResolvedJavaType aesCryptType(ResolvedJavaType context) {
            return CipherBlockChainingCryptPlugin.getType(context, "Lcom/sun/crypto/provider/AESCrypt;");
        }

        static ResolvedJavaType feedbackCipherType(ResolvedJavaType context) {
            return CipherBlockChainingCryptPlugin.getType(context, "Lcom/sun/crypto/provider/FeedbackCipher;");
        }

        CipherBlockChainingCryptPlugin(boolean doEncrypt) {
            this.doEncrypt = doEncrypt;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode inLength, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ValueNode nonNullReceiver = receiver.get();
                ResolvedJavaField embeddedCipherField = helper.getField(CipherBlockChainingCryptPlugin.feedbackCipherType(targetMethod.getDeclaringClass()), "embeddedCipher");
                ValueNode embeddedCipher = helper.loadField(nonNullReceiver, embeddedCipherField);
                LogicNode typeCheck = InstanceOfNode.create(TypeReference.create(b.getAssumptions(), CipherBlockChainingCryptPlugin.aesCryptType(targetMethod.getDeclaringClass())), embeddedCipher);
                helper.doFallbackIfNot(typeCheck, 0.25);
                ValueNode nonNullIn = b.nullCheckedValue(in);
                ValueNode nonNullOut = b.nullCheckedValue(out);
                ConstantNode zero = ConstantNode.forInt(0);
                helper.intrinsicRangeCheck(inOffset, Condition.LT, zero);
                helper.intrinsicRangeCheck(helper.sub(inLength, ConstantNode.forInt(16)), Condition.LT, inOffset);
                helper.intrinsicRangeCheck(outOffset, Condition.LT, zero);
                ValueNode outLength = helper.length(nonNullOut);
                helper.intrinsicRangeCheck(helper.sub(outLength, ConstantNode.forInt(16)), Condition.LT, outOffset);
                ResolvedJavaField kField = helper.getField(CipherBlockChainingCryptPlugin.aesCryptType(targetMethod.getDeclaringClass()), "K");
                ValueNode k = b.nullCheckedValue(helper.loadField(embeddedCipher, kField));
                ResolvedJavaField rField = helper.getField(targetMethod.getDeclaringClass(), "r");
                ValueNode r = b.nullCheckedValue(helper.loadField(nonNullReceiver, rField));
                ValueNode kAddr = helper.arrayStart(k, JavaKind.Int);
                ValueNode rAddr = helper.arrayStart(r, JavaKind.Byte);
                ValueNode inAddr = helper.arrayElementPointer(nonNullIn, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(nonNullOut, JavaKind.Byte, outOffset);
                HotSpotForeignCallDescriptor descriptor = this.doEncrypt ? HotSpotBackend.CIPHER_BLOCK_CHAINING_ENCRYPT_AESCRYPT : HotSpotBackend.CIPHER_BLOCK_CHAINING_DECRYPT_AESCRYPT;
                ForeignCallNode call = b.add(new ForeignCallNode((ForeignCallDescriptor)descriptor, inAddr, outAddr, kAddr, rAddr, inLength));
                helper.emitFinalReturn(JavaKind.Int, call);
            }
            return true;
        }
    }

    public static class AESCryptPlugin
    implements InvocationPlugin {
        private final boolean doEncrypt;
        static final int AES_BLOCK_SIZE_IN_BYTES = 16;

        public static ResolvedJavaType getType(ResolvedJavaType context, String typeName) {
            try {
                UnresolvedJavaType unresolved = UnresolvedJavaType.create((String)typeName);
                return unresolved.resolve(context);
            }
            catch (LinkageError e) {
                throw new GraalError(e);
            }
        }

        static ResolvedJavaType aesCryptType(ResolvedJavaType context) {
            return AESCryptPlugin.getType(context, "Lcom/sun/crypto/provider/AESCrypt;");
        }

        AESCryptPlugin(boolean doEncrypt) {
            this.doEncrypt = doEncrypt;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ValueNode nonNullReceiver = receiver.get();
                ValueNode nonNullIn = b.nullCheckedValue(in);
                ValueNode nonNullOut = b.nullCheckedValue(out);
                ConstantNode zero = ConstantNode.forInt(0);
                helper.intrinsicRangeCheck(inOffset, Condition.LT, zero);
                ValueNode inLength = helper.length(nonNullIn);
                helper.intrinsicRangeCheck(helper.sub(inLength, ConstantNode.forInt(16)), Condition.LT, inOffset);
                helper.intrinsicRangeCheck(outOffset, Condition.LT, zero);
                ValueNode outLength = helper.length(nonNullOut);
                helper.intrinsicRangeCheck(helper.sub(outLength, ConstantNode.forInt(16)), Condition.LT, outOffset);
                ResolvedJavaField kField = helper.getField(AESCryptPlugin.aesCryptType(targetMethod.getDeclaringClass()), "K");
                ValueNode k = b.nullCheckedValue(helper.loadField(nonNullReceiver, kField));
                ValueNode kAddr = helper.arrayStart(k, JavaKind.Int);
                ValueNode inAddr = helper.arrayElementPointer(nonNullIn, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(nonNullOut, JavaKind.Byte, outOffset);
                HotSpotForeignCallDescriptor descriptor = this.doEncrypt ? HotSpotBackend.AESCRYPT_ENCRYPTBLOCK : HotSpotBackend.AESCRYPT_DECRYPTBLOCK;
                b.add(new ForeignCallNode((ForeignCallDescriptor)descriptor, inAddr, outAddr, kAddr));
            }
            return true;
        }
    }
}

