/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotInstructionProfiling;
import org.graalvm.compiler.hotspot.lir.HotSpotZapRegistersPhase;
import org.graalvm.compiler.hotspot.lir.VerifyMaxRegisterSizePhase;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.java.SuitesProviderBase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.SimplifyingGraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.tiers.SuitesCreator;

public class HotSpotSuitesProvider
extends SuitesProviderBase {
    protected final GraalHotSpotVMConfig config;
    protected final HotSpotGraalRuntimeProvider runtime;
    private final SuitesCreator defaultSuitesCreator;

    public HotSpotSuitesProvider(SuitesCreator defaultSuitesCreator, GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime) {
        this.defaultSuitesCreator = defaultSuitesCreator;
        this.config = config;
        this.runtime = runtime;
        this.defaultGraphBuilderSuite = this.createGraphBuilderSuite();
    }

    @Override
    public Suites createSuites(OptionValues options) {
        return this.defaultSuitesCreator.createSuites(options);
    }

    protected PhaseSuite<HighTierContext> createGraphBuilderSuite() {
        PhaseSuite<HighTierContext> suite = this.defaultSuitesCreator.getDefaultGraphBuilderSuite().copy();
        assert (this.appendGraphEncoderTest(suite));
        return suite;
    }

    private boolean appendGraphEncoderTest(PhaseSuite<HighTierContext> suite) {
        suite.appendPhase(new BasePhase<HighTierContext>(){

            @Override
            protected void run(StructuredGraph graph, HighTierContext context) {
                EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph(graph, HotSpotSuitesProvider.this.runtime.getTarget().arch);
                StructuredGraph targetGraph = new StructuredGraph.Builder(graph.getOptions(), graph.getDebug(), StructuredGraph.AllowAssumptions.YES).method(graph.method()).trackNodeSourcePosition(graph.trackNodeSourcePosition()).build();
                SimplifyingGraphDecoder graphDecoder = new SimplifyingGraphDecoder(HotSpotSuitesProvider.this.runtime.getTarget().arch, targetGraph, context, true);
                graphDecoder.decode(encodedGraph);
            }

            @Override
            protected CharSequence getName() {
                return "VerifyEncodingDecoding";
            }
        });
        return true;
    }

    public static PhaseSuite<HighTierContext> withNodeSourcePosition(PhaseSuite<HighTierContext> gbs) {
        PhaseSuite<HighTierContext> newGbs = gbs.copy();
        GraphBuilderPhase graphBuilderPhase = (GraphBuilderPhase)newGbs.findPhase(GraphBuilderPhase.class).previous();
        GraphBuilderConfiguration graphBuilderConfig = graphBuilderPhase.getGraphBuilderConfig();
        GraphBuilderPhase newGraphBuilderPhase = new GraphBuilderPhase(graphBuilderConfig.withNodeSourcePosition(true));
        newGbs.findPhase(GraphBuilderPhase.class).set(newGraphBuilderPhase);
        return newGbs;
    }

    @Override
    public LIRSuites createLIRSuites(OptionValues options) {
        String profileInstructions;
        LIRSuites suites = this.defaultSuitesCreator.createLIRSuites(options);
        if (Assertions.detailedAssertionsEnabled(options)) {
            suites.getPostAllocationOptimizationStage().appendPhase(new HotSpotZapRegistersPhase());
        }
        if ((profileInstructions = HotSpotBackend.Options.ASMInstructionProfiling.getValue(options)) != null) {
            suites.getPostAllocationOptimizationStage().appendPhase(new HotSpotInstructionProfiling(profileInstructions));
        }
        if (Assertions.assertionsEnabled()) {
            suites.getFinalCodeAnalysisStage().appendPhase(new VerifyMaxRegisterSizePhase(this.config.maxVectorSize));
        }
        return suites;
    }
}

